/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.Tokenizer;

public class OperationTokenDescription
implements ITokenDescription {
    public static final int OPERATION = 12;
    static String[] OPS = new String[]{"&&", "||", "==", "!=", "<=", ">=", "+", "-", "*", "/", "&", "%", "|", "?", ":", "^", "<", ">"};
    private static final String[] OPS_2 = new String[]{"div", "and", "or", "not", "mod", "eq", "ne", "lt", "gt", "ge", "le"};
    public static OperationTokenDescription INSTANCE = new OperationTokenDescription();

    @Override
    public String getName() {
        return ElCoreMessages.OperationTokenDescription_Name;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public boolean isStart(Tokenizer tokenizer, int offset) {
        int end = -1;
        boolean canBeFollowedByOperand = true;
        int i = 0;
        while (end < 0 && i < OPS.length) {
            if (tokenizer.startsWith(OPS[i])) {
                end = offset + OPS[i].length();
            }
            ++i;
        }
        i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
                canBeFollowedByOperand = false;
            }
            ++i;
        }
        if (end < 0) {
            return false;
        }
        char ch = tokenizer.lookUpChar(end);
        return Character.isWhitespace(ch) || ch == '\u0000' || !Character.isJavaIdentifierPart(ch) || canBeFollowedByOperand && Character.isJavaIdentifierPart(ch) || ch == '\'' || ch == '\"' || ch == '-';
    }

    @Override
    public boolean read(Tokenizer tokenizer, int offset) {
        if (!this.isStart(tokenizer, offset)) {
            return false;
        }
        int end = -1;
        int i = 0;
        while (end < 0 && i < OPS.length) {
            if (tokenizer.startsWith(OPS[i])) {
                end = offset + OPS[i].length();
            }
            ++i;
        }
        i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
            }
            ++i;
        }
        tokenizer.addToken(12, offset, end);
        return true;
    }
}

