/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.scanner.internal;

import java.io.File;
import org.jboss.tools.archives.scanner.internal.MatchPattern;

public class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name, File.separator);
        return this.matches(name, tokenized, isCaseSensitive);
    }

    public boolean matches(String name, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        int i = 0;
        while (i < tokenizedName.length) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
            ++i;
        }
        MatchPattern[] matchPatternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            MatchPattern pattern = matchPatternArray[n2];
            if (pattern.matchPath(name, tokenizedNameChar, isCaseSensitive)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matchesPatternStart(String name, boolean isCaseSensitive) {
        MatchPattern[] matchPatternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            MatchPattern includesPattern = matchPatternArray[n2];
            if (includesPattern.matchPatternStart(name, isCaseSensitive)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static MatchPatterns from(String ... sources) {
        int length = sources.length;
        MatchPattern[] result = new MatchPattern[length];
        int i = 0;
        while (i < length) {
            result[i] = MatchPattern.fromString(sources[i]);
            ++i;
        }
        return new MatchPatterns(result);
    }
}

