/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.view.server.jmx;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.wtp.ui.WTPOveridePlugin;
import org.jboss.tools.jmx.core.IConnectionFacade;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;

public class JMXProvider {
    private static final IWorkbenchPart bringViewToFront(String viewId) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart part = null;
        if (window != null && (page = window.getActivePage()) != null) {
            part = page.findView(viewId);
            if (part == null) {
                part = page.showView(viewId);
            } else if (part != null) {
                page.activate((IWorkbenchPart)part);
                part.setFocus();
            }
        }
        return part;
    }

    private static IConnectionWrapper adaptServerToConnection(IServer server) {
        IConnectionFacade facade;
        IConnectionWrapper wrapper = (IConnectionWrapper)server.loadAdapter(IConnectionWrapper.class, (IProgressMonitor)new NullProgressMonitor());
        if (wrapper == null && (facade = (IConnectionFacade)server.loadAdapter(IConnectionFacade.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            wrapper = facade.getJMXConnection();
        }
        if (wrapper == null) {
            IConnectionFacade facade2;
            IAdaptable ada;
            ServerDelegate sd = (ServerDelegate)server.loadAdapter(ServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (sd != null && sd instanceof IConnectionFacade) {
                wrapper = ((IConnectionFacade)sd).getJMXConnection();
            } else if (sd instanceof IAdaptable && (wrapper = (IConnectionWrapper)(ada = (IAdaptable)sd).getAdapter(IConnectionWrapper.class)) == null && (facade2 = (IConnectionFacade)ada.getAdapter(IConnectionFacade.class)) != null) {
                wrapper = facade2.getJMXConnection();
            }
        }
        return wrapper;
    }

    public static class ActionProvider
    extends CommonActionProvider {
        private ICommonActionExtensionSite actionSite;
        private ShowInJMXViewAction showInJMXViewAction;

        public void init(ICommonActionExtensionSite aSite) {
            super.init(aSite);
            this.actionSite = aSite;
            this.createActions(aSite);
        }

        protected void createActions(ICommonActionExtensionSite aSite) {
            StructuredViewer v;
            ICommonViewerSite site = aSite.getViewSite();
            if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
                CommonViewer cfr_ignored_0 = (CommonViewer)v;
                ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
                this.showInJMXViewAction = new ShowInJMXViewAction(wsSite.getSelectionProvider());
            }
        }

        public void fillContextMenu(IMenuManager menu) {
            IServer server;
            IContributionItem quick;
            ICommonViewerSite site = this.actionSite.getViewSite();
            IStructuredSelection selection = null;
            if (site instanceof ICommonViewerWorkbenchSite) {
                ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
                selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            }
            if ((quick = menu.find("org.eclipse.ui.navigate.showInQuickMenu")) != null && selection != null && selection.toArray().length == 1 && selection.getFirstElement() instanceof IServer && JMXProvider.adaptServerToConnection(server = (IServer)selection.getFirstElement()) != null && menu instanceof MenuManager) {
                ((MenuManager)quick).add((IAction)this.showInJMXViewAction);
            }
        }

        public class ShowInJMXViewAction
        extends AbstractServerAction {
            private IStructuredSelection previousSelection;
            private IServerListener serverListener;

            public ShowInJMXViewAction(ISelectionProvider sp) {
                super(sp, null);
                IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
                IViewDescriptor desc = reg.find("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
                this.setText(desc.getLabel());
                this.setImageDescriptor(desc.getImageDescriptor());
                this.serverListener = new IServerListener(){

                    public void serverChanged(final ServerEvent event) {
                        if (ShowInJMXViewAction.this.previousSelection != null && ShowInJMXViewAction.this.previousSelection.size() > 0 && ShowInJMXViewAction.this.previousSelection.getFirstElement().equals(event.getServer())) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (UnitedServerListener.serverSwitchesToState((ServerEvent)event, (int)2)) {
                                        ShowInJMXViewAction.this.setEnabled(true);
                                    } else if (UnitedServerListener.serverSwitchesToState((ServerEvent)event, (int)4)) {
                                        ShowInJMXViewAction.this.setEnabled(false);
                                    }
                                }
                            });
                        }
                    }
                };
                this.selectionChanged(sp.getSelection());
            }

            public boolean accept(IServer server) {
                boolean preconditions = server.getServerType() != null && JMXProvider.adaptServerToConnection(server) != null && server.getServerState() == 2;
                return preconditions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selectionChanged(IStructuredSelection sel) {
                if (sel.size() == 0 || sel.size() > 1) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(true);
                ShowInJMXViewAction showInJMXViewAction = this;
                synchronized (showInJMXViewAction) {
                    this.switchListener(this.previousSelection, sel);
                    this.previousSelection = sel;
                }
                super.selectionChanged(sel);
            }

            private void switchListener(IStructuredSelection previousSelection, IStructuredSelection newSel) {
                Object newSel1;
                Object o;
                if (previousSelection != null && (o = previousSelection.getFirstElement()) instanceof IServer) {
                    ((IServer)o).removeServerListener(this.serverListener);
                }
                if ((newSel1 = newSel.getFirstElement()) instanceof IServer) {
                    ((IServer)newSel1).addServerListener(this.serverListener);
                }
            }

            public void perform(final IServer server) {
                JMXNavigator view;
                IWorkbenchPart part = null;
                try {
                    part = JMXProvider.bringViewToFront("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
                }
                catch (PartInitException pie) {
                    WTPOveridePlugin.getInstance().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.ui", "Error loading MBean Explorer", (Throwable)pie));
                }
                if (part != null && (view = (JMXNavigator)part.getAdapter(JMXNavigator.class)) != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IConnectionWrapper connection = JMXProvider.adaptServerToConnection(server);
                            if (connection != null) {
                                view.getCommonViewer().collapseAll();
                                view.getCommonViewer().expandToLevel(2);
                                StructuredSelection sel = new StructuredSelection(new Object[]{connection});
                                view.getCommonViewer().setSelection((ISelection)sel, true);
                            }
                        }
                    });
                }
            }
        }
    }

    public static class ContentProvider
    implements ITreeContentProvider {
        private MBeanExplorerContentProvider delegate = new MBeanExplorerContentProvider();

        public Object[] getChildren(Object parentElement) {
            IConnectionWrapper sel;
            if (parentElement instanceof IServer && (sel = JMXProvider.adaptServerToConnection((IServer)parentElement)) != null) {
                return new Object[]{sel};
            }
            return this.delegate.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return this.delegate.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.delegate.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.delegate.getElements(inputElement);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.delegate.inputChanged(viewer, oldInput, newInput);
        }
    }

    public static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private MBeanExplorerLabelProvider delegate = new MBeanExplorerLabelProvider();

        public void dispose() {
            this.delegate.dispose();
        }

        public String getText(Object element) {
            if (element instanceof IConnectionWrapper) {
                return "JMX";
            }
            return this.delegate.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IConnectionWrapper) {
                return WTPOveridePlugin.getInstance().getSharedImages().image("icons/jmeth_obj.gif");
            }
            return this.delegate.getImage(element);
        }
    }
}

