/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import tern.TernProject;
import tern.eclipse.ide.core.ITernServerFactory;
import tern.eclipse.ide.core.ITernServerType;
import tern.server.ITernServer;
import tern.server.ITernServerListener;

public class TernServerType
implements ITernServerType {
    private final String id;
    private final String name;
    private final ITernServerFactory factory;
    private final List<ITernServer> servers = new ArrayList<ITernServer>();
    private final ITernServerListener serverListener;

    public TernServerType(IConfigurationElement element) throws CoreException {
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.factory = (ITernServerFactory)element.createExecutableExtension("factory");
        this.serverListener = new ITernServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStart(ITernServer server) {
                List list = TernServerType.this.servers;
                synchronized (list) {
                    TernServerType.this.servers.add(server);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStop(ITernServer server) {
                List list = TernServerType.this.servers;
                synchronized (list) {
                    TernServerType.this.servers.remove(server);
                }
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    ITernServerFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<ITernServer> list = this.servers;
        synchronized (list) {
            ArrayList<ITernServer> servers = new ArrayList<ITernServer>(this.servers);
            for (ITernServer server : servers) {
                server.dispose();
            }
            this.servers.clear();
        }
    }

    @Override
    public ITernServer createServer(TernProject project) throws Exception {
        ITernServer server = this.getFactory().create(project);
        server.addServerListener(this.serverListener);
        return server;
    }
}

