/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.web;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ITaggedVirtualResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.core.Messages;

public class WebUtils {
    private static final String THYM_NATURE_ID = "org.eclipse.thym.core.HybridAppNature";
    private static final String AEROGEAR_NATURE_ID = "org.jboss.tools.aerogear.hybrid.core.HybridAppNature";
    private static final String CONFIG_XML = "config.xml";
    private static final IContainer[] EMPTY_ARRAY = new IContainer[0];
    public static final String DD_FOLDER_TAG = "defaultRootSource";

    public static IPath[] getWebInfPaths(IProject project) {
        IContainer[] cs = WebUtils.getWebRootFolders(project, true);
        ArrayList<IPath> ps = new ArrayList<IPath>();
        IContainer[] iContainerArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            IFolder f = c.getFolder((IPath)new Path("/WEB-INF"));
            if (f.exists()) {
                ps.add(f.getFullPath());
            }
            ++n2;
        }
        return ps.toArray(new IPath[ps.size()]);
    }

    public static IPath[] getWebContentPaths(IProject project) {
        IContainer[] cs = WebUtils.getWebRootFolders(project, true);
        IPath[] ps = new IPath[cs.length];
        int i = 0;
        while (i < cs.length) {
            ps[i] = cs[i].getFullPath();
            ++i;
        }
        return ps;
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IContainer[] cs;
        IContainer[] iContainerArray = cs = WebUtils.getWebRootFolders(project, true);
        if (cs.length != 0) {
            IContainer c = iContainerArray[0];
            return c.getFullPath();
        }
        return null;
    }

    public static IContainer getWebRootFolder(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            IContainer[] cs = WebUtils.getWebRootFolders(project, false);
            IPath fullPath = resource.getFullPath();
            IContainer[] iContainerArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                if (c.getFullPath().isPrefixOf(fullPath)) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IContainer[] getWebRootFolders(IProject project, boolean ignoreDerived) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        IProjectFacet DYNAMIC_WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        if (facetedProject != null && facetedProject.getProjectFacetVersion(DYNAMIC_WEB_FACET) != null) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null) {
                IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
                IPath defaultPath = WebUtils.getDefaultDeploymentDescriptorFolder(webRootVirtFolder);
                IContainer defaultResource = null;
                IContainer[] folders = webRootVirtFolder.getUnderlyingFolders();
                if (folders.length > 1) {
                    ArrayList<IContainer> containers = new ArrayList<IContainer>();
                    IContainer[] iContainerArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer container = iContainerArray[n2];
                        if (!(!container.exists() || ignoreDerived && container.isDerived(512))) {
                            String path = "/" + container.getProjectRelativePath().toString();
                            if (defaultPath != null && path.equals(defaultPath.toString())) {
                                defaultResource = container;
                            } else {
                                containers.add(container);
                            }
                        }
                        ++n2;
                    }
                    if (defaultResource != null) {
                        containers.add(0, defaultResource);
                    }
                    return containers.toArray(new IContainer[containers.size()]);
                }
                return folders;
            }
        } else {
            IFolder www = WebUtils.getCordovaWebRootFolder(project);
            if (!(www == null || ignoreDerived && www.isDerived(512))) {
                return new IContainer[]{www};
            }
        }
        return EMPTY_ARRAY;
    }

    private static IFolder getCordovaWebRootFolder(IProject project) {
        IFolder webroot = null;
        IResource www = project.findMember("www");
        if (www != null && www.getType() == 2) {
            webroot = (IFolder)www;
            try {
                IResource configXml;
                IProjectNature nature = project.getNature(THYM_NATURE_ID);
                if (nature == null) {
                    nature = project.getNature(AEROGEAR_NATURE_ID);
                }
                if (!(nature != null || (configXml = project.findMember(CONFIG_XML)) != null && configXml.getType() == 1 || (configXml = webroot.findMember(CONFIG_XML)) != null && configXml.getType() == 1)) {
                    webroot = null;
                }
            }
            catch (CoreException e) {
                CommonCorePlugin.getDefault().logError(e);
            }
        }
        return webroot;
    }

    public static IResource findResource(IResource context, String filePath) {
        IFile file;
        if (filePath == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.WebUtil_NullArgument, "filePath"));
        }
        if (context == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.WebUtil_NullArgument, "context"));
        }
        IProject project = context.getProject();
        Path tmpPath = new Path(filePath);
        if (filePath.startsWith("/") && project.getLocation().isPrefixOf((IPath)tmpPath) && (file = project.getFile(tmpPath.removeFirstSegments(project.getLocation().segmentCount()))) != null && file.exists()) {
            return file;
        }
        IPath[] webContentPaths = WebUtils.getWebContentPaths(project);
        if (filePath.startsWith("/")) {
            if (webContentPaths.length > 0) {
                IPath[] iPathArray = webContentPaths;
                int n = webContentPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath webContentPath = iPathArray[n2];
                    IPath container = webContentPath.segmentCount() > 1 ? webContentPath.removeFirstSegments(1) : project.getFullPath();
                    IFile file2 = project.getFile(container.append(filePath));
                    if (file2.exists()) {
                        return file2;
                    }
                    ++n2;
                }
            } else {
                IContainer parent = context instanceof IContainer ? (IContainer)context : context.getParent();
                IPath path = new Path(filePath).makeRelative();
                while (parent != null) {
                    IFile file3 = parent.getFile(path);
                    if (file3.exists()) {
                        return file3;
                    }
                    parent = parent.getParent();
                }
            }
        } else if (webContentPaths.length > 0) {
            IContainer contextRoot = WebUtils.getWebRootFolder(context);
            if (contextRoot == null) {
                return null;
            }
            IContainer parent = context instanceof IContainer ? (IContainer)context : context.getParent();
            File contextFile = parent.getLocation().toFile();
            String contextRelatedFileName = null;
            try {
                contextRelatedFileName = new File(String.valueOf(contextFile.toString()) + File.separator + filePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
            Path contextRelatedPath = new Path(contextRelatedFileName);
            IPath webRootRelatedPath = contextRelatedPath.removeFirstSegments(contextRoot.getLocation().segmentCount());
            IPath[] iPathArray = webContentPaths;
            int n = webContentPaths.length;
            int n3 = 0;
            while (n3 < n) {
                IPath webContentPath = iPathArray[n3];
                IFile file4 = project.getFile(webContentPath.removeFirstSegments(1).append(webRootRelatedPath));
                if (file4.exists()) {
                    return file4;
                }
                ++n3;
            }
        } else {
            IFile file5 = project.getFile(context.getProjectRelativePath().removeLastSegments(1).append(filePath));
            if (file5.exists()) {
                return file5;
            }
        }
        return null;
    }

    public static String getWebPath(IFile context, IFile resource) {
        String path;
        if (context == null || !context.getProject().equals((Object)resource.getProject())) {
            IContainer root = WebUtils.getWebRootFolder((IResource)resource);
            path = root == null ? resource.getProjectRelativePath().toString() : resource.getFullPath().removeFirstSegments(root.getFullPath().segmentCount()).toString();
            if (!path.startsWith("/")) {
                return "/" + path;
            }
        } else {
            path = resource.getFullPath().makeRelativeTo(context.getParent().getFullPath()).toString();
        }
        return path;
    }

    public static IPath getDefaultDeploymentDescriptorFolder(IVirtualFolder folder) {
        IPath returnValue = null;
        if (folder instanceof ITaggedVirtualResource) {
            returnValue = ((ITaggedVirtualResource)folder).getFirstTaggedResource(DD_FOLDER_TAG);
        }
        return returnValue;
    }
}

