/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import org.eclipse.jdt.core.IMethod;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class BeanUtil {
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";

    public static boolean isGetter(String methodName, int numberOfParameters) {
        return (methodName.startsWith(GET) && !methodName.equals(GET) || methodName.startsWith(IS) && !methodName.equals(IS)) && numberOfParameters == 0;
    }

    public static boolean isSetter(String methodName, int numberOfParameters) {
        return methodName.startsWith(SET) && !methodName.equals(SET) && numberOfParameters == 1;
    }

    public static boolean isGetter(IMethod method) {
        return method != null && BeanUtil.isGetter(method.getElementName(), method.getNumberOfParameters()) && BeanUtil.checkPropertyReturnType(method);
    }

    public static boolean checkPropertyReturnType(String typeName, String methodName) {
        if (typeName == null || typeName.equals("void")) {
            return false;
        }
        return !methodName.startsWith(IS) || "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    private static boolean checkPropertyReturnType(IMethod method) {
        return method != null && BeanUtil.checkPropertyReturnType(EclipseJavaUtil.getMemberTypeAsString(method), method.getElementName());
    }

    public static boolean isSetter(IMethod method) {
        return method != null && BeanUtil.isSetter(method.getElementName(), method.getNumberOfParameters());
    }

    public static String getPropertyName(String methodName) {
        if (BeanUtil.isGetter(methodName, 0) || BeanUtil.isSetter(methodName, 1)) {
            StringBuffer name = new StringBuffer(methodName);
            if (methodName.startsWith(IS)) {
                name.delete(0, 2);
            } else {
                name.delete(0, 3);
            }
            if (name.length() < 2 || !Character.isUpperCase(name.charAt(1))) {
                name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            }
            return name.toString();
        }
        return null;
    }
}

