/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public class ArquillianValidatorConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = "ArquillianValidatorConfigurationBlock";
    private static final OptionsConfigurationBlock.Key MISSING_DEPLOYMENT_METHOD = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.missingDeploymentMethod");
    private static final OptionsConfigurationBlock.Key INVALID_ARCHIVE_NAME = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.invalidArchiveName");
    private static final OptionsConfigurationBlock.Key MISSING_TEST_METHOD = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.missingTestMethod");
    private static final OptionsConfigurationBlock.Key TYPE_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.typeIsNotIncludedInAnyDeployment");
    private static final OptionsConfigurationBlock.Key IMPORT_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.importIsNotIncludedInAnyDeployment");
    private static final OptionsConfigurationBlock.Key DEPLOYMENT_ARCHIVE_CANNOT_BE_CREATED = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"org.jboss.tools.arquillian.core.deploymentArchiveCannotBeCreated");
    private static final OptionsConfigurationBlock.Key ENABLE_ARQUILLIAN_VALIDATOR = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"enableArquillianValidator");
    private static final OptionsConfigurationBlock.Key TEST_ARQUILLIAN_CONTAINER = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)"testArquillianContainer");
    private static final OptionsConfigurationBlock.Key DEPLOYMENT_METHOD_HAS_TO_BE_STATIC_AND_PUBLIC = ArquillianValidatorConfigurationBlock.getKey((String)"org.jboss.tools.arquillian.core", (String)".deploymentMethodHasToBeStaticAndPublic");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private PixelConverter fPixelConverter;
    private OptionsConfigurationBlock.FilteredPreferenceTree fFilteredPrefTree;
    private Button enableValidation;

    public ArquillianValidatorConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ArquillianValidatorConfigurationBlock.getKeys(), container);
    }

    public static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{MISSING_DEPLOYMENT_METHOD, INVALID_ARCHIVE_NAME, MISSING_TEST_METHOD, TYPE_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, IMPORT_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, DEPLOYMENT_ARCHIVE_CANNOT_BE_CREATED, ENABLE_ARQUILLIAN_VALIDATOR, TEST_ARQUILLIAN_CONTAINER, DEPLOYMENT_METHOD_HAS_TO_BE_STATIC_AND_PUBLIC};
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        String[] enabledDisabled = new String[]{"true", "false"};
        this.addCheckBox(mainComp, "Test Arquillian Container", TEST_ARQUILLIAN_CONTAINER, enabledDisabled, 0);
        this.enableValidation = this.addCheckBox(mainComp, "Enable Validation", ENABLE_ARQUILLIAN_VALIDATOR, enabledDisabled, 0);
        this.enableValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArquillianValidatorConfigurationBlock.this.setEnableStates();
            }
        });
        this.createIgnoreOptionalProblemsLink(mainComp);
        Composite spacer = new Composite(mainComp, 0);
        spacer.setLayoutData((Object)new GridData(0, 0));
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(30);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        this.setEnableStates();
        return mainComp;
    }

    private Composite createStyleTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{"Error", "Warning", "Ignore"};
        String[] stringArray = new String[]{ERROR, WARNING};
        String[] stringArray2 = new String[]{"Error", "Warning"};
        this.fFilteredPrefTree = new OptionsConfigurationBlock.FilteredPreferenceTree((OptionsConfigurationBlock)this, folder, "&Select the severity level for the following optional problems:");
        ScrolledPageContent sc1 = this.fFilteredPrefTree.getScrolledPageContent();
        int nColumns = 3;
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        int indentStep = this.fPixelConverter.convertWidthInCharsToPixels(1);
        int defaultIndent = indentStep * 0;
        String label = "Validation";
        OptionsConfigurationBlock.Key twistieKey = OptionsConfigurationBlock.getLocalKey((String)"ArquillianValidatorConfigurationBlock_potential_problems");
        OptionsConfigurationBlock.PreferenceTreeNode section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        ExpandableComposite excomposite = this.getExpandableComposite(twistieKey);
        Composite inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = "Missing @Deployment method";
        this.fFilteredPrefTree.addComboBox(inner, label, MISSING_DEPLOYMENT_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Missing @Test method";
        this.fFilteredPrefTree.addComboBox(inner, label, MISSING_TEST_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Type is not included in any deployment";
        this.fFilteredPrefTree.addComboBox(inner, label, TYPE_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Import is not included in any deployment";
        this.fFilteredPrefTree.addComboBox(inner, label, IMPORT_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Deployment archive cannot be created";
        this.fFilteredPrefTree.addComboBox(inner, label, DEPLOYMENT_ARCHIVE_CANNOT_BE_CREATED, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Invalid archive name";
        this.fFilteredPrefTree.addComboBox(inner, label, INVALID_ARCHIVE_NAME, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = "Deployment method has to be public and static";
        this.fFilteredPrefTree.addComboBox(inner, label, DEPLOYMENT_METHOD_HAS_TO_BE_STATIC_AND_PUBLIC, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        IDialogSettings settingsSection = ArquillianUIActivator.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(settingsSection);
        return sc1;
    }

    private Composite createInnerComposite(ExpandableComposite excomposite, int nColumns, Font font) {
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(font);
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    private static boolean lessSevere(String errorWarningIgnore, String errorWarningIgnore2) {
        if (IGNORE.equals(errorWarningIgnore)) {
            return !IGNORE.equals(errorWarningIgnore2);
        }
        if (WARNING.equals(errorWarningIgnore)) {
            return ERROR.equals(errorWarningIgnore2);
        }
        return false;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = "Arquillian Validator Settings Changed";
        String message = workspaceSettings ? "The Arquillian Validator settings have changed. A full rebuild is required for changes to take effect. Do the full build now?" : "The Arquillian Validator settings have changed. A rebuild of the project is required for changes to take effect. Build the project now?";
        return new String[]{title, message};
    }

    public void dispose() {
        IDialogSettings section = ArquillianUIActivator.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(section);
        super.dispose();
    }

    private void setEnableStates() {
        boolean enabled = this.enableValidation.getSelection();
        this.setComboEnabled(MISSING_DEPLOYMENT_METHOD, enabled);
        this.setComboEnabled(INVALID_ARCHIVE_NAME, enabled);
        this.setComboEnabled(MISSING_TEST_METHOD, enabled);
        this.setComboEnabled(TYPE_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, enabled);
        this.setComboEnabled(IMPORT_IS_NOT_INCLUDED_IN_ANY_DEPLOYMENT, enabled);
        this.setComboEnabled(DEPLOYMENT_ARCHIVE_CANNOT_BE_CREATED, enabled);
        this.setComboEnabled(DEPLOYMENT_METHOD_HAS_TO_BE_STATIC_AND_PUBLIC, enabled);
    }
}

