/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.internal.container.ContainerParser;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;

public class AddArquillianProfilesDialog
extends TitleAreaDialog {
    private CheckboxTableViewer viewer;
    private IProject project;
    private Image dialogImage;
    private List<Container> containers;
    private List<String> profiles;

    public AddArquillianProfilesDialog(Shell parentShell, IProject project) {
        super(parentShell);
        Assert.isNotNull((Object)project);
        this.setShellStyle(0xC70 | AddArquillianProfilesDialog.getDefaultOrientation());
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Add Arquillian Profiles");
        this.setTitle("Add Arquillian Profiles");
        this.setMessage("Select profiles to add to the '" + this.project.getName() + "' project.");
        this.setTitleImage(this.getDialogImage());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(4, 4, true, true);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        AddArquillianProfilesDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Group profilesGroup = new Group(contents, 0);
        profilesGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, false);
        profilesGroup.setLayoutData((Object)gd);
        profilesGroup.setText("Profiles");
        this.containers = ContainerParser.getContainers();
        Collections.sort(this.containers, new Comparator<Container>(){

            @Override
            public int compare(Container c1, Container c2) {
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                String n1 = c1.getId();
                String n2 = c2.getId();
                if (n1 == null && n2 == null) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                if (n2 == null) {
                    return 1;
                }
                return n1.compareTo(n2);
            }
        });
        this.viewer = ArquillianUIUtil.createProfilesViewer((Composite)profilesGroup, this.containers, 400);
        this.profiles = ArquillianUtility.getProfiles((IProject)this.project);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddArquillianProfilesDialog.this.initializeViewer();
                AddArquillianProfilesDialog.this.validate();
            }
        });
        this.setChecked(false);
        this.initializeViewer();
        return area;
    }

    private void initializeViewer() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Container container;
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data instanceof Container && this.profiles.contains((container = (Container)data).getId())) {
                item.setBackground(Display.getCurrent().getSystemColor(15));
                this.viewer.setChecked((Object)container, true);
            }
            ++n2;
        }
    }

    private Image getDialogImage() {
        if (this.dialogImage == null) {
            this.dialogImage = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"icons/arquillian_icon64.png").createImage();
        }
        return this.dialogImage;
    }

    public boolean close() {
        if (this.dialogImage != null) {
            this.dialogImage.dispose();
        }
        return super.close();
    }

    protected void okPressed() {
        final IFile pomFile = this.project.getFile("pom.xml");
        final Object[] checkedElements = this.viewer.getCheckedElements();
        Job job = new Job("Add profiles..."){

            protected IStatus run(IProgressMonitor monitor) {
                return AddArquillianProfilesDialog.this.addProfiles(pomFile, checkedElements, monitor);
            }
        };
        job.setPriority(50);
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
        super.okPressed();
    }

    private IStatus addProfiles(IFile pomFile, Object[] checkedElements, IProgressMonitor monitor) {
        ArrayList<Container> checkedContainers = new ArrayList<Container>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Container container;
            Object element = objectArray[n2];
            if (element instanceof Container && !this.profiles.contains((container = (Container)element).getId())) {
                checkedContainers.add(container);
            }
            ++n2;
        }
        if (pomFile != null && checkedContainers.size() > 0) {
            try {
                return ArquillianUtility.addProfiles((IFile)pomFile, checkedContainers, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                ArquillianUIActivator.log(e);
            }
        }
        return Status.OK_STATUS;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 18, "Select All", false);
        this.createButton(parent, 19, "Deselect All", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void validate() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        this.getButton(0).setEnabled(checkedElements.length != 0);
        this.getButton(18).setEnabled(checkedElements.length < this.containers.size());
        this.getButton(19).setEnabled(checkedElements.length > 0);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (18 == buttonId) {
            this.selectAllPressed();
        } else if (19 == buttonId) {
            this.deselectAllPressed();
        }
        if (!this.viewer.getTable().isDisposed()) {
            this.validate();
        }
    }

    private void deselectAllPressed() {
        this.setChecked(false);
        this.initializeViewer();
    }

    private void setChecked(boolean checked) {
        for (Container container : this.containers) {
            this.viewer.setChecked((Object)container, checked);
        }
        this.viewer.refresh();
    }

    private void selectAllPressed() {
        this.setChecked(true);
    }
}

