/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.archives;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.arquillian.core.internal.archives.IEntry;

public class Entry
implements IEntry {
    private String type;
    private String path;
    private String source;
    private IEntry parent;
    private Set<IEntry> children = new LinkedHashSet<IEntry>();
    private IJavaProject javaProject;
    private String fullyQualifiedName;
    private String name;

    public Entry(IEntry parent, String type, String path, String source, IJavaProject javaProject, String fullyQualifiedName) {
        int index;
        this.parent = parent;
        this.type = type;
        this.path = path;
        this.source = source;
        this.javaProject = javaProject;
        this.fullyQualifiedName = fullyQualifiedName;
        if (path != null && (index = path.lastIndexOf("/")) >= 0) {
            this.name = path.substring(index + 1);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public IEntry getParent() {
        return this.parent;
    }

    public void setParent(IEntry parent) {
        this.parent = parent;
    }

    @Override
    public Set<IEntry> getChildren() {
        return this.children;
    }

    @Override
    public void add(IEntry entry) {
        this.children.add(entry);
    }

    @Override
    public boolean isDirectory() {
        return "Directory".equals(this.type);
    }

    @Override
    public String getName() {
        return this.name == null ? "?" : this.name;
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "Entry [path=" + this.path + ", type=" + this.type + ", parent=" + this.parent + ", children=" + this.children + ", source=" + this.source + "]";
    }
}

