/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.extract.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.extract.internal.UntarUtility;

public class UntarGZUtility
extends UntarUtility {
    public UntarGZUtility(File file) {
        super(file);
    }

    @Override
    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor progress) throws CoreException {
        String name = this.file.getName();
        progress.beginTask(NLS.bind((String)"Extracting {0}", (Object)name), 1000);
        Path path = new Path(destination.getAbsolutePath());
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx >= 0) {
            name = name.substring(slashIdx + 1);
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this.file);
                File tarFile = File.createTempFile("runtime", ".tar");
                tarFile.deleteOnExit();
                String tarName = name;
                if (slashIdx >= 0) {
                    tarName = name.substring(0, name.length() - 3);
                }
                progress.subTask(NLS.bind((String)"Extracting {0}", (Object)tarName));
                int tempSize = Integer.MAX_VALUE;
                if (this.file.length() < Integer.MAX_VALUE) {
                    tempSize = (int)this.file.length();
                }
                this.ungzip(in, tarFile, (IProgressMonitor)new SubProgressMonitor(progress, 500), tempSize);
                if (!progress.isCanceled()) {
                    in = new FileInputStream(tarFile);
                    this.untar(in, (IPath)path, (IProgressMonitor)new SubProgressMonitor(progress, 500));
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", 0, NLS.bind((String)"Error extracting runtime {0}", (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            progress.done();
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        progress.done();
        return Status.OK_STATUS;
    }

    protected void ungzip(InputStream in, File tarFile, IProgressMonitor monitor, int size) throws IOException {
        GZIPInputStream gzin = null;
        FileOutputStream fout = null;
        try {
            gzin = new GZIPInputStream(in);
            fout = new FileOutputStream(tarFile);
            this.copyWithSize(gzin, fout, monitor, size);
        }
        catch (Throwable throwable) {
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException iOException) {}
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw throwable;
        }
        if (gzin != null) {
            try {
                gzin.close();
            }
            catch (IOException iOException) {}
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

