/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.util.ListFactory;

public final class DependencySorter<K, T> {
    private final Map<K, T> keyToObject = new LinkedHashMap<K, T>();
    private final Map<T, K> objectToKey = new LinkedHashMap<T, K>();
    private final Map<K, Set<K>> dependencies = new LinkedHashMap<K, Set<K>>();

    public void add(K key, T object) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.keyToObject.containsKey(key)) {
            if (this.keyToObject.get(key) != object) {
                throw new IllegalArgumentException();
            }
        } else {
            this.keyToObject.put(key, object);
            this.objectToKey.put(object, key);
            if (this.dependencies.get(key) == null) {
                this.dependencies.put(key, new LinkedHashSet());
            }
        }
    }

    public boolean contains(K key) {
        return this.keyToObject.get(key) != null;
    }

    public void dependency(K from, K to) {
        if (from == null) {
            throw new IllegalArgumentException();
        }
        if (to == null) {
            throw new IllegalArgumentException();
        }
        Set<K> set = this.dependencies.get(from);
        if (set == null) {
            set = new LinkedHashSet<K>();
            this.dependencies.put(from, set);
        }
        set.add(to);
    }

    public List<T> sort() {
        if (this.keyToObject.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> roots = new ArrayList<T>();
        for (K key : this.dependencies.keySet()) {
            T object;
            boolean bl = false;
            for (Set<K> dependencies : this.dependencies.values()) {
                if (!dependencies.contains(key)) continue;
                bl = true;
                break;
            }
            if (bl || (object = this.keyToObject.get(key)) == null) continue;
            roots.add(object);
        }
        HashSet visited = new HashSet();
        for (Object e : roots) {
            this.visit(e, visited);
        }
        block3: while (visited.size() != this.keyToObject.size()) {
            for (T t : this.keyToObject.values()) {
                if (visited.contains(t)) continue;
                roots.add(t);
                this.visit(t, visited);
                continue block3;
            }
        }
        ListFactory listFactory = ListFactory.start();
        visited.clear();
        for (Object e : roots) {
            this.traverse(e, visited, listFactory);
        }
        return listFactory.result();
    }

    private void visit(T object, Set<T> visited) {
        if (visited.contains(object)) {
            return;
        }
        visited.add(object);
        for (K key : this.dependencies.get(this.objectToKey.get(object))) {
            T x = this.keyToObject.get(key);
            if (x == null) continue;
            this.visit(x, visited);
        }
    }

    private void traverse(T object, Set<T> visited, ListFactory<T> result) {
        if (visited.contains(object)) {
            return;
        }
        visited.add(object);
        for (K key : this.dependencies.get(this.objectToKey.get(object))) {
            T x = this.keyToObject.get(key);
            if (x == null) continue;
            this.traverse(x, visited, result);
        }
        result.add(object);
    }
}

