/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyVisitor;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ModelBasedPossibleValuesService
extends PossibleValuesService {
    private ModelPath path;
    private Listener listener;

    @Override
    protected void initPossibleValuesService() {
        final Property property = this.context(Property.class);
        Element element = property.element();
        PossibleValues a = property.definition().getAnnotation(PossibleValues.class);
        this.path = new ModelPath(a.property());
        String invalidValueMessage = a.invalidValueMessage();
        if (invalidValueMessage.length() > 0) {
            this.invalidValueMessage = invalidValueMessage;
        }
        this.invalidValueSeverity = a.invalidValueSeverity();
        this.ordered = a.ordered();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!property.disposed()) {
                    ModelBasedPossibleValuesService.this.refresh();
                }
            }
        };
        try {
            element.attach(this.listener, this.path);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    protected void compute(final Set<String> values) {
        Element element = this.context(Element.class);
        if (!element.disposed()) {
            element.visit(this.path, new PropertyVisitor(){

                @Override
                public boolean visit(Value<?> property) {
                    String text = property.text();
                    if (text != null) {
                        values.add(text);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.path = null;
        if (this.listener != null) {
            this.context(Element.class).detach(this.listener, this.path);
            this.listener = null;
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PossibleValues possibleValuesAnnotation;
            Property property = context.find(Property.class);
            return (property instanceof Value || property instanceof ElementList) && (possibleValuesAnnotation = property.definition().getAnnotation(PossibleValues.class)) != null && possibleValuesAnnotation.property().length() > 0;
        }
    }
}

