/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.angularjs.core.AngularNature;
import org.eclipse.angularjs.core.BaseModel;
import org.eclipse.angularjs.core.CustomAngularModulesRegistry;
import org.eclipse.angularjs.core.ModulesFolder;
import org.eclipse.angularjs.core.ScriptsFolder;
import org.eclipse.angularjs.internal.core.Trace;
import org.eclipse.angularjs.internal.core.preferences.AngularCorePreferencesSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import tern.angular.modules.AngularModulesManager;
import tern.angular.modules.Directive;
import tern.angular.modules.IAngularModulesRegistry;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Restriction;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.TernServerAdapter;

public class AngularProject
implements IDirectiveSyntax {
    private static final QualifiedName ANGULAR_PROJECT = new QualifiedName("org.eclipse.angularjs.core.sessionprops", "AngularProject");
    private static final String EXTENSION_ANGULAR_PROJECT_DESCRIBERS = "angularNatureAdapters";
    public static final String DEFAULT_START_SYMBOL = "{{";
    public static final String DEFAULT_END_SYMBOL = "}}";
    private final IProject project;
    private String startSymbol;
    private String endSymbol;
    private final Map<ITernScriptPath, List<BaseModel>> folders;
    private static List<String> angularNatureAdapters;

    AngularProject(IProject project) throws CoreException {
        this.project = project;
        this.folders = new HashMap<ITernScriptPath, List<BaseModel>>();
        final CustomAngularModulesRegistry customDirectives = new CustomAngularModulesRegistry(project);
        AngularModulesManager.getInstance().addRegistry((Object)this, (IAngularModulesRegistry)customDirectives);
        project.setSessionProperty(ANGULAR_PROJECT, (Object)this);
        this.ensureNatureIsConfigured();
        AngularProject.getTernProject(project).addServerListener((ITernServerListener)new TernServerAdapter(){

            public void onStop(ITernServer server) {
                customDirectives.clear();
            }
        });
        this.initializeSymbols();
        AngularCorePreferencesSupport.getInstance().getEclipsePreferences(project).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("startSymbol".equals(event.getKey())) {
                    AngularProject.this.startSymbol = event.getNewValue().toString();
                } else if ("endSymbol".equals(event.getKey())) {
                    AngularProject.this.endSymbol = event.getNewValue().toString();
                }
            }
        });
    }

    private void initializeSymbols() {
        this.startSymbol = AngularCorePreferencesSupport.getInstance().getStartSymbol(this.getProject());
        this.endSymbol = AngularCorePreferencesSupport.getInstance().getEndSymbol(this.getProject());
    }

    public static AngularProject getAngularProject(IProject project) throws CoreException {
        if (!AngularProject.hasAngularNature(project)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.angularjs.core", "The project " + project.getName() + " is not an angular project."));
        }
        AngularProject angularProject = (AngularProject)project.getSessionProperty(ANGULAR_PROJECT);
        if (angularProject == null) {
            angularProject = new AngularProject(project);
        }
        return angularProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public static IIDETernProject getTernProject(IProject project) throws CoreException {
        return TernCorePlugin.getTernProject((IProject)project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAngularNature(IProject project) {
        if (!project.isAccessible()) return false;
        try {
            String adaptToNature;
            if (project.hasNature("org.eclipse.angularjs.core.angularnature")) {
                return true;
            }
            List<String> angularNatureAdapters = AngularProject.getAngularNatureAdapters();
            Iterator<String> iterator = angularNatureAdapters.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!project.hasNature(adaptToNature = iterator.next()));
            return true;
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error angular nature", e);
        }
        return false;
    }

    public Collection<BaseModel> getFolders(ITernScriptPath scriptPath) {
        List<BaseModel> folders = this.folders.get(scriptPath);
        if (folders == null) {
            folders = new ArrayList<BaseModel>();
            this.folders.put(scriptPath, folders);
            folders.add(new ScriptsFolder(scriptPath));
            folders.add(new ModulesFolder(scriptPath));
        }
        return folders;
    }

    public void cleanModel() {
        this.folders.clear();
    }

    public Directive getDirective(String tagName, String name, Restriction restriction) {
        return AngularModulesManager.getInstance().getDirective((Object)this, tagName, name, restriction);
    }

    public void collectDirectives(String tagName, String directiveName, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        AngularModulesManager.getInstance().collectDirectives((Object)this, tagName, directiveName, (IDirectiveSyntax)this, existingDirectives, restriction, collector);
    }

    public boolean isUseOriginalName() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveUseOriginalName(this.project);
    }

    public boolean isStartsWithNothing() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithNothing(this.project);
    }

    public boolean isStartsWithX() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithX(this.project);
    }

    public boolean isStartsWithData() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithData(this.project);
    }

    public boolean isColonDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveColonDelimiter(this.project);
    }

    public boolean isMinusDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveMinusDelimiter(this.project);
    }

    public boolean isUnderscoreDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveUnderscoreDelimiter(this.project);
    }

    private static synchronized void loadAngularProjectDescribers() {
        if (angularNatureAdapters != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .angularProjectDescribers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.angularjs.core", EXTENSION_ANGULAR_PROJECT_DESCRIBERS);
        ArrayList<String> list = new ArrayList<String>(cf.length);
        AngularProject.addAngularNatureAdapters(cf, list);
        angularNatureAdapters = list;
        Trace.trace((byte)7, "-<- Done loading .angularProjectDescribers extension point -<-");
    }

    private static synchronized void addAngularNatureAdapters(IConfigurationElement[] cf, List<String> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add(ce.getAttribute("id"));
                Trace.trace((byte)7, "  Loaded project describer: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load project describers: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    private static List<String> getAngularNatureAdapters() {
        if (angularNatureAdapters == null) {
            AngularProject.loadAngularProjectDescribers();
        }
        return angularNatureAdapters;
    }

    private void ensureNatureIsConfigured() throws CoreException {
        AngularNature tempAngularNature = new AngularNature();
        tempAngularNature.setProject(this.project);
        if (!tempAngularNature.isConfigured()) {
            tempAngularNature.configure();
        }
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }
}

