/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.ui.contentassist;

import java.util.Collection;
import java.util.List;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.AngularDOMUtils;
import org.eclipse.angularjs.core.utils.AngularELRegion;
import org.eclipse.angularjs.core.utils.AngularRegionUtils;
import org.eclipse.angularjs.core.utils.AngularScopeHelper;
import org.eclipse.angularjs.core.utils.DOMUtils;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.angularjs.internal.ui.contentassist.AngularMarkupCompletionProposal;
import org.eclipse.angularjs.internal.ui.contentassist.HTMLAngularCompletionProposal;
import org.eclipse.angularjs.internal.ui.contentassist.JSAngularCompletionProposal;
import org.eclipse.angularjs.internal.ui.contentassist.MarkupAngularCompletionProposal;
import org.eclipse.angularjs.internal.ui.utils.DOMUIUtils;
import org.eclipse.angularjs.internal.ui.utils.HTMLAngularPrinter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tern.angular.AngularType;
import tern.angular.modules.AngularModulesManager;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveParameterCollector;
import tern.angular.modules.Restriction;
import tern.angular.protocol.TernAngularQuery;
import tern.angular.protocol.completions.TernAngularCompletionsQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.server.ITernServer;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;

public class HTMLAngularTagsCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private static final String CLASS_ATTR = "class";

    protected void addAttributeNameProposals(final ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        final IDOMNode element = (IDOMNode)contentAssistRequest.getNode();
        if (AngularDOMUtils.hasAngularNature((IDOMNode)element)) {
            IProject p = DOMUtils.getFile((IDOMNode)element).getProject();
            Directive directive = AngularDOMUtils.getAngularDirective((IProject)p, (Node)element);
            if (directive != null) {
                String paramName = contentAssistRequest.getMatchString();
                AngularModulesManager.getInstance().collectDirectiveParameters(directive, paramName, new IDirectiveParameterCollector(){

                    public void add(DirectiveParameter parameter) {
                        HTMLAngularTagsCompletionProposalComputer.this.addDirectiveParameter(contentAssistRequest, parameter, element);
                    }
                });
            } else {
                String tagName = element.getNodeName();
                String directiveName = contentAssistRequest.getMatchString();
                IDOMAttr attr = DOMUtils.getAttrByRegion((IDOMNode)element, (ITextRegion)contentAssistRequest.getRegion());
                List existingDirectives = AngularDOMUtils.getAngularDirectives((IProject)p, (Element)(element instanceof Element ? (Element)element : null), (Attr)attr);
                AngularProject project = null;
                try {
                    project = AngularProject.getAngularProject((IProject)p);
                }
                catch (CoreException coreException) {}
                project.collectDirectives(tagName, directiveName, existingDirectives, Restriction.A, new IDirectiveCollector(){

                    public void add(Directive directive, String name) {
                        String displayString = String.valueOf(name) + " - " + directive.getModule().getName();
                        String additionalProposalInfo = HTMLAngularPrinter.getDirectiveInfo(directive);
                        Image image = ImageResource.getImage("directive");
                        HTMLAngularTagsCompletionProposalComputer.this.addProposal(contentAssistRequest, name, directive.getDirectiveValue(), directive, displayString, image, additionalProposalInfo, element);
                    }

                    public void add(DirectiveParameter parameter) {
                        HTMLAngularTagsCompletionProposalComputer.this.addDirectiveParameter(contentAssistRequest, parameter, element);
                    }
                });
            }
        }
        super.addAttributeNameProposals(contentAssistRequest, context);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IDOMNode element = (IDOMNode)contentAssistRequest.getNode();
        if (AngularDOMUtils.hasAngularNature((IDOMNode)element)) {
            AngularType angularType;
            IDOMAttr attr = DOMUtils.getAttrByRegion((IDOMNode)element, (ITextRegion)contentAssistRequest.getRegion());
            Directive directive = AngularDOMUtils.getAngularDirectiveByRegion((IDOMNode)element, (ITextRegion)contentAssistRequest.getRegion());
            AngularType angularType2 = angularType = directive != null ? directive.getType() : null;
            if (angularType != null) {
                if (angularType.equals((Object)AngularType.unknown) || angularType.equals((Object)AngularType.repeat_expression)) {
                    angularType = AngularType.model;
                }
                int startIndex = contentAssistRequest.getMatchString().startsWith("\"") || contentAssistRequest.getMatchString().startsWith("'") ? 1 : 0;
                this.populateAngularProposals(contentAssistRequest, element, context.getDocument(), angularType, startIndex);
            } else {
                String matchingString = contentAssistRequest.getMatchString();
                String startSymbol = "{{";
                try {
                    AngularProject angularProject = AngularProject.getAngularProject((IProject)DOMUtils.getFile((IDOMNode)element).getProject());
                    startSymbol = angularProject.getStartSymbol();
                }
                catch (CoreException coreException) {}
                int index = matchingString.lastIndexOf(startSymbol);
                if (index != -1) {
                    this.populateAngularProposals(contentAssistRequest, element, context.getDocument(), AngularType.model, index);
                } else if (CLASS_ATTR.equals(attr.getName())) {
                    this.addClassAttributeValueProposals(contentAssistRequest, context, attr);
                }
            }
        }
        super.addAttributeValueProposals(contentAssistRequest, context);
    }

    public void addClassAttributeValueProposals(final ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IDOMAttr attr) {
        int documentPosition = context.getInvocationOffset();
        int length = documentPosition - contentAssistRequest.getStartOffset();
        String text = attr.getValue().substring(0, length - 1);
        final int index = text.lastIndexOf(";");
        if (index != -1) {
            text = text.substring(index + 1, text.length());
        }
        String matchingString = text.trim();
        AngularProject project = null;
        try {
            project = AngularProject.getAngularProject((IProject)DOMUtils.getFile((IDOMNode)attr).getProject());
        }
        catch (CoreException coreException) {}
        project.collectDirectives(null, matchingString, null, Restriction.C, new IDirectiveCollector(){

            public void add(Directive directive, String name) {
                String displayString = String.valueOf(name) + " - " + directive.getModule().getName();
                String additionalProposalInfo = HTMLAngularPrinter.getDirectiveInfo(directive);
                Image image = ImageResource.getImage("directive");
                this.addProposal(contentAssistRequest, name, directive.getDirectiveValue(), displayString, image, additionalProposalInfo);
            }

            public void add(DirectiveParameter parameter) {
            }

            private void addProposal(ContentAssistRequest contentAssistRequest2, String name, DirectiveValue directiveValue, String displayString, Image image, String additionalProposalInfo) {
                String replacementString = directiveValue == DirectiveValue.none ? name : String.valueOf(name) + ":";
                int replacementOffset = contentAssistRequest2.getReplacementBeginPosition();
                int replacementLength = contentAssistRequest2.getReplacementLength();
                if (index != -1) {
                    replacementOffset += index;
                    replacementLength += index;
                }
                int cursorPosition = HTMLAngularTagsCompletionProposalComputer.getCursorPositionForProposedText((String)replacementString);
                IContextInformation contextInformation = null;
                int relevance = 0;
                HTMLAngularCompletionProposal proposal = new HTMLAngularCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
                contentAssistRequest2.addProposal((ICompletionProposal)proposal);
            }
        });
    }

    private void populateAngularProposals(final ContentAssistRequest contentAssistRequest, IDOMNode element, IDocument document, final AngularType angularType, Integer startIndex) {
        IFile file = DOMUtils.getFile((IDOMNode)element);
        IProject eclipseProject = file.getProject();
        try {
            IIDETernProject ternProject = AngularProject.getTernProject((IProject)eclipseProject);
            String expression = this.getExpression(contentAssistRequest, startIndex);
            final int replacementOffset = this.getReplacementOffset(contentAssistRequest, angularType, element.getNodeType() != 3);
            TernAngularCompletionsQuery query = new TernAngularCompletionsQuery(angularType);
            query.setExpression(expression);
            ITernScriptPath scriptPath = AngularScopeHelper.populateScope((Node)element, (IFile)file, (AngularType)angularType, (TernAngularQuery)query);
            ITernCompletionCollector collector = new ITernCompletionCollector(){

                public void addProposal(String name, String type, String doc, String url, String origin, int pos, Object completion, ITernServer ternServer) {
                    Object proposal = null;
                    if (HTMLAngularTagsCompletionProposalComputer.this.isModuleOrController(angularType)) {
                        MarkupAngularCompletionProposal markupPproposal = new MarkupAngularCompletionProposal(name, type, doc, url, origin, pos, completion, ternServer, angularType, replacementOffset);
                        String replacementString = "\"" + name + "\"";
                        int replacementLength = contentAssistRequest.getReplacementLength();
                        int cursorPosition = HTMLAngularTagsCompletionProposalComputer.getCursorPositionForProposedText((String)replacementString) - 2;
                        markupPproposal.setReplacementString(replacementString);
                        markupPproposal.setReplacementLength(replacementLength);
                        markupPproposal.setCursorPosition(cursorPosition);
                        markupPproposal.setReplacementOffset(replacementOffset);
                        markupPproposal.setImage(HTMLAngularPrinter.getImage(angularType));
                        proposal = markupPproposal;
                    } else {
                        proposal = new JSAngularCompletionProposal(name, type, doc, url, origin, pos, completion, ternServer, angularType, replacementOffset);
                    }
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                }
            };
            if (scriptPath != null) {
                ternProject.request((TernQuery)query, query.getFiles(), scriptPath, collector);
            } else {
                ternProject.request((TernQuery)query, query.getFiles(), (Node)element, file, document, collector);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while tern completion.", e);
        }
    }

    private String getExpression(ContentAssistRequest contentAssistRequest, Integer startIndex) {
        String expression = contentAssistRequest.getMatchString();
        if (startIndex != null) {
            expression = expression.substring(startIndex, expression.length());
        }
        return expression;
    }

    private int getReplacementOffset(ContentAssistRequest contentAssistRequest, AngularType angularType, boolean isAttr) {
        int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
        if (isAttr && !this.isModuleOrController(angularType)) {
            replacementOffset += contentAssistRequest.getMatchString().length();
        }
        return replacementOffset;
    }

    protected ContentAssistRequest computeCompletionProposals(String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode, CompletionProposalInvocationContext context) {
        boolean isXMLContent;
        String regionType = completionRegion.getType();
        boolean bl = isXMLContent = regionType == "XML_CONTENT";
        if (isXMLContent && AngularDOMUtils.hasAngularNature((IDOMNode)xmlnode)) {
            int documentPosition = context.getInvocationOffset();
            IStructuredDocumentRegion documentRegion = DOMUIUtils.getStructuredDocumentRegion(context.getViewer(), documentPosition);
            String match = null;
            AngularELRegion angularRegion = AngularRegionUtils.getAngularELRegion((IStructuredDocumentRegion)documentRegion, (int)documentPosition, (IProject)DOMUtils.getFile((IDOMNode)treeNode).getProject());
            if (angularRegion != null) {
                match = angularRegion.getExpression().substring(0, angularRegion.getExpressionOffset());
            }
            if (match != null) {
                ContentAssistRequest contentAssistRequest = new ContentAssistRequest((Node)treeNode, treeNode.getParentNode(), documentRegion, completionRegion, documentPosition, 0, match);
                this.populateAngularProposals(contentAssistRequest, treeNode, context.getDocument(), AngularType.model, null);
                return contentAssistRequest;
            }
        }
        return super.computeCompletionProposals(matchString, completionRegion, treeNode, xmlnode, context);
    }

    protected void addTagNameProposals(final ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        if (AngularDOMUtils.hasAngularNature((IDOMNode)node)) {
            String directiveName = contentAssistRequest.getMatchString();
            AngularProject project = null;
            try {
                project = AngularProject.getAngularProject((IProject)DOMUtils.getFile((IDOMNode)node).getProject());
            }
            catch (CoreException coreException) {}
            project.collectDirectives("any", directiveName, null, Restriction.E, new IDirectiveCollector(){

                public void add(Directive directive, String name) {
                    String displayString = String.valueOf(name) + " - " + directive.getModule().getName();
                    String additionalProposalInfo = HTMLAngularPrinter.getDirectiveInfo(directive);
                    Image image = ImageResource.getImage("directive");
                    this.addProposal(contentAssistRequest, directive, name, displayString, image, additionalProposalInfo);
                }

                public void add(DirectiveParameter parameter) {
                }

                private void addProposal(ContentAssistRequest contentAssistRequest2, Directive directive, String name, String displayString, Image image, String additionalProposalInfo) {
                    StringBuilder replacementString = new StringBuilder("");
                    replacementString.append(name);
                    Collection parameters = directive.getParameters();
                    for (DirectiveParameter parameter : parameters) {
                        if (parameter.isOptionnal()) continue;
                        replacementString.append(" ").append(parameter.getName()).append("=\"\"");
                    }
                    replacementString.append(">");
                    replacementString.append("</");
                    replacementString.append(name);
                    replacementString.append(">");
                    int replacementOffset = contentAssistRequest2.getReplacementBeginPosition();
                    int replacementLength = contentAssistRequest2.getReplacementLength();
                    int cursorPosition = HTMLAngularTagsCompletionProposalComputer.getCursorPositionForProposedText((String)replacementString.toString());
                    IContextInformation contextInformation = null;
                    int relevance = 1200;
                    AngularMarkupCompletionProposal proposal = new AngularMarkupCompletionProposal(replacementString.toString(), replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
                    contentAssistRequest2.addProposal((ICompletionProposal)proposal);
                }
            });
        }
        super.addTagNameProposals(contentAssistRequest, childPosition, context);
    }

    private boolean isModuleOrController(AngularType angularType) {
        return angularType == AngularType.module || angularType == AngularType.controller;
    }

    public void addDirectiveParameter(ContentAssistRequest contentAssistRequest, DirectiveParameter parameter, IDOMNode element) {
        if (this.hasParameterAttribute(parameter, element)) {
            return;
        }
        Directive directive = parameter.getDirective();
        String displayString = String.valueOf(parameter.getName()) + " - " + directive.getModule().getName() + "#" + directive.getName();
        String additionalProposalInfo = HTMLAngularPrinter.getDirectiveParameterInfo(parameter);
        Image image = ImageResource.getImage("directive_param");
        this.addProposal(contentAssistRequest, parameter.getName(), DirectiveValue.required, null, displayString, image, additionalProposalInfo, element);
    }

    public boolean hasParameterAttribute(DirectiveParameter parameter, IDOMNode element) {
        return element.getNodeType() == 1 && element instanceof Element && ((Element)element).hasAttribute(parameter.getName());
    }

    private void addProposal(ContentAssistRequest contentAssistRequest, String name, DirectiveValue directiveValue, Directive directive, String displayString, Image image, String additionalProposalInfo, IDOMNode element) {
        StringBuilder replacementString = new StringBuilder(name);
        if (directiveValue != DirectiveValue.none) {
            replacementString.append("=\"\"");
        }
        if (directive != null) {
            Collection parameters = directive.getParameters();
            for (DirectiveParameter parameter : parameters) {
                if (parameter.isOptionnal() || this.hasParameterAttribute(parameter, element)) continue;
                replacementString.append(" ").append(parameter.getName()).append("=\"\"");
            }
        }
        int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        int cursorPosition = HTMLAngularTagsCompletionProposalComputer.getCursorPositionForProposedText((String)replacementString.toString());
        IContextInformation contextInformation = null;
        int relevance = 900;
        HTMLAngularCompletionProposal proposal = new HTMLAngularCompletionProposal(replacementString.toString(), replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }
}

