/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.views;

import org.eclipse.angularjs.core.AngularElement;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.IDefinitionAware;
import org.eclipse.angularjs.core.Module;
import org.eclipse.angularjs.core.link.AngularLinkHelper;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.angularjs.internal.ui.views.actions.GoToDefinitionAction;
import org.eclipse.angularjs.internal.ui.views.actions.LinkToControllerAction;
import org.eclipse.angularjs.internal.ui.views.actions.RefreshExplorerAction;
import org.eclipse.angularjs.internal.ui.views.actions.TerminateTernServerAction;
import org.eclipse.angularjs.internal.ui.views.actions.UnLinkToControllerAction;
import org.eclipse.angularjs.internal.ui.views.viewers.AngularExplorerContentProvider;
import org.eclipse.angularjs.internal.ui.views.viewers.AngularExplorerLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import tern.angular.AngularType;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.scriptpath.IScriptResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.protocol.definition.ITernDefinitionCollector;

public class AngularExplorerView
extends ViewPart
implements ISelectionListener,
ITernDefinitionCollector,
ITernServerListener {
    private IWorkbenchPart currentEditor;
    private IIDETernProject currentTernProject;
    private IResource currentResource;
    private TreeViewer viewer;
    private TerminateTernServerAction terminateAction;
    private LinkToControllerAction linkAction;
    private UnLinkToControllerAction unLinkAction;
    private GoToDefinitionAction openAction;
    private RefreshExplorerAction refreshAction;
    private IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AngularExplorerView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AngularExplorerView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AngularExplorerView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AngularExplorerView.this.getSite().getId())) {
                AngularExplorerView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };

    public void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new AngularExplorerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AngularExplorerLabelProvider(this));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AngularExplorerView.this.updateEnabledActions();
            }
        });
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(false);
        tree.setLinesVisible(false);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Tree tree = (Tree)e.getSource();
                if (tree.getSelectionCount() > 0) {
                    Object firstSelection = tree.getSelection()[0].getData();
                    AngularExplorerView.this.tryOpenInEditor(firstSelection);
                }
            }
        });
        this.registerActions();
        this.registerContextMenu();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        this.updateEnabledActions();
    }

    private void updateEnabledActions() {
        this.linkAction.setEnabled(false);
        this.unLinkAction.setEnabled(false);
        this.openAction.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Object firstSelection = selection.getFirstElement();
            this.openAction.setEnabled(firstSelection instanceof IScriptResource || firstSelection instanceof IDefinitionAware);
            Module module = null;
            AngularElement controller = null;
            if (firstSelection instanceof Module) {
                module = (Module)firstSelection;
            } else if (firstSelection instanceof AngularElement && AngularType.controller == ((AngularElement)firstSelection).getAngularType()) {
                controller = (AngularElement)firstSelection;
                module = controller.getModule();
            }
            IResource resource = this.getCurrentResource();
            if (resource != null && module != null) {
                boolean isLinked = AngularLinkHelper.isSameController((IResource)resource, (ITernScriptPath)module.getScriptPath(), (String)module.getName(), (String)(controller != null ? controller.getName() : null), null);
                this.updateEnabledLinkActions(isLinked);
            }
        }
    }

    public void registerActions() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        this.terminateAction = new TerminateTernServerAction(this);
        manager.add((IAction)this.terminateAction);
        this.linkAction = new LinkToControllerAction(this);
        manager.add((IAction)this.linkAction);
        this.unLinkAction = new UnLinkToControllerAction(this);
        manager.add((IAction)this.unLinkAction);
        this.openAction = new GoToDefinitionAction(this);
        manager.add((IAction)this.openAction);
        this.refreshAction = new RefreshExplorerAction(this);
        manager.add((IAction)this.refreshAction);
    }

    private void registerContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)this.linkAction);
        contextMenu.add((IAction)this.unLinkAction);
        contextMenu.add((IAction)this.openAction);
        contextMenu.add((IAction)this.refreshAction);
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this) || part.equals(this.currentEditor)) {
            return;
        }
        this.terminateAction.setEnabled(false);
        this.currentEditor = part;
        if (part != null && part instanceof IEditorPart) {
            IProject project;
            IResource resource;
            this.currentResource = null;
            IEditorInput sel = ((IEditorPart)part).getEditorInput();
            if (sel instanceof IAdaptable && (resource = (IResource)((IAdaptable)sel).getAdapter(IResource.class)) != null && AngularProject.hasAngularNature((IProject)(project = resource.getProject()))) {
                try {
                    boolean projectChanged;
                    IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                    boolean bl = projectChanged = !ternProject.equals(this.currentTernProject);
                    if (projectChanged) {
                        ternProject.addServerListener((ITernServerListener)this);
                        if (this.currentTernProject != null) {
                            this.currentTernProject.removeServerListener((ITernServerListener)this);
                        }
                    }
                    this.currentTernProject = ternProject;
                    this.terminateAction.setEnabled(!this.currentTernProject.isServerDisposed());
                    this.currentResource = resource;
                    if (projectChanged) {
                        this.viewer.setInput((Object)this.currentTernProject.getScriptPaths());
                    } else {
                        this.refreshTree(true);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        if (this.currentTernProject != null) {
            this.currentTernProject.removeServerListener((ITernServerListener)this);
        }
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    public IIDETernProject getCurrentTernProject() {
        return this.currentTernProject;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void refreshTree(boolean updateLabels) {
        if (!updateLabels) {
            try {
                if (this.getCurrentTernProject() != null) {
                    AngularProject angularProject = AngularProject.getAngularProject((IProject)this.getCurrentTernProject().getProject());
                    angularProject.cleanModel();
                }
            }
            catch (CoreException coreException) {}
        }
        Object[] expandedElements = this.viewer.getExpandedElements();
        TreePath[] expandedTreePaths = this.viewer.getExpandedTreePaths();
        this.viewer.refresh(updateLabels);
        this.viewer.setExpandedElements(expandedElements);
        this.viewer.setExpandedTreePaths(expandedTreePaths);
    }

    public void updateEnabledLinkActions(boolean isLinked) {
        this.linkAction.setEnabled(!isLinked);
        this.unLinkAction.setEnabled(isLinked);
    }

    public void tryOpenInEditor(Object firstSelection) {
        if (firstSelection instanceof ITernScriptPath) {
            ITernScriptPath scriptPath = (ITernScriptPath)firstSelection;
            IResource resource = scriptPath.getResource();
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                this.tryToOpenFile(file, file.getFullPath().makeRelative().toString(), null, null);
            }
        } else if (firstSelection instanceof IScriptResource) {
            IScriptResource scriptResource = (IScriptResource)firstSelection;
            IFile file = scriptResource.getFile();
            this.tryToOpenFile(file, scriptResource.getLabel(), null, null);
        } else if (firstSelection instanceof IDefinitionAware) {
            ((IDefinitionAware)firstSelection).findDefinition((ITernDefinitionCollector)this);
        }
    }

    private void tryToOpenFile(IFile file, String filename, Long start, Long end) {
        IStatus status = this.openFile(file, filename, start, end);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)AngularUIMessages.AngularExplorerView_openFileDialog_title, (String)status.getMessage(), (IStatus)status);
        }
    }

    private IStatus openFile(IFile file, String filename, Long start, Long end) {
        if (file == null && filename != null) {
            file = (IFile)this.getCurrentTernProject().getFileManager().getFile(filename);
        }
        if (file == null) {
            return new Status(4, "org.eclipse.angularjs.ui", NLS.bind((String)AngularUIMessages.AngularExplorerView_openFile_error, (Object)(filename != null ? filename : "null")));
        }
        if (!file.exists()) {
            return new Status(4, "org.eclipse.angularjs.ui", NLS.bind((String)AngularUIMessages.AngularExplorerView_openFile_error, (Object)file.getFullPath()));
        }
        EditorUtils.openInEditor((IFile)file, (int)(start != null ? start.intValue() : 0), (int)(end != null ? end.intValue() - start.intValue() : 0), (boolean)true);
        return Status.OK_STATUS;
    }

    public void setDefinition(String filename, Long start, Long end) {
        this.tryToOpenFile(null, filename, start, end);
    }

    public void onStart(ITernServer server) {
        this.terminateAction.setEnabled(true);
    }

    public void onStop(ITernServer server) {
        this.terminateAction.setEnabled(false);
    }
}

