/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.handlers;

import java.util.LinkedList;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import tern.eclipse.ide.core.TernCorePlugin;

public class ConvertProjectToAngularCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IProject project = this.getSelectedProject(event);
        if (project == null) {
            return null;
        }
        WorkspaceJob convertJob = new WorkspaceJob(AngularUIMessages.ConvertProjectToAngular_converting_project_job_title){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                boolean adoptedToTern = TernCorePlugin.hasTernNature((IProject)project);
                IProjectDescription projectDescription = project.getDescription();
                LinkedList<String> newNatures = new LinkedList<String>();
                String[] natures = projectDescription.getNatureIds();
                boolean recreateTernNature = false;
                int c = 0;
                while (c < natures.length) {
                    if ("tern.eclipse.ide.core.ternnature".equals(natures[c])) {
                        recreateTernNature = true;
                    }
                    if (!"org.eclipse.angularjs.core.angularnature".equals(natures[c]) && !"tern.eclipse.ide.core.ternnature".equals(natures[c])) {
                        newNatures.add(natures[c]);
                    }
                    ++c;
                }
                if (!adoptedToTern || recreateTernNature) {
                    newNatures.add("tern.eclipse.ide.core.ternnature");
                }
                newNatures.add("org.eclipse.angularjs.core.angularnature");
                projectDescription.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                project.setDescription(projectDescription, monitor);
                return Status.OK_STATUS;
            }
        };
        convertJob.setUser(true);
        convertJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        convertJob.schedule();
        return null;
    }

    private IProject getSelectedProject(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)currentSelection).getFirstElement();
            return (IProject)Platform.getAdapterManager().getAdapter(element, IProject.class);
        }
        return null;
    }
}

