/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.keys.KeySequence;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private TableViewer fTableViewer;
    protected StringMatcher fStringMatcher;
    private ICommand fInvokingCommand;
    private KeySequence[] fInvokingCommandKeySequences;
    private Composite fViewMenuButtonComposite;
    private IAction fShowViewMenuAction;
    private HandlerSubmission fShowViewMenuHandlerSubmission;
    private int fTableStyle;
    protected IType fInitiallySelectedType;

    public AbstractInformationControl(Shell parent, int shellStyle, int tableStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle, true, true, false, true, true, null, null);
        if (invokingCommandId != null) {
            ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
            this.fInvokingCommand = commandManager.getCommand(invokingCommandId);
            if (this.fInvokingCommand != null && !this.fInvokingCommand.isDefined()) {
                this.fInvokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.fTableStyle = tableStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.fTableViewer = this.createTableViewer(parent, this.fTableStyle);
        final Table table = this.fTableViewer.getTable();
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                if (table.equals(e.getSource())) {
                    TableItem o;
                    if (this.fLastItem == null ^ (o = table.getItem(new Point(e.x, e.y))) == null) {
                        table.setCursor(o == null ? null : table.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TableItem) {
                        Rectangle clientArea = table.getClientArea();
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        } else if (e.y - clientArea.y < table.getItemHeight() / 4) {
                            Point p = table.toDisplay(e.x, e.y);
                            Item item = AbstractInformationControl.this.fTableViewer.scrollUp(p.x, p.y);
                            if (item instanceof TableItem) {
                                this.fLastItem = (TableItem)item;
                                table.setSelection(new TableItem[]{this.fLastItem});
                            }
                        } else if (clientArea.y + clientArea.height - e.y < table.getItemHeight() / 4) {
                            Point p = table.toDisplay(e.x, e.y);
                            Item item = AbstractInformationControl.this.fTableViewer.scrollDown(p.x, p.y);
                            if (item instanceof TableItem) {
                                this.fLastItem = (TableItem)item;
                                table.setSelection(new TableItem[]{this.fLastItem});
                            }
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (table.equals(e.getSource())) {
                    TableItem o = table.getItem(new Point(e.x, e.y));
                    TableItem selection = table.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.fTableViewer.getControl();
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int tableStyle) {
        this(parent, shellStyle, tableStyle, null, false);
    }

    protected abstract TableViewer createTableViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTableViewer.getTable().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTableViewer.getTable().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractInformationControl.this.fTableViewer.refresh();
            }
        });
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTableViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof IHyperlink) {
            ((IHyperlink)selectedElement).open();
        }
    }

    protected void selectFirstMatch() {
        Widget selectedElement = this.fTableViewer.testFindItem((Object)this.fInitiallySelectedType);
        Table table = this.fTableViewer.getTable();
        TableItem element = selectedElement instanceof TableItem ? this.findElement(new TableItem[]{(TableItem)selectedElement}) : this.findElement(table.getItems());
        if (element != null) {
            table.setSelection(element);
            table.showItem(element);
        } else {
            this.fTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private TableItem findElement(TableItem[] items) {
        return this.findElement(items, null, true);
    }

    private TableItem findElement(TableItem[] items, TableItem[] toBeSkipped, boolean allowToGoUp) {
        if (this.fStringMatcher == null) {
            return items.length > 0 ? items[0] : null;
        }
        ILabelProvider labelProvider = (ILabelProvider)this.fTableViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            TableItem item = items[i];
            IHyperlink element = (IHyperlink)item.getData();
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText((Object)element))) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fInitiallySelectedType = null;
        this.fTableViewer.setInput(newInput);
        if (newSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.removeHandlerAndKeyBindingSupport();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public int open() {
        this.addHandlerAndKeyBindingSupport();
        return super.open();
    }

    protected Control getFocusControl() {
        return this.fFilterText;
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.removeHandlerAndKeyBindingSupport();
        this.fTableViewer = null;
        this.fFilterText = null;
    }

    protected void addHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission == null) {
            this.fShowViewMenuHandlerSubmission = new HandlerSubmission(null, this.getShell(), null, this.fShowViewMenuAction.getActionDefinitionId(), (IHandler)new ActionHandler(this.fShowViewMenuAction), Priority.MEDIUM);
            PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    protected void removeHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission != null) {
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    public boolean hasContents() {
        return this.fTableViewer != null && this.fTableViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected final ICommand getInvokingCommand() {
        return this.fInvokingCommand;
    }

    protected final KeySequence[] getInvokingCommandKeySequences() {
        List list;
        if (this.fInvokingCommandKeySequences == null && this.getInvokingCommand() != null && !(list = this.getInvokingCommand().getKeySequenceBindings()).isEmpty()) {
            this.fInvokingCommandKeySequences = new KeySequence[list.size()];
            int i = 0;
            while (i < this.fInvokingCommandKeySequences.length) {
                this.fInvokingCommandKeySequences[i] = ((IKeySequenceBinding)list.get(i)).getKeySequence();
                ++i;
            }
            return this.fInvokingCommandKeySequences;
        }
        return this.fInvokingCommandKeySequences;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.fFilterText = this.createFilterText(parent);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.fFilterText = this.createFilterText(parent);
        return this.fFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.fFilterText, this.fTableViewer.getTable()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTableViewer.getTable()});
        }
    }
}

