/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.refactoring;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.proposals.EditAnnotator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class MarkerResolutionUtils {
    public static final String DOT = ".";
    public static final String DOTS = "...";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String AT = "@";
    public static final String IMPLEMENTS = "implements";
    public static final String IMPORT = "import";
    public static final String STATIC = "static";
    public static final String EXTENDS = "extends";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String OPEN_BOLD = "<b>";
    public static final String CLOSE_BOLD = "</b>";
    public static final String OPEN_DEL = "<del>";
    public static final String CLOSE_DEL = "</del>";
    public static final String NEW_LINE = "\n";
    public static final String LINE_BREAK = "<br>";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String PROTECTED = "protected";
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_CARRIAGE_RETURN = '\r';
    public static final char C_NEW_LINE = '\n';
    public static final HashSet<String> primitives = new HashSet();

    static {
        primitives.add("void");
        primitives.add("int");
        primitives.add("java.lang.Integer");
        primitives.add("char");
        primitives.add("java.lang.Character");
        primitives.add("boolean");
        primitives.add("java.lang.Boolean");
        primitives.add("short");
        primitives.add("java.lang.Short");
        primitives.add("long");
        primitives.add("java.lang.Long");
        primitives.add("float");
        primitives.add("java.lang.Float");
        primitives.add("double");
        primitives.add("java.lang.Double");
        primitives.add("byte");
        primitives.add("java.lang.Byte");
        primitives.add("java.lang.String");
        primitives.add("java.lang.SuppressWarnings");
    }

    public static boolean addImport(String qualifiedName, ICompilationUnit compilationUnit) throws JavaModelException {
        return MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, false, null);
    }

    public static boolean addImport(String qualifiedName, ICompilationUnit compilationUnit, MultiTextEdit rootEdit) throws JavaModelException {
        return MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, false, rootEdit);
    }

    public static boolean addImport(String qualifiedName, ICompilationUnit compilationUnit, boolean staticFlag) throws JavaModelException {
        return MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, staticFlag, null);
    }

    private static int findPositionForImport(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit.getImportContainer().exists()) {
            return compilationUnit.getImportContainer().getSourceRange().getOffset() + compilationUnit.getImportContainer().getSourceRange().getLength();
        }
        IPackageDeclaration[] packageDeclarations = compilationUnit.getPackageDeclarations();
        if (packageDeclarations.length == 0) {
            return 0;
        }
        int position = 0;
        IPackageDeclaration[] iPackageDeclarationArray = packageDeclarations;
        int n = packageDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageDeclaration declaration = iPackageDeclarationArray[n2];
            position = declaration.getSourceRange().getOffset() + declaration.getSourceRange().getLength();
            ++n2;
        }
        return position;
    }

    private static boolean isDuplicate(MultiTextEdit rootEdit, String text) {
        TextEdit[] textEditArray = rootEdit.getChildren();
        int n = textEditArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit = textEditArray[n2];
            if (edit instanceof InsertEdit && ((InsertEdit)edit).getText().equals(text)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean addImport(String qualifiedName, ICompilationUnit compilationUnit, boolean staticFlag, MultiTextEdit rootEdit) throws JavaModelException {
        if (primitives.contains(qualifiedName) || qualifiedName.indexOf(DOT) < 0) {
            return false;
        }
        if (qualifiedName != null) {
            IType importDeclarations;
            IType type;
            IPackageDeclaration packageDeclaration;
            String shortName = MarkerResolutionUtils.getShortName(qualifiedName);
            IPackageDeclaration[] packages = compilationUnit.getPackageDeclarations();
            String typePackage = qualifiedName.substring(0, qualifiedName.lastIndexOf(DOT));
            IPackageDeclaration[] iPackageDeclarationArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                packageDeclaration = iPackageDeclarationArray[n2];
                if (packageDeclaration.getElementName().equals(typePackage)) {
                    return false;
                }
                ++n2;
            }
            iPackageDeclarationArray = packages;
            n = packages.length;
            n2 = 0;
            while (n2 < n) {
                packageDeclaration = iPackageDeclarationArray[n2];
                type = compilationUnit.getJavaProject().findType(String.valueOf(packageDeclaration.getElementName()) + DOT + shortName);
                if (type != null && type.exists()) {
                    return true;
                }
                ++n2;
            }
            type = importDeclarations = compilationUnit.getImports();
            int n3 = ((IImportDeclaration[])type).length;
            n = 0;
            while (n < n3) {
                IImportDeclaration importDeclaration = type[n];
                String importName = importDeclaration.getElementName();
                String elementShort = MarkerResolutionUtils.getShortName(importName);
                if (importDeclaration.isOnDemand()) {
                    int importLastDot = importName.lastIndexOf(DOT);
                    if (importLastDot == -1) {
                        return false;
                    }
                    int elementLastDot = qualifiedName.lastIndexOf(DOT);
                    if (elementLastDot == -1) {
                        return false;
                    }
                    if (qualifiedName.substring(0, elementLastDot).equals(importName.substring(0, importLastDot))) {
                        return false;
                    }
                }
                if (importName.equals(qualifiedName)) {
                    return false;
                }
                if (elementShort.equals(shortName)) {
                    return true;
                }
                ++n;
            }
            if (rootEdit == null) {
                if (staticFlag) {
                    compilationUnit.createImport(qualifiedName, null, 8, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    compilationUnit.createImport(qualifiedName, null, (IProgressMonitor)new NullProgressMonitor());
                }
            } else {
                String text;
                String staticStr = "";
                if (staticFlag) {
                    staticStr = "static ";
                }
                if (!MarkerResolutionUtils.isDuplicate(rootEdit, text = String.valueOf(compilationUnit.findRecommendedLineSeparator()) + IMPORT + SPACE + staticStr + qualifiedName + SEMICOLON)) {
                    int importPosition = MarkerResolutionUtils.findPositionForImport(compilationUnit);
                    InsertEdit edit = new InsertEdit(importPosition, text);
                    rootEdit.addChild((TextEdit)edit);
                }
            }
        }
        return false;
    }

    public static String getShortName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        String name = lastDot < 0 ? qualifiedName : qualifiedName.substring(lastDot + 1);
        return name;
    }

    public static String getPackageName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        String name = lastDot < 0 ? "" : qualifiedName.substring(0, lastDot);
        return name;
    }

    public static String[] getShortNames(String[] qualifiedNames) {
        String[] shortNames = new String[qualifiedNames.length];
        int i = 0;
        while (i < qualifiedNames.length) {
            shortNames[i] = MarkerResolutionUtils.getShortName(qualifiedNames[i]);
            ++i;
        }
        return shortNames;
    }

    public static String getTotalList(String[] names) {
        String list = "";
        int i = 0;
        while (i < names.length) {
            if (i != 0) {
                list = String.valueOf(list) + ", ";
            }
            list = String.valueOf(list) + names[i];
            ++i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethod(List<String> lines, ICompilationUnit compilationUnit, IType type, MultiTextEdit rootEdit) throws JavaModelException {
        IType workingCopyType = MarkerResolutionUtils.findWorkingCopy(compilationUnit, type);
        if (workingCopyType == null) {
            return;
        }
        IBuffer buffer = compilationUnit.getBuffer();
        String lineSeparator = compilationUnit.findRecommendedLineSeparator();
        int position = workingCopyType.getSourceRange().getOffset() + workingCopyType.getSource().lastIndexOf(CLOSE_BRACE);
        if (position > 0) {
            String spaces = MarkerResolutionUtils.getLeadingSpacesToInsert(position, buffer);
            int indentWidth = CodeFormatterUtil.getIndentWidth((IJavaProject)compilationUnit.getJavaProject());
            int i = 0;
            while (i < indentWidth) {
                spaces = String.valueOf(spaces) + SPACE;
                ++i;
            }
            String text = lineSeparator;
            for (String line : lines) {
                text = String.valueOf(text) + spaces;
                text = String.valueOf(text) + line;
                text = String.valueOf(text) + lineSeparator;
            }
            if (rootEdit != null) {
                InsertEdit edit = new InsertEdit(position, text);
                rootEdit.addChild((TextEdit)edit);
            } else {
                buffer.replace(position, 0, text);
                ICompilationUnit iCompilationUnit = compilationUnit;
                synchronized (iCompilationUnit) {
                    compilationUnit.reconcile(0, true, null, null);
                }
            }
        }
    }

    public static void addAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element) throws JavaModelException {
        MarkerResolutionUtils.addAnnotation(qualifiedName, compilationUnit, element, "");
    }

    public static void updateAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element, String params) throws JavaModelException {
        MarkerResolutionUtils.updateAnnotation(qualifiedName, compilationUnit, element, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element, String params, MultiTextEdit rootEdit) throws JavaModelException {
        IJavaElement workingCopyElement = MarkerResolutionUtils.findWorkingCopy(compilationUnit, element);
        if (workingCopyElement == null) {
            return;
        }
        if (!(workingCopyElement instanceof IMember)) {
            return;
        }
        IMember workingCopyMember = (IMember)workingCopyElement;
        IAnnotation annotation = MarkerResolutionUtils.findAnnotation((IJavaElement)workingCopyMember, qualifiedName);
        if (annotation == null || !annotation.exists()) {
            return;
        }
        boolean duplicateShortName = MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, null);
        IBuffer buffer = compilationUnit.getBuffer();
        String shortName = MarkerResolutionUtils.getShortName(qualifiedName);
        if (duplicateShortName) {
            shortName = qualifiedName;
        }
        String newValue = AT + shortName + params;
        if (!annotation.getSource().equals(newValue)) {
            if (rootEdit != null) {
                ReplaceEdit edit = new ReplaceEdit(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength(), newValue);
                rootEdit.addChild((TextEdit)edit);
            } else {
                buffer.replace(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength(), newValue);
                ICompilationUnit iCompilationUnit = compilationUnit;
                synchronized (iCompilationUnit) {
                    compilationUnit.reconcile(0, true, null, null);
                }
            }
        }
    }

    public static void addAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element, String params) throws JavaModelException {
        MarkerResolutionUtils.addAnnotation(qualifiedName, compilationUnit, element, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element, String params, MultiTextEdit rootEdit) throws JavaModelException {
        IJavaElement workingCopyElement = MarkerResolutionUtils.findWorkingCopy(compilationUnit, element);
        if (workingCopyElement == null) {
            return;
        }
        if (!(workingCopyElement instanceof IMember)) {
            return;
        }
        IMember workingCopyMember = (IMember)workingCopyElement;
        IAnnotation annotation = MarkerResolutionUtils.findAnnotation((IJavaElement)workingCopyMember, qualifiedName);
        if (annotation != null && annotation.exists()) {
            return;
        }
        CompilationUnit cuNode = ASTTools.buildASTRoot((ICompilationUnit)compilationUnit);
        ASTNode elementNode = null;
        if (workingCopyElement instanceof JavaElement) {
            elementNode = ((JavaElement)workingCopyElement).findNode(cuNode);
        }
        boolean duplicateShortName = MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, rootEdit);
        IBuffer buffer = compilationUnit.getBuffer();
        String shortName = MarkerResolutionUtils.getShortName(qualifiedName);
        if (duplicateShortName) {
            shortName = qualifiedName;
        }
        String str = AT + shortName + params;
        int position = workingCopyMember.getSourceRange().getOffset();
        if (elementNode != null) {
            char c;
            position = elementNode.getStartPosition();
            if (elementNode instanceof BodyDeclaration && ((BodyDeclaration)elementNode).getJavadoc() != null) {
                c = buffer.getChar(position += ((BodyDeclaration)elementNode).getJavadoc().getLength());
                while ((c == '\r' || c == '\n') && position < buffer.getLength() - 2) {
                    c = buffer.getChar(++position);
                }
            }
            while (position < buffer.getLength() - 1) {
                c = buffer.getChar(position);
                if (c != '\r' && c != '\n' && c != ' ' && c != '\t') break;
                ++position;
            }
        }
        if (!(workingCopyMember instanceof ILocalVariable)) {
            str = String.valueOf(str) + compilationUnit.findRecommendedLineSeparator();
            str = String.valueOf(str) + MarkerResolutionUtils.getLeadingSpacesToInsert(position, buffer);
        } else {
            str = String.valueOf(str) + SPACE;
        }
        if (rootEdit != null) {
            InsertEdit edit = new InsertEdit(position, str);
            rootEdit.addChild((TextEdit)edit);
        } else {
            buffer.replace(position, 0, str);
            ICompilationUnit iCompilationUnit = compilationUnit;
            synchronized (iCompilationUnit) {
                compilationUnit.reconcile(0, true, null, null);
            }
        }
    }

    public static <T extends IJavaElement> T findWorkingCopy(ICompilationUnit compilationUnit, T element) throws JavaModelException {
        block8: {
            block9: {
                block7: {
                    if (!(element instanceof IAnnotation)) break block7;
                    IJavaElement parent = MarkerResolutionUtils.findWorkingCopy(compilationUnit, element.getParent());
                    if (!(parent instanceof IAnnotatable)) break block8;
                    IAnnotation[] iAnnotationArray = ((IAnnotatable)parent).getAnnotations();
                    int n = iAnnotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation a = iAnnotationArray[n2];
                        if (a.getElementName().equals(element.getElementName())) {
                            return (T)a;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!(element instanceof ILocalVariable) || !((ILocalVariable)element).isParameter()) break block9;
                IJavaElement parent = MarkerResolutionUtils.findWorkingCopy(compilationUnit, element.getParent());
                if (!(parent instanceof IMethod)) break block8;
                ILocalVariable[] iLocalVariableArray = ((IMethod)parent).getParameters();
                int n = iLocalVariableArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ILocalVariable parameter = iLocalVariableArray[n3];
                    if (parameter.getElementName().equals(element.getElementName()) && parameter.getTypeSignature().equals(((ILocalVariable)element).getTypeSignature())) {
                        return (T)parameter;
                    }
                    ++n3;
                }
                break block8;
            }
            IJavaElement[] elements = compilationUnit.findElements(element);
            if (elements != null) {
                IJavaElement[] iJavaElementArray = elements;
                int n = elements.length;
                int n4 = 0;
                while (n4 < n) {
                    IJavaElement e = iJavaElementArray[n4];
                    if (e.getHandleIdentifier().equals(element.getHandleIdentifier())) {
                        return (T)e;
                    }
                    ++n4;
                }
            }
        }
        return null;
    }

    public static IAnnotation findAnnotation(IJavaElement element, String qualifiedName) {
        if (element instanceof IAnnotatable) {
            String name = MarkerResolutionUtils.getShortName(qualifiedName);
            IAnnotation annotation = ((IAnnotatable)element).getAnnotation(qualifiedName);
            if (annotation.exists()) {
                return annotation;
            }
            annotation = ((IAnnotatable)element).getAnnotation(name);
            if (annotation.exists()) {
                IType type = null;
                if (element instanceof IType) {
                    type = (IType)element;
                } else if (element instanceof IMember) {
                    type = ((IMember)element).getDeclaringType();
                } else if (element instanceof ITypeParameter) {
                    type = ((ITypeParameter)element).getDeclaringMember().getDeclaringType();
                } else if (element instanceof ILocalVariable) {
                    type = ((ILocalVariable)element).getDeclaringMember().getDeclaringType();
                }
                if (type != null && annotation != null && qualifiedName.equals(EclipseJavaUtil.resolveType((IType)type, (String)name))) {
                    return annotation;
                }
            }
        }
        return null;
    }

    public static void addInterfaceToClass(ICompilationUnit compilationUnit, IType type, String qualifiedName, MultiTextEdit rootEdit) throws JavaModelException {
        String shortName = MarkerResolutionUtils.getShortName(qualifiedName);
        IType[] types = compilationUnit.getTypes();
        IType workingType = null;
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (t.getElementName().equals(type.getElementName())) {
                workingType = t;
                break;
            }
            ++n2;
        }
        if (workingType != null) {
            MarkerResolutionUtils.addImport(qualifiedName, compilationUnit, rootEdit);
            IBuffer buffer = compilationUnit.getBuffer();
            String text = buffer.getText(workingType.getSourceRange().getOffset(), workingType.getSourceRange().getLength());
            int namePosition = text.indexOf(workingType.getElementName());
            if (namePosition >= 0) {
                int implementsPosition = text.indexOf(IMPLEMENTS, namePosition);
                if (implementsPosition > 0) {
                    if (rootEdit != null) {
                        InsertEdit edit = new InsertEdit(workingType.getSourceRange().getOffset() + implementsPosition + IMPLEMENTS.length(), SPACE + shortName + COMMA);
                        rootEdit.addChild((TextEdit)edit);
                    } else {
                        buffer.replace(workingType.getSourceRange().getOffset() + implementsPosition + IMPLEMENTS.length(), 0, SPACE + shortName + COMMA);
                    }
                } else {
                    int extedsPosition = text.indexOf(EXTENDS, namePosition);
                    if (extedsPosition > 0) {
                        int bracePosition = text.indexOf(OPEN_BRACE, extedsPosition);
                        String str = "implements " + shortName + SPACE;
                        if (!text.substring(bracePosition - 1, bracePosition).equals(SPACE)) {
                            str = SPACE + str;
                        }
                        if (rootEdit != null) {
                            InsertEdit edit = new InsertEdit(workingType.getSourceRange().getOffset() + bracePosition, str);
                            rootEdit.addChild((TextEdit)edit);
                        } else {
                            buffer.replace(workingType.getSourceRange().getOffset() + bracePosition, 0, str);
                        }
                    } else if (rootEdit != null) {
                        InsertEdit edit = new InsertEdit(workingType.getSourceRange().getOffset() + namePosition + workingType.getElementName().length(), " implements " + shortName);
                        rootEdit.addChild((TextEdit)edit);
                    } else {
                        buffer.replace(workingType.getSourceRange().getOffset() + namePosition + workingType.getElementName().length(), 0, " implements " + shortName);
                    }
                }
            }
        }
    }

    public static void deleteAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element) throws JavaModelException {
        MarkerResolutionUtils.deleteAnnotation(qualifiedName, compilationUnit, element, null);
    }

    public static void deleteAnnotation(String qualifiedName, ICompilationUnit compilationUnit, IJavaElement element, MultiTextEdit rootEdit) throws JavaModelException {
        IJavaElement workingCopyElement = MarkerResolutionUtils.findWorkingCopy(compilationUnit, element);
        if (workingCopyElement == null) {
            return;
        }
        IAnnotation annotation = MarkerResolutionUtils.findAnnotation(workingCopyElement, qualifiedName);
        if (annotation != null) {
            IBuffer buffer = compilationUnit.getBuffer();
            int numberOfSpaces = MarkerResolutionUtils.getNumberOfSpacesToDelete(annotation.getSourceRange().getOffset() + annotation.getSourceRange().getLength(), buffer);
            if (rootEdit != null) {
                DeleteEdit edit = new DeleteEdit(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength() + numberOfSpaces);
                rootEdit.addChild((TextEdit)edit);
            } else {
                buffer.replace(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength() + numberOfSpaces, "");
            }
            MarkerResolutionUtils.deleteImportForAnnotation(qualifiedName, annotation, compilationUnit, buffer, rootEdit);
        }
    }

    private static int getNumberOfSpacesToDelete(int startPosition, IBuffer buffer) {
        int position = startPosition;
        int numberOfSpaces = 0;
        if (position < buffer.getLength() - 1) {
            char c = buffer.getChar(position);
            while ((c == ' ' || c == '\t' || c == '\n' || c == '\r') && position < buffer.getLength() - 1) {
                ++numberOfSpaces;
                c = buffer.getChar(++position);
            }
        }
        return numberOfSpaces;
    }

    private static String getLeadingSpacesToInsert(int startPosition, IBuffer buffer) {
        int position = startPosition;
        while (position >= 0) {
            char c = buffer.getChar(position);
            if (c == '\r' || c == '\n') break;
            --position;
        }
        if (++position != startPosition) {
            return buffer.getText(position, startPosition - position);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteImportForAnnotation(String qualifiedName, IAnnotation annotation, ICompilationUnit compilationUnit, IBuffer buffer, MultiTextEdit rootEdit) throws JavaModelException {
        IImportDeclaration importDeclaration = compilationUnit.getImport(qualifiedName);
        IImportContainer importContainer = compilationUnit.getImportContainer();
        if (importDeclaration.exists() && importContainer.exists()) {
            int importSize = importContainer.getSourceRange().getOffset() + importContainer.getSourceRange().getLength();
            if (rootEdit != null) {
                int annotationStart = annotation.getSourceRange().getOffset();
                int annotationEnd = annotationStart + annotation.getSourceRange().getLength();
                String textBefore = buffer.getText(importSize, annotationStart - importSize);
                String textAfter = buffer.getText(annotationEnd, buffer.getLength() - annotationEnd);
                if (MarkerResolutionUtils.checkImport(textBefore, qualifiedName) && MarkerResolutionUtils.checkImport(textAfter, qualifiedName)) {
                    int numberOfSpaces = 0;
                    if (!MarkerResolutionUtils.isLastImport(importContainer, importDeclaration)) {
                        numberOfSpaces = MarkerResolutionUtils.getNumberOfSpacesToDelete(importDeclaration.getSourceRange().getOffset() + importDeclaration.getSourceRange().getLength(), buffer);
                    }
                    DeleteEdit edit = new DeleteEdit(importDeclaration.getSourceRange().getOffset(), importDeclaration.getSourceRange().getLength() + numberOfSpaces);
                    rootEdit.addChild((TextEdit)edit);
                }
            } else {
                String text = buffer.getText(importSize, buffer.getLength() - importSize);
                if (MarkerResolutionUtils.checkImport(text, qualifiedName)) {
                    importDeclaration.delete(false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        if (rootEdit == null) {
            ICompilationUnit iCompilationUnit = compilationUnit;
            synchronized (iCompilationUnit) {
                compilationUnit.reconcile(0, true, null, null);
            }
        }
    }

    private static boolean isLastImport(IImportContainer importContainer, IImportDeclaration importDeclaration) throws JavaModelException {
        int index = 0;
        while (index < importContainer.getChildren().length) {
            IJavaElement child = importContainer.getChildren()[index];
            if (child.equals(importDeclaration) && index == importContainer.getChildren().length - 1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static boolean checkImport(String text, String qualifiedName) {
        String name = MarkerResolutionUtils.getShortName(qualifiedName);
        Pattern p = Pattern.compile(".*\\W" + name + "\\W.*", 32);
        Matcher m = p.matcher(text);
        return !m.matches();
    }

    public static IMember getJavaMember(IJavaElement element) {
        while (element != null) {
            if (element instanceof IMember) {
                return (IMember)element;
            }
            element = element.getParent();
        }
        return null;
    }

    private static TextChange getTextChange(Change change) {
        if (change instanceof TextChange) {
            return (TextChange)change;
        }
        if (change instanceof CompositeChange) {
            Change[] changeArray = ((CompositeChange)change).getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change child = changeArray[n2];
                if (child instanceof TextChange) {
                    return (TextChange)child;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getPreview(Change original) throws CoreException {
        TextChange change;
        StringBuffer buf;
        block4: {
            if (original == null) {
                return null;
            }
            buf = new StringBuffer();
            change = MarkerResolutionUtils.getTextChange(original);
            if (change != null) break block4;
            return "";
        }
        try {
            change.setKeepPreviewEdits(true);
            IDocument previewDocument = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            EditAnnotator ea = new EditAnnotator(buf, previewDocument);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewDocument.getLength());
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return buf.toString();
    }

    public static IFile getFile() {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }
}

