/*
 * Decompiled with CFR 0.152.
 */
package tern;

import com.eclipsesource.json.JsonArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;
import tern.utils.StringUtils;

public abstract class TernFileManager<T> {
    private static final String SCRIPT_ELT = "script";
    private static final String HTTP_ATTR = "http";
    private static final String SRC_ATTR = "src";
    private static final String PROJECT_PROTOCOL = "project://";
    private final List<String> indexedFiles = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFiles(Node domNode, T domFile, TernDoc doc, JsonArray names) throws IOException {
        if (domNode == null) {
            return false;
        }
        Element scriptElt = null;
        String src = null;
        NodeList scripts = domNode.getNodeType() == 9 ? ((Document)domNode).getElementsByTagName(SCRIPT_ELT) : domNode.getOwnerDocument().getElementsByTagName(SCRIPT_ELT);
        boolean hasJS = false;
        List<String> list = this.indexedFiles;
        synchronized (list) {
            int i = 0;
            while (i < scripts.getLength()) {
                T relativeFile;
                scriptElt = (Element)scripts.item(i);
                src = scriptElt.getAttribute(SRC_ATTR);
                if (StringUtils.isEmpty(src)) {
                    hasJS = true;
                } else if (!src.startsWith(HTTP_ATTR) && (relativeFile = this.getRelativeFile(domFile, src)) != null) {
                    this.internalUpdateFile(relativeFile, doc, names);
                }
                ++i;
            }
        }
        if (hasJS && names != null) {
            String name = this.getFileName(domFile);
            names.add(name);
        }
        return hasJS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(T file, TernDoc doc, JsonArray names) throws IOException {
        List<String> list = this.indexedFiles;
        synchronized (list) {
            this.internalUpdateFile(file, doc, names);
        }
    }

    protected void addFile(String name, String text, boolean isHTML, TernDoc doc) {
        doc.addFile(name, text, isHTML, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIndexedFile(String name) {
        List<String> list = this.indexedFiles;
        synchronized (list) {
            this.internalRemoveIndexedFile(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isIndexedFile(String name) {
        List<String> list = this.indexedFiles;
        synchronized (list) {
            return this.internalIsIndexedFile(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanIndexedFiles() {
        List<String> list = this.indexedFiles;
        synchronized (list) {
            this.indexedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexedFiles(TernDoc doc) {
        if (doc.hasFiles()) {
            List<String> list = this.indexedFiles;
            synchronized (list) {
                JsonArray files = doc.getFiles();
                TernFile file = null;
                for (Object object : files) {
                    file = (TernFile)((Object)object);
                    if (this.internalIsIndexedFile(file.getName())) continue;
                    this.internalAddIndexedFile(file.getName());
                }
            }
        }
    }

    public T getFile(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.startsWith(PROJECT_PROTOCOL)) {
            int index = filename.indexOf(47, PROJECT_PROTOCOL.length());
            return this.getFile(filename.substring(PROJECT_PROTOCOL.length(), index), filename.substring(index, filename.length()));
        }
        return this.getFile(null, filename);
    }

    public String getFileName(String projectName, String path) {
        return PROJECT_PROTOCOL + projectName + "/" + path;
    }

    private void internalUpdateFile(T file, TernDoc doc, JsonArray names) throws IOException {
        String name = this.getFileName(file);
        if (!this.internalIsIndexedFile(name)) {
            String text = this.getFileContent(file);
            boolean isHTML = this.isHTML(file);
            this.addFile(name, text, isHTML, doc);
        }
        if (names != null) {
            names.add(name);
        }
    }

    private boolean internalAddIndexedFile(String name) {
        return this.indexedFiles.add(name);
    }

    private boolean internalRemoveIndexedFile(String name) {
        return this.indexedFiles.remove(name);
    }

    protected boolean internalIsIndexedFile(String name) {
        return this.indexedFiles.contains(name);
    }

    public abstract String getFileName(T var1);

    public abstract String getFileContent(T var1) throws IOException;

    public abstract T getRelativeFile(T var1, String var2);

    protected abstract T getFile(String var1, String var2);

    protected abstract boolean isHTML(T var1);
}

