/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.jboss.tools.common.ui.preferences.SeverityConfigurationBlock;

public abstract class SeverityPreferencePage
extends PropertyAndPreferencePage {
    protected Control severityConfigurationBlock;
    protected SeverityConfigurationBlock fConfigurationBlock;

    protected SeverityConfigurationBlock getConfigurationBlock() {
        return this.fConfigurationBlock;
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.getConfigurationBlock().createContents(composite);
    }

    private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager, String qualifier) {
        IEclipsePreferences node = context.getNode(qualifier);
        if (manager != null) {
            return manager.getWorkingCopy(node);
        }
        return node;
    }

    public String getStoredValue(IScopeContext context, IWorkingCopyManager manager, String qualifier, String key) {
        return this.getNode(context, manager, qualifier).get(key, null);
    }

    public String getStoredValue(IScopeContext[] lookupOrder, IWorkingCopyManager manager, String qualifier, String key) {
        int i = 0;
        while (i < lookupOrder.length) {
            String value = this.getStoredValue(lookupOrder[i], manager, qualifier, key);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager, String qualifier, String key) {
        if (value != null) {
            this.getNode(context, manager, qualifier).put(key, value);
        } else {
            this.getNode(context, manager, qualifier).remove(key);
        }
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.getConfigurationBlock().hasProjectSpecificOptions(project);
    }

    public void dispose() {
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().performDefaults();
        }
    }

    public boolean performOk() {
        if (this.getConfigurationBlock() != null && !this.getConfigurationBlock().performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.getConfigurationBlock() != null) {
            this.getConfigurationBlock().performApply();
        }
    }

    public String getLabel(String preferenceId) {
        SeverityConfigurationBlock.SectionDescription[] sectionDescriptionArray = this.getAllSections();
        int n = sectionDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityConfigurationBlock.SectionDescription section = sectionDescriptionArray[n2];
            String label = this.getLabel(section, preferenceId);
            if (label != null) {
                return label;
            }
            ++n2;
        }
        return "";
    }

    private String getLabel(SeverityConfigurationBlock.SectionDescription section, String preferenceId) {
        Object[] objectArray = section.getOptions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityConfigurationBlock.OptionDescription option = objectArray[n2];
            if (option.key.getName().equals(preferenceId)) {
                return option.label;
            }
            ++n2;
        }
        objectArray = section.getSections();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            String label = this.getLabel((SeverityConfigurationBlock.SectionDescription)s, preferenceId);
            if (label != null) {
                return label;
            }
            ++n2;
        }
        return null;
    }

    protected abstract SeverityConfigurationBlock.SectionDescription[] getAllSections();

    public void applyData(Object data) {
        if (data instanceof String) {
            this.getConfigurationBlock().doFilter((String)data);
        } else {
            super.applyData(data);
        }
    }

    public String getFilterText() {
        return this.getConfigurationBlock().getFilterControl().getText();
    }
}

