/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.text;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class HoverControlCreator
extends AbstractReusableInformationControlCreator {
    private final IInformationControlCreator fInformationPresenterControlCreator;
    private final boolean fAdditionalInfoAffordance;

    public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
        this(informationPresenterControlCreator, false);
    }

    public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
        this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        this.fAdditionalInfoAffordance = additionalInfoAffordance;
    }

    public IInformationControl doCreateInformationControl(Shell parent) {
        String tooltipAffordanceString = "Press F2 for focus";
        if (BrowserInformationControl.isAvailable((Composite)parent)) {
            String font = "org.eclipse.jface.dialogfont";
            BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tooltipAffordanceString){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return HoverControlCreator.this.fInformationPresenterControlCreator;
                }
            };
            HoverControlCreator.addLinkListener(iControl);
            return iControl;
        }
        return new DefaultInformationControl(parent, tooltipAffordanceString);
    }

    public boolean canReuse(IInformationControl control) {
        if (!super.canReuse(control)) {
            return false;
        }
        if (control instanceof IInformationControlExtension4) {
            String tooltipAffordanceString = "Press F2 for focus";
            ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
        }
        return true;
    }

    protected static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String loc = event.location;
                if ("about:blank".equals(loc)) {
                    this.handleTextSet();
                    return;
                }
                event.doit = false;
                if (loc.startsWith("about:")) {
                    return;
                }
                loc.startsWith("tern:");
                if (loc.startsWith("http")) {
                    try {
                        this.handleExternalLink(new URL(loc), event.display);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }

            private void handleTextSet() {
            }

            private void handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                Program.launch((String)url.toExternalForm());
            }
        });
    }
}

