/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.ContainerPart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.WithPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public final class RestoreDefaultsActionHandler
extends SapphireActionHandler {
    public static final String ID = "Sapphire.Restore.Defaults";
    @Text(value="Restore Defaults")
    private static LocalizableText dialogTitle;
    @Text(value="Confirm properties that should be reset to their default state. Properties that are not checked will not be modified.")
    private static LocalizableText dialogMessage;
    @Text(value="All properties in this section are presently in their default state.")
    private static LocalizableText nothingToDoMessage;

    static {
        LocalizableText.init(RestoreDefaultsActionHandler.class);
    }

    public RestoreDefaultsActionHandler() {
        this.setId(ID);
    }

    @Override
    protected Object run(Presentation context) {
        FormComponentPresentation p = (FormComponentPresentation)context;
        SapphirePart part = (SapphirePart)this.getPart();
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        RestoreDefaultsActionHandler.collectProperties(part, properties);
        Iterator itr = properties.iterator();
        while (itr.hasNext()) {
            if (!((Property)itr.next()).empty()) continue;
            itr.remove();
        }
        if (properties.isEmpty()) {
            MessageDialog.openInformation((Shell)p.shell(), (String)dialogTitle.text(), (String)nothingToDoMessage.text());
        } else {
            Set selectedProperties = PromptDialog.open(p.shell(), properties);
            for (Property property : selectedProperties) {
                property.clear();
            }
        }
        return null;
    }

    public static void collectProperties(SapphirePart part, Set<Property> result) {
        block3: {
            block5: {
                block4: {
                    if (!part.visible()) break block3;
                    if (!(part instanceof ContainerPart)) break block4;
                    for (FormComponentPart child : ((ContainerPart)part).children().visible()) {
                        RestoreDefaultsActionHandler.collectProperties(child, result);
                    }
                    break block3;
                }
                if (!(part instanceof WithPart)) break block5;
                WithPart w = (WithPart)part;
                result.add((Property)w.property());
                break block3;
            }
            if (!(part instanceof PropertyEditorPart)) break block3;
            PropertyEditorPart editor = (PropertyEditorPart)part;
            if (!editor.isReadOnly()) {
                result.add(editor.property());
            }
            for (SapphirePart sapphirePart : editor.getRelatedContent()) {
                RestoreDefaultsActionHandler.collectProperties(sapphirePart, result);
            }
        }
    }

    private static final class PromptDialog
    extends Dialog {
        private final Set<Property> allProperties;
        private final Set<Property> selectedProperties;

        private static Set<Property> open(Shell shell, Set<Property> properties) {
            PromptDialog dialog = new PromptDialog(shell, properties);
            if (dialog.open() == 0) {
                return dialog.selectedProperties;
            }
            return Collections.emptySet();
        }

        private PromptDialog(Shell shell, Set<Property> properties) {
            super(shell);
            this.allProperties = properties;
            this.selectedProperties = new HashSet<Property>(this.allProperties);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(dialogTitle.text());
            Composite composite = (Composite)super.createDialogArea(parent);
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(dialogMessage.text());
            messageLabel.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 300));
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            Table table = tableViewer.getTable();
            table.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 300), 300));
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return PromptDialog.this.allProperties.toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public String getColumnText(Object element, int columnIndex) {
                    PropertyDef property = ((Property)element).definition();
                    return property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }
            });
            tableViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return PromptDialog.this.selectedProperties.contains(element);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Property property = (Property)event.getElement();
                    if (event.getChecked()) {
                        PromptDialog.this.selectedProperties.add(property);
                    } else {
                        PromptDialog.this.selectedProperties.remove(property);
                    }
                }
            });
            tableViewer.setInput((Object)this);
            return composite;
        }
    }
}

