/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.LinePart;
import org.eclipse.sapphire.ui.diagram.editor.RectanglePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeReorderEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeUpdateEvent;
import org.eclipse.sapphire.ui.diagram.editor.SpacerPart;
import org.eclipse.sapphire.ui.diagram.editor.TextChangeEvent;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerPart;
import org.eclipse.sapphire.ui.diagram.shape.def.ContainerShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ImageDef;
import org.eclipse.sapphire.ui.diagram.shape.def.LineShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.RectangleDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeFactoryDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SpacerDef;
import org.eclipse.sapphire.ui.diagram.shape.def.TextDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ValidationMarkerDef;

public class ContainerShapePart
extends ShapePart {
    private ContainerShapeDef containerShapeDef;
    private Element modelElement;
    private List<ShapePart> children;
    private ValidationMarkerPart validationMarkerPart;
    private List<ShapeFactoryPart> shapeFactoryParts;

    @Override
    protected void init() {
        super.init();
        this.containerShapeDef = (ContainerShapeDef)this.definition;
        this.modelElement = this.getModelElement();
        this.children = new ArrayList<ShapePart>();
        this.shapeFactoryParts = new ArrayList<ShapeFactoryPart>();
        for (ShapeDef shape : this.containerShapeDef.getContent()) {
            ShapePart childPart = null;
            if (shape instanceof TextDef) {
                childPart = new TextPart();
            } else if (shape instanceof ImageDef) {
                childPart = new ImagePart();
            } else if (shape instanceof ValidationMarkerDef) {
                this.validationMarkerPart = new ValidationMarkerPart();
                childPart = this.validationMarkerPart;
            } else if (shape instanceof LineShapeDef) {
                childPart = new LinePart();
            } else if (shape instanceof RectangleDef) {
                childPart = new RectanglePart();
            } else if (shape instanceof ShapeFactoryDef) {
                childPart = new ShapeFactoryPart();
                childPart.setActive(true);
                this.shapeFactoryParts.add((ShapeFactoryPart)childPart);
            } else if (shape instanceof SpacerDef) {
                childPart = new SpacerPart();
            }
            if (childPart == null) continue;
            childPart.init(this, this.modelElement, shape, Collections.<String, String>emptyMap());
            childPart.initialize();
            this.children.add(childPart);
            childPart.attach((Listener)new FilteredListener<TextChangeEvent>(){

                protected void handleTypedEvent(TextChangeEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
            childPart.attach((Listener)new FilteredListener<ShapeUpdateEvent>(){

                protected void handleTypedEvent(ShapeUpdateEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
            childPart.attach((Listener)new FilteredListener<PartVisibilityEvent>(){

                protected void handleTypedEvent(PartVisibilityEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
            childPart.attach((Listener)new FilteredListener<PartValidationEvent>(){

                protected void handleTypedEvent(PartValidationEvent event) {
                    ContainerShapePart.this.refreshValidation();
                }
            });
            childPart.attach((Listener)new FilteredListener<ShapeReorderEvent>(){

                protected void handleTypedEvent(ShapeReorderEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
            childPart.attach((Listener)new FilteredListener<ShapeAddEvent>(){

                protected void handleTypedEvent(ShapeAddEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
            childPart.attach((Listener)new FilteredListener<ShapeDeleteEvent>(){

                protected void handleTypedEvent(ShapeDeleteEvent event) {
                    ContainerShapePart.this.broadcast(event);
                }
            });
        }
        this.refreshValidation();
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        factory.merge(super.computeValidation());
        for (SapphirePart sapphirePart : this.children) {
            if (sapphirePart instanceof ValidationMarkerPart) continue;
            factory.merge(sapphirePart.validation());
        }
        return factory.create();
    }

    public ShapeLayoutDef getLayout() {
        return this.containerShapeDef.getLayout();
    }

    @Override
    public List<ShapePart> getChildren() {
        return this.children;
    }

    public ValidationMarkerPart getValidationMarkerPart() {
        return this.validationMarkerPart;
    }

    @Override
    public boolean isEditable() {
        List<TextPart> textParts = ContainerShapePart.getContainedShapeParts(this, TextPart.class);
        for (TextPart textPart : textParts) {
            if (!textPart.isEditable()) continue;
            return true;
        }
        return false;
    }

    public List<ShapeFactoryPart> getShapeFactoryParts() {
        ArrayList<ShapeFactoryPart> shapeFactories = new ArrayList<ShapeFactoryPart>();
        shapeFactories.addAll(this.shapeFactoryParts);
        for (ShapePart shapePart : this.getChildren()) {
            if (!(shapePart instanceof ContainerShapePart)) continue;
            shapeFactories.addAll(((ContainerShapePart)shapePart).getShapeFactoryParts());
        }
        return shapeFactories;
    }

    @Override
    public List<ShapePart> getActiveChildren() {
        ArrayList<ShapePart> activeChildren = new ArrayList<ShapePart>();
        for (ShapePart child : this.getChildren()) {
            if (child.isActive()) {
                activeChildren.add(child);
            }
            activeChildren.addAll(child.getActiveChildren());
        }
        return activeChildren;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (ShapePart child : this.getChildren()) {
            child.dispose();
        }
    }
}

