/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.launching.JavaMigrationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;

public class RemoteLaunchAction
extends Action {
    private String port;

    public RemoteLaunchAction(String port) {
        this.port = port;
    }

    public void run() {
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        Object o = ss.getFirstElement();
        if (o instanceof IEditorPart) {
            this.launch((IEditorPart)o);
        } else {
            this.launch((ISelection)ss);
        }
    }

    private void launch(ISelection selection) {
        IResource resource = this.getLaunchableResource(selection);
        IJavaProject javaProject = null;
        if (resource != null) {
            IProject project = resource.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        ILaunchConfiguration config = this.createOrGetDefaultLaunchConfiguration(javaProject, selection);
        DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
    }

    private void launch(IEditorPart editor) {
        IResource resource = this.getLaunchableResource(editor);
        IJavaProject javaProject = null;
        if (resource != null) {
            IProject project = resource.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        ILaunchConfiguration config = this.createOrGetDefaultLaunchConfiguration(javaProject, null);
        DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    private IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object selected = ss.getFirstElement();
            if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
            }
            if (selected instanceof IJavaElement) {
                return ((IJavaElement)selected).getResource();
            }
        }
        return null;
    }

    private IResource getLaunchableResource(IEditorPart editorpart) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editorpart.getEditorInput());
        if (element != null) {
            try {
                return element.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected ILaunchConfiguration createOrGetDefaultLaunchConfiguration(IJavaProject javaProject, ISelection selection) {
        ILaunchConfiguration config = RemoteDebugActivator.getDefault().getDefaultLaunchConfiguration();
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            if (config != null) {
                wc = config.getWorkingCopy();
                this.setAttribute(wc);
                wc.doSave();
            } else {
                ILaunchConfigurationType configType = RemoteDebugUIActivator.getRemoteJavaApplicationConfigurationType();
                wc = RemoteDebugActivator.createNewLaunchConfiguration((ILaunchConfigurationType)configType);
            }
            if (javaProject != null && javaProject.isOpen()) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
                try {
                    JavaMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)wc);
                }
                catch (CoreException ce) {
                    RemoteDebugActivator.log((Throwable)ce);
                }
            }
            this.setAttribute(wc);
            if (selection != null) {
                RemoteDebugUIActivator.getDefault().addSelectedProjects(wc, selection, javaProject);
            }
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy wc) {
        HashMap<String, String> attrMap = new HashMap<String, String>(2);
        attrMap.put("hostname", "localhost");
        if (this.port != null) {
            attrMap.put("port", this.port);
        } else {
            attrMap.put("port", "");
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }
}

