/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.dtd.internal.DtdParserImpl;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;

public final class DtdParser {
    @Text(value="Failed while parsing DTD located at \"{0}\".")
    private static LocalizableText parseFailed;

    static {
        LocalizableText.init(DtdParser.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XmlDocumentSchema parse(URL url) {
        XmlDocumentSchema xmlDocumentSchema;
        InputStream in = null;
        try {
            in = url.openStream();
            xmlDocumentSchema = DtdParser.parse(MiscUtil.readTextContent((InputStream)in));
            if (in == null) return xmlDocumentSchema;
        }
        catch (Exception e) {
            try {
                String message = parseFailed.format(new Object[]{url});
                throw new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return xmlDocumentSchema;
        }
        catch (IOException iOException) {}
        return xmlDocumentSchema;
    }

    public static XmlDocumentSchema parse(String dtd) {
        try {
            String content = dtd;
            DtdParserImpl parser = new DtdParserImpl(new StringReader(content));
            parser.Start();
            if (!parser.entities.isEmpty()) {
                String substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                while (!content.equals(substitutedContent)) {
                    content = substitutedContent;
                    substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                }
                parser = new DtdParserImpl(new StringReader(content));
                parser.Start();
            }
            return parser.schema.create();
        }
        catch (Exception e) {
            String message = parseFailed.format(new Object[]{"##string##"});
            throw new RuntimeException(message, e);
        }
    }

    private static String substituteEntity(String content, Map<String, String> entities) {
        for (Map.Entry<String, String> entity : entities.entrySet()) {
            content = content.replace("%" + entity.getKey() + ";", entity.getValue());
        }
        return content;
    }
}

