/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.startup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimeInitializerUtil;
import org.jboss.tools.runtime.core.util.RuntimeModelUtil;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.RuntimeWorkbenchUtils;

public class JBossRuntimeStartup {
    private static final String JBOSS_RUNTIMES = "jboss-runtimes";
    private static final String USER_HOME = "user.home";
    private static final String JBOSS_EAP_HOME = "../../runtimes/jboss-eap";
    private static final String LOCATIONS_FILE_NAME = "runtime_locations.properties";
    private static final String LOCATIONS_FILE = "../../../../studio/runtime_locations.properties";
    private static final String LOCATIONS_FILE_CONFIGURATION = "../../studio/runtime_locations.properties";

    public static void initializeRuntimes(IProgressMonitor monitor) {
        JBossRuntimeStartup.initializeEAPRuntimes(monitor);
        JBossRuntimeStartup.initializeRuntimesFromDefinitionFile(monitor);
        JBossRuntimeStartup.initializeUserHomeRuntimes(monitor);
        RuntimeWorkbenchUtils.refreshServersView();
    }

    private static void initializeUserHomeRuntimes(IProgressMonitor monitor) {
        File directory;
        String userHome = System.getProperty(USER_HOME);
        if (userHome != null && (directory = new File(userHome, JBOSS_RUNTIMES)).isDirectory()) {
            RuntimeInitializerUtil.initializeRuntimesFromFolder((File)directory, (IProgressMonitor)monitor);
            RuntimePath path = new RuntimePath(directory.getAbsolutePath());
            path.setScanOnEveryStartup(true);
            RuntimeUIActivator.getDefault().getModel().addRuntimePath(path);
        }
    }

    private static void initializeEAPRuntimes(IProgressMonitor monitor) {
        File directory = JBossRuntimeStartup.getEAPDirectory();
        RuntimeInitializerUtil.initializeRuntimesFromFolder((File)directory, (IProgressMonitor)monitor);
    }

    private static void initializeRuntimesFromDefinitionFile(IProgressMonitor monitor) {
        Set<RuntimePath> runtimePaths = JBossRuntimeStartup.parseRuntimeLocationsFile();
        for (RuntimePath runtimePath : runtimePaths) {
            RuntimeInitializerUtil.createRuntimeDefinitions((RuntimePath)runtimePath, (IProgressMonitor)monitor);
        }
        if (runtimePaths.size() > 0) {
            HashSet<RuntimePath> set = new HashSet<RuntimePath>(Arrays.asList(RuntimeUIActivator.getDefault().getModel().getRuntimePaths()));
            set.addAll(runtimePaths);
            RuntimeUIActivator.getDefault().getModel().setRuntimePaths(set.toArray(new RuntimePath[set.size()]));
        }
    }

    private static File getEAPDirectory() {
        try {
            String configuration = JBossRuntimeStartup.getConfiguration();
            File directory = new File(configuration, JBOSS_EAP_HOME);
            return directory;
        }
        catch (IOException ioe) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ioe);
            return null;
        }
    }

    private static File findRuntimeFile() {
        try {
            String pluginLocation = FileLocator.resolve((URL)RuntimeUIActivator.getDefault().getBundle().getEntry("/")).getPath();
            File serversFile = new File(pluginLocation, LOCATIONS_FILE);
            if (!serversFile.isFile()) {
                String configuration = JBossRuntimeStartup.getConfiguration();
                serversFile = new File(configuration, LOCATIONS_FILE_CONFIGURATION).getCanonicalFile();
            } else {
                serversFile = serversFile.getCanonicalFile();
            }
            if (!serversFile.isFile()) {
                serversFile = new File(pluginLocation, LOCATIONS_FILE_NAME);
            }
            if (serversFile.isFile()) {
                return serversFile;
            }
        }
        catch (IOException ioe) {
            RuntimeUIActivator.pluginLog().logError((Throwable)ioe);
        }
        return null;
    }

    private static Set<RuntimePath> parseRuntimeLocationsFile() {
        File runtimeFile = JBossRuntimeStartup.findRuntimeFile();
        if (runtimeFile != null && runtimeFile.isFile()) {
            return RuntimeModelUtil.parseRuntimeFile((File)runtimeFile);
        }
        return new TreeSet<RuntimePath>();
    }

    private static String getConfiguration() throws IOException {
        Location configLocation = Platform.getConfigurationLocation();
        URL configURL = configLocation.getURL();
        String configuration = FileLocator.resolve((URL)configURL).getPath();
        return configuration;
    }
}

