/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.editors;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.jboss.ide.eclipse.as.ui.mbeans.editors.proposals.IServiceXMLOutlineActionProvider;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ServiceXMLOutlineConfiguration
extends XMLContentOutlineConfiguration {
    private ILabelProvider fLabelProvider = null;
    private IContentProvider fLocalContentProvider = null;
    private ActionManagerMenuListener fContextMenuFiller = null;

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new ServiceXMLLabelProvider(super.getLabelProvider(viewer));
        }
        return this.fLabelProvider;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        super.getContentProvider(viewer);
        if (this.fLocalContentProvider == null) {
            this.fLocalContentProvider = new ServiceXMLContentProvider();
        }
        return this.fLocalContentProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fContextMenuFiller == null) {
            this.fContextMenuFiller = new ActionManagerMenuListener(viewer);
        }
        return this.fContextMenuFiller;
    }

    private class ActionManagerMenuListener
    implements IMenuListener,
    IReleasable {
        private XMLNodeActionManager fActionManager;
        private TreeViewer fTreeViewer;
        private OutlineMenuProvider[] menuProviders = null;

        public ActionManagerMenuListener(TreeViewer viewer) {
            this.fTreeViewer = viewer;
        }

        public OutlineMenuProvider[] getProviders() {
            if (this.menuProviders == null) {
                ArrayList<OutlineMenuProvider> list = new ArrayList<OutlineMenuProvider>();
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.ui.mbeans", "ServiceXMLOutlineMenuProvider");
                int i = 0;
                while (i < cf.length) {
                    try {
                        list.add(new OutlineMenuProvider(cf[i]));
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
                this.menuProviders = list.toArray(new OutlineMenuProvider[list.size()]);
            }
            return this.menuProviders;
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (this.fActionManager == null) {
                this.fActionManager = ServiceXMLOutlineConfiguration.this.createNodeActionManager(this.fTreeViewer);
            }
            this.fActionManager.fillContextMenu(manager, this.fTreeViewer.getSelection());
            int i = 0;
            while (i < this.getProviders().length) {
                this.getProviders()[i].menuAboutToShow(manager, this.fTreeViewer.getSelection());
                ++i;
            }
        }

        public void release() {
            this.fTreeViewer = null;
            if (this.fActionManager != null) {
                this.fActionManager.setModel(null);
            }
            int i = 0;
            while (i < this.getProviders().length) {
                this.getProviders()[i].release();
                ++i;
            }
        }
    }

    private static class OutlineMenuProvider {
        private IServiceXMLOutlineActionProvider listener;

        public OutlineMenuProvider(IConfigurationElement element) throws CoreException {
            this.listener = (IServiceXMLOutlineActionProvider)element.createExecutableExtension("class");
        }

        public void menuAboutToShow(IMenuManager manager, ISelection selection) {
            if (this.listener != null) {
                this.listener.menuAboutToShow(manager, selection);
            }
        }

        public void release() {
            if (this.listener != null && this.listener instanceof IReleasable) {
                ((IReleasable)this.listener).release();
            }
        }
    }

    private class ServiceXMLContentProvider
    implements ITreeContentProvider {
        private ServiceXMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Node node = (Node)parentElement;
            ArrayList<Node> v = new ArrayList<Node>();
            NamedNodeMap map = node.getAttributes();
            if (map != null) {
                int i = 0;
                while (i < map.getLength()) {
                    Node current = map.item(i);
                    v.add(current);
                    ++i;
                }
            }
            Node child = node.getFirstChild();
            while (child != null) {
                Node n = child;
                if (n.getNodeType() != 3) {
                    v.add(n);
                }
                child = child.getNextSibling();
            }
            return v.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            Object topNode = inputElement;
            if (inputElement instanceof IDOMModel) {
                topNode = ((IDOMModel)inputElement).getDocument();
            }
            return this.getChildren(topNode);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ServiceXMLLabelProvider
    extends LabelProvider {
        private ILabelProvider delegate;

        private ServiceXMLLabelProvider(ILabelProvider delegate) {
            this.delegate = delegate;
        }

        public Image getImage(Object element) {
            try {
                return this.delegate.getImage(element);
            }
            catch (Exception exception) {
                if (element instanceof Node && ((Node)element).getNodeType() == 2) {
                    return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                }
                return null;
            }
        }

        private String getNodeName(Object object) {
            StringBuffer nodeName = new StringBuffer();
            Node node = (Node)object;
            nodeName.append(node.getNodeName());
            if (node.getNodeType() == 10) {
                nodeName.insert(0, "DOCTYPE:");
            }
            return nodeName.toString();
        }

        public String getText(Object element) {
            try {
                return this.delegate.getText(element);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

