/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import tern.eclipse.ide.tools.internal.ui.wizards.IOperation;
import tern.eclipse.ide.tools.internal.ui.wizards.ITernWizardPage;

public abstract class TernWizard<T>
extends Wizard {
    private T model;
    private IStructuredSelection selection;
    private final List<IOperation> operations = new ArrayList<IOperation>();
    private int total = 0;

    public void addOperation(IOperation operation) {
        this.operations.add(operation);
        this.total += operation.getTotal();
    }

    public void addPage(IWizardPage page) {
        if (page instanceof ITernWizardPage) {
            if (this.model == null) {
                this.model = this.createModel();
            }
            ((ITernWizardPage)page).setModel(this.model);
            ((ITernWizardPage)page).setSelection((ISelection)this.selection);
        }
        super.addPage(page);
    }

    public boolean performFinish() {
        for (IOperation operation : this.operations) {
            operation.init();
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(TernWizard.this.getTaskLabel(), TernWizard.this.total);
                try {
                    try {
                        for (IOperation operation : TernWizard.this.operations) {
                            operation.run(monitor);
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public T getModel() {
        return this.model;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected abstract T createModel();

    protected abstract String getTaskLabel();
}

