/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.gef.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.jboss.tools.common.gef.action.PrintRetargetAction;

public class ActionRegistrySupport {
    private IWorkbenchPage page;
    private ActionRegistry registry = new ActionRegistry();
    private List<IAction> retargetActions = new ArrayList<IAction>();
    private List<String> globalActionKeys = new ArrayList<String>();

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public void addGlobalActionKey(String key) {
        this.globalActionKeys.add(key);
    }

    public Iterator<String> getGlobalActionKeys() {
        return this.globalActionKeys.iterator();
    }

    public ActionRegistry getActionRegistry() {
        return this.registry;
    }

    public void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    public void addRetargetAction(IAction action) {
        this.addAction(action);
        this.retargetActions.add(action);
        if (action instanceof RetargetAction) {
            this.getPage().addPartListener((IPartListener)((RetargetAction)action));
        }
        this.addGlobalActionKey(action.getId());
    }

    public IAction getAction(String id) {
        return this.getActionRegistry().getAction((Object)id);
    }

    public void buildGEFActions() {
        this.addRetargetAction((IAction)new PrintRetargetAction());
        this.addRetargetAction((IAction)ActionFactory.DELETE.create(this.getPage().getWorkbenchWindow()));
        this.addRetargetAction((IAction)ActionFactory.COPY.create(this.getPage().getWorkbenchWindow()));
        this.addRetargetAction((IAction)ActionFactory.PASTE.create(this.getPage().getWorkbenchWindow()));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(1));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(2));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(4));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(8));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(16));
        this.addRetargetAction((IAction)new AlignmentRetargetAction(32));
        this.addRetargetAction((IAction)new ZoomInRetargetAction());
        this.addRetargetAction((IAction)new ZoomOutRetargetAction());
    }

    public void contributeGEFToToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction("Print_Diagram"));
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.getAction("org.eclipse.gef.align_left"));
        tbm.add(this.getAction("org.eclipse.gef.align_center"));
        tbm.add(this.getAction("org.eclipse.gef.align_right"));
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.getAction("org.eclipse.gef.align_top"));
        tbm.add(this.getAction("org.eclipse.gef.align_middle"));
        tbm.add(this.getAction("org.eclipse.gef.align_bottom"));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)new ZoomComboContributionItem((IPartService)this.getPage()));
    }

    public void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.PRINT.getId());
        this.addGlobalActionKey(ActionFactory.COPY.getId());
        this.addGlobalActionKey(ActionFactory.PASTE.getId());
        this.addGlobalActionKey(ActionFactory.CUT.getId());
        this.addGlobalActionKey(ActionFactory.DELETE.getId());
    }

    public void dispose() {
        if (this.retargetActions == null) {
            return;
        }
        int i = 0;
        while (i < this.retargetActions.size()) {
            RetargetAction action = (RetargetAction)this.retargetActions.get(i);
            this.getPage().removePartListener((IPartListener)action);
            ++i;
        }
        this.registry.dispose();
        this.retargetActions = null;
        this.registry = null;
    }
}

