/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.jdt.integration.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.jdt.integration.model.IArchiveLibFileSet;
import org.jboss.ide.eclipse.archives.jdt.integration.model.LibFileSetNodeProvider;
import org.jboss.ide.eclipse.archives.jdt.integration.ui.LibFilesetInfoWizardPage;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PackagesUIPlugin;

public class LibFilesetWizard
extends Wizard {
    private LibFilesetInfoWizardPage page1;
    private IArchiveLibFileSet fileset;
    private IArchiveNode parentNode;

    public LibFilesetWizard(IArchiveLibFileSet fileset, IArchiveNode parentNode) {
        this.fileset = fileset;
        this.parentNode = parentNode;
        this.setWindowTitle(ArchivesUIMessages.LibFilesetWizard);
    }

    public boolean performFinish() {
        boolean createFileset;
        boolean bl = createFileset = this.fileset == null;
        if (createFileset) {
            this.fileset = LibFileSetNodeProvider.createLibFileset();
        }
        this.fillFilesetFromPage(this.fileset);
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (createFileset) {
                        LibFilesetWizard.this.parentNode.addChild((IArchiveNode)LibFilesetWizard.this.fileset);
                    }
                    try {
                        ArchivesModel.instance().getRoot(LibFilesetWizard.this.fileset.getProjectPath()).save(monitor);
                    }
                    catch (ArchivesModelException ame) {
                        Status status = new Status(4, "org.jboss.ide.eclipse.archives.ui", ArchivesUIMessages.ErrorCompletingWizard, (Throwable)ame);
                        PackagesUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {}
        return true;
    }

    private void fillFilesetFromPage(IArchiveLibFileSet fileset) {
        fileset.setId(this.page1.getId());
    }

    public void addPages() {
        this.page1 = new LibFilesetInfoWizardPage(this.getShell(), this.fileset, this.parentNode);
        this.addPage((IWizardPage)this.page1);
    }
}

