/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.DerivedValueService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyDefaultEvent;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.ValueNormalizationService;

public class Value<T>
extends Property {
    private static final int DEFAULT_CONTENT_INITIALIZED = 16;
    private String text;
    private T content;
    private String defaultText;
    private T defaultContent;
    private boolean writing;

    public Value(Element element, ValueProperty property) {
        super(element, property);
    }

    public static <TX> Class<Value<TX>> of(Class<TX> type) {
        return Value.class;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(boolean refactor) {
        Element element = this.root();
        synchronized (element) {
            if (!this.writing) {
                this.init();
                this.refreshContent(false, refactor);
                this.refreshDefaultContent(false);
                this.refreshEnablement(false);
                this.refreshValidation(false);
            }
        }
    }

    private void refreshContent(boolean onlyIfNotInitialized) {
        this.refreshContent(onlyIfNotInitialized, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshContent(boolean onlyIfNotInitialized, boolean refactor) {
        boolean initialized;
        Value value = this;
        synchronized (value) {
            initialized = (this.initialization & 8) != 0;
        }
        if (!initialized || !onlyIfNotInitialized) {
            boolean proceed;
            String afterText;
            Object listener;
            ValueProperty p = this.definition();
            if (p.hasAnnotation(Derived.class)) {
                DerivedValueService derivedValueService = this.service(DerivedValueService.class);
                if (!initialized) {
                    listener = new Listener(){

                        @Override
                        public void handle(Event event) {
                            Value.this.refreshContent(false);
                        }
                    };
                    derivedValueService.attach((Listener)listener);
                }
                afterText = derivedValueService.value();
            } else {
                afterText = this.binding().read();
            }
            afterText = Value.normalize(this.service(ValueNormalizationService.class).normalize(p.encodeKeywords(afterText)));
            listener = this;
            synchronized (listener) {
                initialized = (this.initialization & 8) != 0;
                proceed = !initialized || !MiscUtil.equal(this.text, afterText);
            }
            if (proceed) {
                T afterContent = this.parse(p.decodeKeywords(afterText));
                ValuePropertyContentEvent event = null;
                Value value2 = this;
                synchronized (value2) {
                    String beforeText = this.text;
                    this.text = afterText;
                    this.content = afterContent;
                    if (initialized) {
                        event = new ValuePropertyContentEvent(this, beforeText, afterText, refactor);
                    } else {
                        this.initialization = (byte)(this.initialization | 8);
                    }
                }
                this.broadcast(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDefaultContent(boolean onlyIfNotInitialized) {
        boolean initialized;
        Value value = this;
        synchronized (value) {
            initialized = (this.initialization & 0x10) != 0;
        }
        if (!initialized || !onlyIfNotInitialized) {
            boolean proceed;
            ValueProperty p = this.definition();
            String afterText = null;
            DefaultValueService defaultValueService = this.service(DefaultValueService.class);
            if (defaultValueService != null) {
                if (!initialized) {
                    Listener listener = new Listener(){

                        @Override
                        public void handle(Event event) {
                            Value.this.refreshDefaultContent(false);
                        }
                    };
                    defaultValueService.attach(listener);
                }
                if ((afterText = defaultValueService.value()) != null) {
                    afterText = Value.normalize(this.service(ValueNormalizationService.class).normalize(p.encodeKeywords(afterText)));
                }
            }
            Value value2 = this;
            synchronized (value2) {
                initialized = (this.initialization & 0x10) != 0;
                proceed = !initialized || !MiscUtil.equal(this.defaultText, afterText);
            }
            if (proceed) {
                T afterContent = this.parse(p.decodeKeywords(afterText));
                PropertyDefaultEvent event = null;
                Value value3 = this;
                synchronized (value3) {
                    this.defaultText = afterText;
                    this.defaultContent = afterContent;
                    if (initialized) {
                        event = new PropertyDefaultEvent(this);
                    } else {
                        this.initialization = (byte)(this.initialization | 0x10);
                    }
                }
                this.broadcast(event);
            }
        }
    }

    @Override
    public final ValueProperty definition() {
        return (ValueProperty)super.definition();
    }

    @Override
    protected final ValuePropertyBinding binding() {
        return (ValuePropertyBinding)super.binding();
    }

    public final String text() {
        return this.text(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String text(boolean useDefaultValue) {
        this.init();
        this.refreshContent(true);
        Value value = this;
        synchronized (value) {
            if (this.text != null) {
                return this.text;
            }
        }
        if (useDefaultValue) {
            this.refreshDefaultContent(true);
            value = this;
            synchronized (value) {
                return this.defaultText;
            }
        }
        return null;
    }

    public final String localized() {
        return this.localized(true);
    }

    public final String localized(boolean useDefaultValue) {
        return this.localized(useDefaultValue, CapitalizationType.NO_CAPS, true);
    }

    public final String localized(CapitalizationType capitalizationType, boolean includeMnemonic) {
        return this.localized(true, capitalizationType, includeMnemonic);
    }

    public final String localized(boolean useDefaultValue, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String sourceLangText = this.text(useDefaultValue);
        if (sourceLangText != null) {
            return this.element().adapt(LocalizationService.class).text(sourceLangText, capitalizationType, includeMnemonic);
        }
        return null;
    }

    public final T content() {
        return this.content(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T content(boolean useDefaultValue) {
        this.init();
        this.refreshContent(true);
        Value value = this;
        synchronized (value) {
            if (this.content != null) {
                return this.content;
            }
        }
        if (useDefaultValue) {
            this.refreshDefaultContent(true);
            value = this;
            synchronized (value) {
                return this.defaultContent;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean empty() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            return this.text == null;
        }
    }

    public final T getDefaultContent() {
        this.init();
        this.refreshDefaultContent(true);
        return this.defaultContent;
    }

    public final String getDefaultText() {
        this.init();
        this.refreshDefaultContent(true);
        return this.defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean malformed() {
        this.init();
        this.refreshContent(true);
        Value value = this;
        synchronized (value) {
            if (this.text != null) {
                return this.content == null;
            }
        }
        this.refreshDefaultContent(true);
        value = this;
        synchronized (value) {
            return this.defaultText != null && this.defaultContent == null;
        }
    }

    public final void write(Object content) {
        this.write(content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Object content, boolean refactor) {
        this.init();
        ValueProperty p = this.definition();
        String text = null;
        if (content != null) {
            if (content instanceof String) {
                text = (String)content;
            } else {
                text = this.service(MasterConversionService.class).convert(content, String.class);
                if (text == null) {
                    throw new IllegalArgumentException();
                }
            }
        }
        text = Value.normalize(this.service(ValueNormalizationService.class).normalize(p.decodeKeywords(text)));
        if (!MiscUtil.equal(this.text(false), text)) {
            Element element = this.root();
            synchronized (element) {
                this.writing = true;
                try {
                    this.binding().write(text);
                }
                finally {
                    this.writing = false;
                }
                this.refresh(refactor);
            }
        }
    }

    @Override
    public final void clear() {
        this.write(null);
    }

    @Override
    public final void copy(Element source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this.definition().isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        Property p = source.property((PropertyDef)this.definition());
        if (p instanceof Value) {
            this.write(((Value)p).text(false));
        }
    }

    @Override
    public boolean holds(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public boolean holds(Property property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this == property;
    }

    public final String toString() {
        String text = this.text(false);
        return text == null ? "<null>" : text;
    }

    private T parse(String str) {
        if (str == null) {
            return null;
        }
        return (T)this.service(MasterConversionService.class).convert(str, this.definition().getTypeClass());
    }

    private static String normalize(String str) {
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }
}

