/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.model.ELParameters;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELObjectImpl;

public class ELParametersImpl
extends ELObjectImpl
implements ELParameters {
    List<ELExpression> parameters = new ArrayList<ELExpression>();

    @Override
    public LexicalToken getOpenParametersToken() {
        LexicalToken result = this.getFirstToken();
        if (result != null && result.getType() == 7) {
            return result;
        }
        return null;
    }

    @Override
    public LexicalToken getCloseParametersToken() {
        LexicalToken result = this.getLastToken();
        if (result != null && result.getType() == 9) {
            return result;
        }
        return null;
    }

    @Override
    public List<ELExpression> getParameters() {
        return this.parameters;
    }

    @Override
    public void addChild(ELObjectImpl child) {
        if (!(child instanceof ELExpressionImpl)) {
            throw new IllegalArgumentException("EL parameters can have only EL expressions as its children.");
        }
        this.addParameter((ELExpressionImpl)child);
    }

    public void addParameter(ELExpressionImpl param) {
        super.addChild(param);
        this.parameters.add(param);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        LexicalToken t = this.getOpenParametersToken();
        if (t != null) {
            sb.append(t.getText());
        }
        boolean first = true;
        for (ELExpression p : this.parameters) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(p.toString());
        }
        t = this.getCloseParametersToken();
        if (t != null) {
            sb.append(t.getText());
        }
        return sb.toString();
    }

    @Override
    public ELObjectType getType() {
        return ELObjectType.EL_PARAMETERS;
    }
}

