/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyCache;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyType;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.dialogs.ArquillianResourcesSelectionDialog;
import org.jboss.tools.arquillian.ui.internal.dialogs.ArquillianTypesSelectionDialog;
import org.jboss.tools.arquillian.ui.internal.utils.IDeploymentDescriptor;
import org.jboss.tools.arquillian.ui.internal.wizards.NewArquillianJUnitTestCasePageOne;
import org.jboss.tools.arquillian.ui.internal.wizards.NewArquillianJUnitTestWizard;
import org.jboss.tools.arquillian.ui.internal.wizards.ProjectResource;
import org.jboss.tools.arquillian.ui.internal.wizards.ResourceContentProvider;
import org.jboss.tools.arquillian.ui.internal.wizards.ResourceEditingSupport;
import org.jboss.tools.arquillian.ui.internal.wizards.TypeContentProvider;
import org.jboss.tools.arquillian.ui.internal.wizards.TypeLabelProvider;

public class NewArquillianJUnitTestCaseDeploymentPage
extends WizardPage
implements IDeploymentDescriptor {
    private static final int WEB_INF_RESOURCE_COLUMN_WIDTH = 120;
    private static final int HEIGHT_HINT = 150;
    public static final String ORG_JBOSS_TOOLS_ARQUILLIAN_UI_DEPLOYMENT_PAGE = "org.jboss.tools.arquillian.ui.deploymentPage";
    private static final int JAR_INDEX = 0;
    private static final int WAR_INDEX = 1;
    private static final int EAR_INDEX = 2;
    private static final int RAR_INDEX = 3;
    private static String[] archiveTypes = new String[]{"jar", "war", "ear", "rar"};
    private Text methodNameText;
    private Combo archiveTypeCombo;
    private Button beansXmlButton;
    private Text archiveNameText;
    private IJavaElement javaElement;
    private TableViewer typesViewer;
    private TableViewer resourcesViewer;
    private Text deploymentNameText;
    private Text deploymentOrderText;
    private Image checkboxOn;
    private Image checkboxOff;
    private TableViewerColumn webinfColumn;
    private List<IType> types;
    private List<ProjectResource> resources;
    private Combo insertionPointCombo;
    private IJavaElement[] elements;
    private List<IJavaElement> insertPositions;
    private IType type;
    private ITypeBinding typeBinding;
    private CompilationUnit compilationUnit;
    private IType classUnderTest;
    private Button removeButton;
    private Button removeAllButton;

    public NewArquillianJUnitTestCaseDeploymentPage() {
        this(null);
    }

    public NewArquillianJUnitTestCaseDeploymentPage(IJavaElement javaElement) {
        super(ORG_JBOSS_TOOLS_ARQUILLIAN_UI_DEPLOYMENT_PAGE);
        this.setTitle("Create Arquillian Deployment Method");
        this.setDescription("Create Arquillian Deployment Method");
        this.javaElement = javaElement;
        this.types = new ArrayList<IType>();
        this.resources = new ArrayList<ProjectResource>();
    }

    public void createControl(Composite parent) {
        IProject project;
        IFile pomFile;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        Label methodNameLabel = new Label(composite, 0);
        methodNameLabel.setText("Method name:");
        this.methodNameText = new Text(composite, 2048);
        this.methodNameText.setLayoutData((Object)new GridData(768));
        Label deploymentNameLabel = new Label(composite, 0);
        deploymentNameLabel.setText("Deployment name:");
        this.deploymentNameText = new Text(composite, 2048);
        this.deploymentNameText.setLayoutData((Object)new GridData(768));
        Label deploymentOrderLabel = new Label(composite, 0);
        deploymentOrderLabel.setText("Deployment order:");
        this.deploymentOrderText = new Text(composite, 2048);
        this.deploymentOrderText.setLayoutData((Object)new GridData(768));
        this.deploymentOrderText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        Display.getCurrent().beep();
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        Label archiveTypeLabel = new Label(composite, 0);
        archiveTypeLabel.setText("Archive type:");
        this.archiveTypeCombo = new Combo(composite, 8);
        this.archiveTypeCombo.setLayoutData((Object)new GridData(768));
        this.archiveTypeCombo.setItems(archiveTypes);
        Label archiveNameLabel = new Label(composite, 0);
        archiveNameLabel.setText("Archive name:");
        this.archiveNameText = new Text(composite, 2048);
        this.archiveNameText.setLayoutData((Object)new GridData(768));
        this.archiveNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewArquillianJUnitTestCaseDeploymentPage.this.validate();
            }
        });
        this.beansXmlButton = new Button(composite, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.beansXmlButton.setText("Add an empty beans.xml file");
        this.methodNameText.setText("createDeployment");
        this.archiveTypeCombo.select(0);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null && javaProject.isOpen() && (pomFile = (project = javaProject.getProject()).getFile("pom.xml")) != null && pomFile.exists()) {
            try {
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
                MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                Model model = mavenProject.getModel();
                String packaging = model.getPackaging();
                if ("war".equals(packaging)) {
                    this.archiveTypeCombo.select(1);
                }
                if ("ear".equals(packaging)) {
                    this.archiveTypeCombo.select(2);
                }
                if ("rar".equals(packaging)) {
                    this.archiveTypeCombo.select(3);
                }
            }
            catch (CoreException e1) {
                ArquillianUIActivator.log(e1);
            }
        }
        this.archiveNameText.setText("");
        this.beansXmlButton.setSelection(true);
        this.beansXmlButton.setEnabled(this.archiveTypeCombo.getSelectionIndex() != 2);
        this.methodNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewArquillianJUnitTestCaseDeploymentPage.this.validate();
            }
        });
        this.archiveTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewArquillianJUnitTestCaseDeploymentPage.this.beansXmlButton.setEnabled(NewArquillianJUnitTestCaseDeploymentPage.this.archiveTypeCombo.getSelectionIndex() != 2);
                NewArquillianJUnitTestCaseDeploymentPage.this.refreshResourceViewer();
                NewArquillianJUnitTestCaseDeploymentPage.this.validate();
            }
        });
        this.createTypesControls(composite);
        this.createResourcesControls(composite);
        if (this.javaElement instanceof ICompilationUnit && this.getType((ICompilationUnit)this.javaElement) != null) {
            Label insertionPointLabel = new Label(composite, 0);
            insertionPointLabel.setText("Insertion point:");
            this.insertionPointCombo = new Combo(composite, 8);
            this.insertionPointCombo.setLayoutData((Object)new GridData(768));
            this.type = this.getType((ICompilationUnit)this.javaElement);
            try {
                this.elements = this.type.getChildren();
            }
            catch (JavaModelException javaModelException) {
                this.elements = new IJavaElement[0];
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add("First member");
            items.add("Last member");
            this.insertPositions = new ArrayList<IJavaElement>();
            this.insertPositions.add(this.elements.length > 0 ? this.elements[0] : null);
            this.insertPositions.add(null);
            int i = 0;
            while (i < this.elements.length) {
                IJavaElement curr = this.elements[i];
                String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)curr, (long)1L);
                items.add("After '" + methodLabel + "'");
                try {
                    this.insertPositions.add(this.findSibling(curr, this.elements));
                }
                catch (JavaModelException e1) {
                    ArquillianUIActivator.log(e1);
                    this.insertPositions.add(null);
                }
                ++i;
            }
            this.insertPositions.add(null);
            this.insertionPointCombo.setItems(items.toArray(new String[0]));
            this.insertionPointCombo.select(0);
            if (this.javaElement != null) {
                IStatus status;
                String text = this.methodNameText.getText();
                javaProject = this.getJavaProject();
                IJavaProject context = null;
                if (javaProject != null) {
                    context = javaProject;
                }
                if (!(status = this.validateMethodName(text, (IJavaElement)context)).isOK()) {
                    this.setErrorMessage(status.getMessage());
                }
            }
        }
    }

    private void validate() {
        this.setMessage(null);
        this.validateMethodName();
        if (this.getErrorMessage() == null) {
            this.validateArchiveName();
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected void validateArchiveName() {
        String extension;
        String archiveName = this.archiveNameText.getText();
        if (!(archiveName.isEmpty() || archiveName.endsWith(extension = "." + this.archiveTypeCombo.getText()) && archiveName.trim().length() > 4)) {
            this.setMessage("Invalid archive name extension (expected " + extension + ")", 2);
        }
    }

    public IJavaElement getElementPosition() {
        return this.insertPositions.get(this.insertionPointCombo.getSelectionIndex());
    }

    private IJavaElement findSibling(IJavaElement curr, IJavaElement[] elements) throws JavaModelException {
        IMember res = null;
        int methodStart = ((IMember)curr).getSourceRange().getOffset();
        int i = elements.length - 1;
        while (i >= 0) {
            IMember member = (IMember)elements[i];
            if (methodStart >= member.getSourceRange().getOffset()) {
                return res;
            }
            res = member;
            --i;
        }
        return null;
    }

    private IType getType(ICompilationUnit icu) {
        IType[] types = null;
        try {
            types = icu.getTypes();
        }
        catch (JavaModelException e) {
            ArquillianUIActivator.log(e);
        }
        if (types != null && types.length > 0) {
            return types[0];
        }
        return null;
    }

    private void createResourcesControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setFont(composite.getFont());
        group.setText("Resources");
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        group.setLayoutData((Object)gd);
        this.resourcesViewer = new TableViewer((Composite)group, 68098);
        Table table = this.resourcesViewer.getTable();
        gd = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnHeaders = new String[]{"Path", "WEB-INF resource?"};
        int[] columnWidths = new int[]{250, 120};
        TableViewerColumn pathColumn = new TableViewerColumn(this.resourcesViewer, 0);
        pathColumn.setLabelProvider((CellLabelProvider)new ResourceLabelProvider(0));
        pathColumn.getColumn().setText(columnHeaders[0]);
        pathColumn.getColumn().setResizable(false);
        pathColumn.getColumn().setMoveable(false);
        pathColumn.getColumn().setWidth(columnWidths[0]);
        this.webinfColumn = new TableViewerColumn(this.resourcesViewer, 0);
        this.webinfColumn.setLabelProvider((CellLabelProvider)new ResourceLabelProvider(1));
        this.webinfColumn.getColumn().setText(columnHeaders[1]);
        this.webinfColumn.getColumn().setResizable(false);
        this.webinfColumn.getColumn().setMoveable(false);
        if ("war".equals(this.archiveTypeCombo.getText())) {
            this.webinfColumn.getColumn().setWidth(120);
        } else {
            this.webinfColumn.getColumn().setWidth(0);
        }
        this.webinfColumn.setEditingSupport((EditingSupport)new ResourceEditingSupport((ColumnViewer)this.resourcesViewer, 1));
        this.configureViewer(this.resourcesViewer);
        this.resourcesViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.createButtons(group, this.resourcesViewer, this.resources, false);
    }

    private void configureViewer(final TableViewer viewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = viewer.getColumnViewerEditor().getFocusCell();
                if (cell != null && cell.getColumnIndex() == 1) {
                    return super.isEditorActivationEvent(event);
                }
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void createTypesControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setFont(composite.getFont());
        group.setText("Classes");
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        group.setLayoutData((Object)gd);
        this.typesViewer = new TableViewer((Composite)group, 68098);
        gd = new GridData(1808);
        this.typesViewer.getTable().setLayoutData((Object)gd);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typesViewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.createButtons(group, this.typesViewer, this.types, true);
    }

    private void createButtons(Group group, final TableViewer viewer, final List<?> elements, boolean isType) {
        Composite buttonContainer = new Composite((Composite)group, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        Button addButton = new Button(buttonContainer, 8);
        addButton.setText("Add...");
        gd = new GridData(770);
        addButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint((Button)addButton);
        this.removeButton = new Button(buttonContainer, 8);
        this.removeButton.setText("Remove");
        gd = new GridData(770);
        this.removeButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint((Button)this.removeButton);
        this.removeAllButton = new Button(buttonContainer, 8);
        this.removeAllButton.setText("Remove All");
        gd = new GridData(770);
        this.removeAllButton.setLayoutData((Object)gd);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                elements.clear();
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.typesViewer) {
                    viewer.setInput((Object)elements.toArray(new IType[0]));
                }
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.resourcesViewer) {
                    viewer.setInput((Object)elements.toArray(new ProjectResource[0]));
                }
                viewer.refresh();
                NewArquillianJUnitTestCaseDeploymentPage.this.updateButtons(viewer, elements);
            }
        });
        LayoutUtil.setButtonDimensionHint((Button)this.removeAllButton);
        if (isType && this.javaElement instanceof ICompilationUnit && this.getType((ICompilationUnit)this.javaElement) != null) {
            Button addDependentClassesButton = new Button(buttonContainer, 8);
            addDependentClassesButton.setText("Add Dependent Classes");
            gd = new GridData(770);
            addDependentClassesButton.setLayoutData((Object)gd);
            addDependentClassesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NewArquillianJUnitTestCaseDeploymentPage.this.javaElement instanceof ICompilationUnit && NewArquillianJUnitTestCaseDeploymentPage.this.getType((ICompilationUnit)NewArquillianJUnitTestCaseDeploymentPage.this.javaElement) != null) {
                        Set dependentTypes = DependencyCache.getDependentTypes((ICompilationUnit)((ICompilationUnit)NewArquillianJUnitTestCaseDeploymentPage.this.javaElement));
                        for (DependencyType dependentType : dependentTypes) {
                            try {
                                IType t = NewArquillianJUnitTestCaseDeploymentPage.this.javaElement.getJavaProject().findType(dependentType.getName());
                                if (NewArquillianJUnitTestCaseDeploymentPage.this.types.contains(t)) continue;
                                NewArquillianJUnitTestCaseDeploymentPage.this.types.add(t);
                            }
                            catch (JavaModelException e1) {
                                ArquillianUIActivator.log(e1);
                            }
                        }
                        NewArquillianJUnitTestCaseDeploymentPage.this.refreshViewer(viewer, elements);
                    }
                }
            });
            LayoutUtil.setButtonDimensionHint((Button)addDependentClassesButton);
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewArquillianJUnitTestCaseDeploymentPage.this.updateButtons(viewer, elements);
            }
        });
        this.updateButtons(viewer, elements);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object[] selectedElements;
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Object[] objectArray = selectedElements = sel.toArray();
                    int n = selectedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        elements.remove(element);
                        ++n2;
                    }
                }
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.typesViewer) {
                    viewer.setInput((Object)elements.toArray(new IType[0]));
                }
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.resourcesViewer) {
                    viewer.setInput((Object)elements.toArray(new ProjectResource[0]));
                }
                viewer.refresh();
                NewArquillianJUnitTestCaseDeploymentPage.this.updateButtons(viewer, elements);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int n;
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.typesViewer) {
                    ArquillianTypesSelectionDialog dialog = new ArquillianTypesSelectionDialog(NewArquillianJUnitTestCaseDeploymentPage.this.getShell(), NewArquillianJUnitTestCaseDeploymentPage.this.getJavaProject(), NewArquillianJUnitTestCaseDeploymentPage.this.types);
                    dialog.create();
                    if (dialog.open() == 0) {
                        Object[] results = dialog.getResult();
                        if (results != null) {
                            Object[] objectArray = results;
                            n = results.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object result = objectArray[n2];
                                if (result instanceof IType) {
                                    NewArquillianJUnitTestCaseDeploymentPage.this.types.add((IType)result);
                                }
                                ++n2;
                            }
                        }
                        NewArquillianJUnitTestCaseDeploymentPage.this.refreshViewer(viewer, elements);
                    }
                }
                if (viewer == NewArquillianJUnitTestCaseDeploymentPage.this.resourcesViewer) {
                    ArrayList<IPath> res = new ArrayList<IPath>();
                    for (ProjectResource resource : NewArquillianJUnitTestCaseDeploymentPage.this.resources) {
                        res.add(resource.getPath());
                    }
                    ArquillianResourcesSelectionDialog dialog = new ArquillianResourcesSelectionDialog(NewArquillianJUnitTestCaseDeploymentPage.this.getShell(), NewArquillianJUnitTestCaseDeploymentPage.this.getJavaProject(), res);
                    dialog.create();
                    if (dialog.open() == 0) {
                        Object[] results = dialog.getResult();
                        if (results != null) {
                            Object[] objectArray = results;
                            int n3 = results.length;
                            n = 0;
                            while (n < n3) {
                                Object result = objectArray[n];
                                if (result instanceof IPath) {
                                    NewArquillianJUnitTestCaseDeploymentPage.this.resources.add(new ProjectResource((IPath)result, false));
                                }
                                ++n;
                            }
                        }
                        NewArquillianJUnitTestCaseDeploymentPage.this.refreshViewer(viewer, NewArquillianJUnitTestCaseDeploymentPage.this.resources);
                    }
                }
            }
        });
    }

    protected void updateButtons(TableViewer viewer, List<?> elements) {
        this.removeAllButton.setEnabled(elements.size() > 0);
        this.removeButton.setEnabled(!viewer.getSelection().isEmpty());
    }

    protected IJavaProject getJavaProject() {
        NewArquillianJUnitTestCasePageOne pageOne;
        IPackageFragmentRoot root;
        if (this.javaElement != null) {
            return this.javaElement.getJavaProject();
        }
        IWizardPage page = this.getWizard().getPages()[0];
        if (page instanceof NewArquillianJUnitTestCasePageOne && (root = (pageOne = (NewArquillianJUnitTestCasePageOne)page).getPackageFragmentRoot()) != null) {
            return root.getJavaProject();
        }
        return null;
    }

    private IStatus validateMethodName(String name, IJavaElement context) {
        String[] sourceComplianceLevels = NewArquillianJUnitTestCaseDeploymentPage.getSourceComplianceLevels(context);
        IStatus status = JavaConventions.validateMethodName((String)name, (String)sourceComplianceLevels[0], (String)sourceComplianceLevels[1]);
        if (status.isOK() && this.javaElement != null) {
            try {
                this.getTypeBinding();
                if (this.typeBinding != null) {
                    IMethodBinding[] declaredMethods = this.typeBinding.getDeclaredMethods();
                    int i = 0;
                    while (i < declaredMethods.length) {
                        if (declaredMethods[i].getName().equals(name) && declaredMethods[i].getParameterTypes().length == 0) {
                            status = new Status(4, "org.jboss.tools.arquillian.ui", "The '" + name + "' method already exists.");
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                ArquillianUIActivator.log(e);
            }
        }
        return status;
    }

    private ITypeBinding getTypeBinding() throws JavaModelException {
        if (this.typeBinding == null && this.type != null) {
            RefactoringASTParser parser = new RefactoringASTParser(8);
            this.compilationUnit = parser.parse((ITypeRoot)this.type.getCompilationUnit(), true);
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)this.compilationUnit, (ISourceRange)this.type.getNameRange()), AbstractTypeDeclaration.class);
            if (declaration != null) {
                this.typeBinding = declaration.resolveBinding();
            }
        }
        return this.typeBinding;
    }

    private static String[] getSourceComplianceLevels(IJavaElement context) {
        IJavaProject javaProject;
        if (context != null && (javaProject = context.getJavaProject()) != null) {
            return new String[]{javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)};
        }
        return new String[]{JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance")};
    }

    public IWizardPage getPreviousPage() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewArquillianJUnitTestWizard) {
            NewArquillianJUnitTestWizard arquillianWizard = (NewArquillianJUnitTestWizard)wizard;
            NewArquillianJUnitTestCasePageOne pageOne = arquillianWizard.getNewArquillianJUnitTestCasePageOne();
            if (pageOne.getClassUnderTest() != null) {
                return super.getPreviousPage();
            }
            return arquillianWizard.getNewArquillianJUnitTestCasePageOne();
        }
        return super.getPreviousPage();
    }

    @Override
    public String getMethodName() {
        return this.methodNameText.getText();
    }

    @Override
    public String getDeploymentName() {
        return this.deploymentNameText.getText();
    }

    @Override
    public String getDeploymentOrder() {
        return this.deploymentOrderText.getText();
    }

    @Override
    public String getArchiveType() {
        return this.archiveTypeCombo.getText();
    }

    @Override
    public String getArchiveName() {
        return this.archiveNameText.getText();
    }

    @Override
    public boolean addBeansXml() {
        return this.beansXmlButton.getSelection();
    }

    @Override
    public IType[] getTypes() {
        return this.types.toArray(new IType[0]);
    }

    @Override
    public ProjectResource[] getResources() {
        return this.resources.toArray(new ProjectResource[0]);
    }

    public void dispose() {
        super.dispose();
        if (this.checkboxOn != null) {
            this.checkboxOn.dispose();
            this.checkboxOn = null;
        }
        if (this.checkboxOff != null) {
            this.checkboxOff.dispose();
            this.checkboxOff = null;
        }
    }

    public Image getCheckOnImage() {
        if (this.checkboxOn == null) {
            this.checkboxOn = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"/icons/xpl/complete_tsk.gif").createImage();
        }
        return this.checkboxOn;
    }

    public Image getCheckOffImage() {
        if (this.checkboxOff == null) {
            this.checkboxOff = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"/icons/xpl/incomplete_tsk.gif").createImage();
        }
        return this.checkboxOff;
    }

    private void refreshResourceViewer() {
        if (this.resourcesViewer != null && !this.resourcesViewer.getControl().isDisposed()) {
            if ("war".equals(this.archiveTypeCombo.getText())) {
                this.webinfColumn.getColumn().setWidth(120);
            } else {
                this.webinfColumn.getColumn().setWidth(0);
            }
            this.resourcesViewer.refresh(true);
        }
    }

    public IType getType() {
        return this.type;
    }

    public String getDelimiter() {
        if (this.type != null) {
            try {
                return this.type.getPackageFragment().findRecommendedLineSeparator();
            }
            catch (JavaModelException e) {
                ArquillianUIActivator.log(e);
            }
        }
        return null;
    }

    public boolean isAddComments() {
        return false;
    }

    public boolean isForce() {
        return false;
    }

    private void validateMethodName() {
        IStatus status;
        IJavaProject javaProject;
        String text = this.methodNameText.getText();
        this.setErrorMessage(null);
        if (text.isEmpty()) {
            this.setErrorMessage("The deployment method name is required.");
            return;
        }
        IJavaElement context = null;
        if (this.javaElement != null) {
            context = this.javaElement;
        }
        if ((javaProject = this.getJavaProject()) != null) {
            context = javaProject;
        }
        if (context != null && !(status = this.validateMethodName(text, context)).isOK()) {
            this.setErrorMessage(status.getMessage());
        }
    }

    public void setClassUnderTest(IType classUnderTest) {
        if (this.classUnderTest != null) {
            this.types.remove(this.classUnderTest);
            this.classUnderTest = null;
        }
        if (classUnderTest instanceof SourceType) {
            if (classUnderTest != null) {
                this.types.add(classUnderTest);
            }
            this.classUnderTest = classUnderTest;
        }
        if (Display.getCurrent() != null) {
            this.refreshViewer(this.typesViewer, this.types);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    NewArquillianJUnitTestCaseDeploymentPage.this.refreshViewer(NewArquillianJUnitTestCaseDeploymentPage.this.typesViewer, NewArquillianJUnitTestCaseDeploymentPage.this.types);
                }
            });
        }
    }

    private void refreshViewer(TableViewer viewer, List<?> elements) {
        viewer.setInput((Object)elements.toArray(new IType[0]));
        viewer.refresh();
        this.updateButtons(viewer, elements);
    }

    private class ResourceLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public ResourceLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof ProjectResource) {
                switch (this.columnIndex) {
                    case 0: {
                        return ((ProjectResource)element).getPath().toString();
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element == null || !"war".equals(NewArquillianJUnitTestCaseDeploymentPage.this.archiveTypeCombo.getText())) {
                return null;
            }
            ProjectResource resourceDeployment = (ProjectResource)element;
            if (this.columnIndex == 1) {
                return resourceDeployment.isDeployAsWebInfResource() ? NewArquillianJUnitTestCaseDeploymentPage.this.getCheckOnImage() : NewArquillianJUnitTestCaseDeploymentPage.this.getCheckOffImage();
            }
            return null;
        }
    }
}

