/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.validation.ValidationELReference;
import org.jboss.tools.common.validation.internal.LinkCollection;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

public class ELValidatorContext
extends LinkCollection {
    private Map<String, Set<ELReference>> elsByVariableName = new HashMap<String, Set<ELReference>>();
    private Map<ELReference, Set<String>> variableNamesByEl = new HashMap<ELReference, Set<String>>();
    private Map<IPath, Set<ELReference>> elsByResource = new HashMap<IPath, Set<ELReference>>();

    public ELValidatorContext(String id) {
        super(id);
    }

    public synchronized void addLinkedEl(String variableName, ELReference el) {
        Set<ELReference> els;
        Set<ELReference> linkedEls = this.elsByVariableName.get(variableName);
        if (linkedEls == null) {
            linkedEls = new HashSet<ELReference>();
            this.elsByVariableName.put(variableName, linkedEls);
        }
        if (linkedEls.size() < 500) {
            Set<String> variableNames;
            if (linkedEls.add(el)) {
                ++this.modifications;
            }
            if ((variableNames = this.variableNamesByEl.get(el)) == null) {
                variableNames = new HashSet<String>();
                this.variableNamesByEl.put(el, variableNames);
            }
            if (variableNames.add(variableName.intern())) {
                ++this.modifications;
            }
        }
        if ((els = this.elsByResource.get(el.getPath())) == null) {
            els = new HashSet<ELReference>();
            this.elsByResource.put(el.getPath(), els);
        }
        if (els.add(el)) {
            ++this.modifications;
        }
    }

    public synchronized void removeLinkedEls(Set<IFile> resorces) {
        for (IFile file : resorces) {
            this.removeLinkedEls(file);
        }
    }

    public synchronized void removeLinkedEls(IFile resource) {
        Set<ELReference> els;
        String name = resource.getFullPath().toString();
        Set<ELReference> linkedEls = this.elsByVariableName.remove(name);
        if (linkedEls != null) {
            ++this.modifications;
            for (ELReference el : linkedEls) {
                Set<String> variableNames = this.variableNamesByEl.get(el);
                if (variableNames == null) continue;
                if (variableNames.remove(name)) {
                    ++this.modifications;
                }
                if (!variableNames.isEmpty()) continue;
                this.variableNamesByEl.remove(el);
            }
        }
        if ((els = this.elsByResource.get(resource.getFullPath())) != null) {
            if (this.elsByResource.remove(resource.getFullPath()) != null) {
                ++this.modifications;
            }
            for (ELReference el : els) {
                Set<String> names = this.variableNamesByEl.get(el);
                if (names == null) continue;
                String[] nameStrins = names.toArray(new String[0]);
                int i = 0;
                while (i < nameStrins.length) {
                    this.removeLinkedEl(nameStrins[i], el);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeLinkedEl(ELReference el) {
        Set<String> names = this.variableNamesByEl.remove(el);
        if (names == null) {
            return;
        }
        if (!names.isEmpty()) {
            ++this.modifications;
        }
        for (String name : names) {
            Set<ELReference> els = this.elsByVariableName.get(name);
            if (els == null) continue;
            els.remove(el);
            if (!els.isEmpty()) continue;
            this.elsByVariableName.remove(name);
        }
    }

    public synchronized void removeLinkedEl(String name, ELReference el) {
        Set<String> variableNames;
        Set<ELReference> linkedEls = this.elsByVariableName.get(name);
        if (linkedEls != null) {
            if (linkedEls.remove(el)) {
                ++this.modifications;
            }
            if (linkedEls.isEmpty()) {
                this.elsByVariableName.remove(name);
            }
        }
        if ((variableNames = this.variableNamesByEl.get(el)) != null) {
            if (variableNames.remove(name)) {
                ++this.modifications;
            }
            if (variableNames.isEmpty()) {
                this.variableNamesByEl.remove(el);
            }
        }
    }

    public synchronized Set<ELReference> getElsByVariableName(String variableName) {
        return this.elsByVariableName.get(variableName);
    }

    public synchronized Set<ELReference> getElsByVariableNames(Set<String> names) {
        HashSet<ELReference> result = new HashSet<ELReference>();
        for (String name : names) {
            Set<ELReference> els = this.getElsByVariableName(name);
            if (els == null) continue;
            result.addAll(els);
        }
        return result;
    }

    @Override
    public synchronized void clearAll() {
        super.clearAll();
        this.elsByVariableName.clear();
        this.variableNamesByEl.clear();
        this.elsByResource.clear();
    }

    @Override
    public synchronized void store(Element root, Map<String, String> pathIds) {
        super.store(root, pathIds);
        Set<String> variables = this.elsByVariableName.keySet();
        for (String name : variables) {
            Set<ELReference> els = this.elsByVariableName.get(name);
            if (els == null) continue;
            for (ELReference el : els) {
                Element linkedEl = XMLUtilities.createElement((Element)root, (String)"linked-el");
                linkedEl.setAttribute("name", ELReference.getAlias(pathIds, (String)name));
                el.store(linkedEl, pathIds);
            }
        }
    }

    @Override
    public synchronized void load(Element root, Map<String, String> pathAliases) {
        super.load(root, pathAliases);
        if (root == null) {
            return;
        }
        Element[] linkedEls = XMLUtilities.getChildren((Element)root, (String)"linked-el");
        if (linkedEls != null) {
            int i = 0;
            while (i < linkedEls.length) {
                String name = linkedEls[i].getAttribute("name");
                if (name != null && name.trim().length() != 0) {
                    name = ELReference.getPath(pathAliases, (String)name);
                    ValidationELReference el = new ValidationELReference();
                    el.load(linkedEls[i], pathAliases);
                    el.setNeedToInitMarkers(true);
                    this.addLinkedEl(name, el);
                }
                ++i;
            }
        }
    }
}

