/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.views.viewers;

import org.eclipse.angularjs.core.AngularElement;
import org.eclipse.angularjs.core.BaseModel;
import org.eclipse.angularjs.core.Module;
import org.eclipse.angularjs.core.link.AngularLinkHelper;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.views.AngularExplorerView;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.ui.viewers.TernScriptPathLabelProvider;

public class AngularExplorerLabelProvider
extends TernScriptPathLabelProvider {
    private final AngularExplorerView view;

    public AngularExplorerLabelProvider(AngularExplorerView view) {
        this.view = view;
    }

    public String getText(Object element) {
        if (element instanceof BaseModel) {
            return ((BaseModel)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof BaseModel) {
            IResource resource = this.view.getCurrentResource();
            switch (((BaseModel)element).getType()) {
                case Module: {
                    Module module = (Module)element;
                    if (resource != null && AngularLinkHelper.isSameController((IResource)resource, (ITernScriptPath)module.getScriptPath(), (String)module.getName(), null, null)) {
                        return ImageResource.getImage("angularjs_checked");
                    }
                    return ImageResource.getImage("angularjs");
                }
                case AngularElement: {
                    AngularElement angularElement = (AngularElement)element;
                    switch (angularElement.getAngularType()) {
                        case controller: {
                            if (resource != null && AngularLinkHelper.isSameController((IResource)resource, (ITernScriptPath)angularElement.getScriptPath(), (String)angularElement.getModule().getName(), (String)angularElement.getName(), null)) {
                                return ImageResource.getImage("controller_checked");
                            }
                            return ImageResource.getImage("controller");
                        }
                        case directive: {
                            return ImageResource.getImage("directive");
                        }
                        case filter: {
                            return ImageResource.getImage("filter");
                        }
                        case factory: {
                            return ImageResource.getImage("factory");
                        }
                        case provider: {
                            return ImageResource.getImage("provider");
                        }
                        case service: {
                            return ImageResource.getImage("service");
                        }
                    }
                }
            }
            return ImageResource.getImage("folder");
        }
        return super.getImage(element);
    }
}

