/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.hyperlink;

import org.eclipse.angularjs.core.utils.AngularScopeHelper;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.w3c.dom.Node;
import tern.angular.AngularType;
import tern.angular.protocol.TernAngularQuery;
import tern.angular.protocol.definition.TernAngularDefinitionQuery;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.ui.hyperlink.AbstractTernHyperlink;
import tern.server.protocol.TernQuery;
import tern.server.protocol.definition.ITernDefinitionCollector;

public class HTMLAngularHyperLink
extends AbstractTernHyperlink {
    private final Node node;
    private final IFile file;
    private final IDocument document;
    private final String expression;
    private Integer end;
    private final AngularType angularType;

    public HTMLAngularHyperLink(Node node, IRegion region, IFile file, IDocument document, IIDETernProject ternProject, String expression, Integer end, AngularType angularType) {
        super(region, ternProject);
        this.node = node;
        this.file = file;
        this.document = document;
        this.expression = expression;
        this.end = end;
        this.angularType = angularType;
    }

    public void open() {
        try {
            TernAngularDefinitionQuery query = new TernAngularDefinitionQuery(this.angularType);
            query.setExpression(this.expression);
            query.setEnd(this.end);
            ITernScriptPath scriptPath = AngularScopeHelper.populateScope((Node)this.node, (IFile)this.file, (AngularType)this.angularType, (TernAngularQuery)query);
            if (scriptPath != null) {
                this.ternProject.request((TernQuery)query, query.getFiles(), scriptPath, (ITernDefinitionCollector)this);
            } else {
                this.ternProject.request((TernQuery)query, query.getFiles(), this.node, this.file, this.document, (ITernDefinitionCollector)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHyperlinkText() {
        return AngularUIMessages.HTMLAngularHyperLink_text;
    }

    public String getTypeLabel() {
        return AngularUIMessages.HTMLAngularHyperLink_typeLabel;
    }
}

