/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.angularjs.internal.ui.AngularUIPlugin;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "full/obj16/";
    private static final String ELCL_OBJ = "full/elcl16/";
    public static final String IMG_ANGULARJS = "angularjs";
    public static final String IMG_ANGULARJS_CHECKED = "angularjs_checked";
    public static final String IMG_DIRECTIVE = "directive";
    public static final String IMG_DIRECTIVE_PARAM = "directive_param";
    public static final String IMG_CONTROLLER = "controller";
    public static final String IMG_CONTROLLER_CHECKED = "controller_checked";
    public static final String IMG_FACTORY = "factory";
    public static final String IMG_PROVIDER = "provider";
    public static final String IMG_SERVICE = "service";
    public static final String IMG_FILTER = "filter";
    public static final String IMG_FOLDER = "folder";
    public static final String IMG_ELCL_REFRESH = "refresh";
    public static final String IMG_ELCL_GOTO_DEF = "goto_def";
    public static final String IMG_ELCL_LINK_TO_CTRL = "link_to_ctrl";
    public static final String IMG_ELCL_UNLINK_TO_CTRL = "unlink_to_ctrl";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = AngularUIPlugin.getDefault().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Images error", e);
        }
    }

    private ImageResource() {
    }

    protected static void dispose() {
    }

    public static Image getImage(String key) {
        return ImageResource.getImage(key, null);
    }

    public static Image getImage(String key, String keyIfImageNull) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            if (keyIfImageNull != null) {
                return ImageResource.getImage(keyIfImageNull, null);
            }
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_ANGULARJS, "full/obj16/angularjs.png");
        ImageResource.registerImage(IMG_ANGULARJS_CHECKED, "full/obj16/angularjs_checked.png");
        ImageResource.registerImage(IMG_DIRECTIVE, "full/obj16/directive.png");
        ImageResource.registerImage(IMG_DIRECTIVE_PARAM, "full/obj16/directive_param.png");
        ImageResource.registerImage(IMG_CONTROLLER, "full/obj16/controller.png");
        ImageResource.registerImage(IMG_CONTROLLER_CHECKED, "full/obj16/controller_checked.png");
        ImageResource.registerImage(IMG_FACTORY, "full/obj16/factory.png");
        ImageResource.registerImage(IMG_FILTER, "full/obj16/filter.png");
        ImageResource.registerImage(IMG_PROVIDER, "full/obj16/provider.png");
        ImageResource.registerImage(IMG_SERVICE, "full/obj16/service.png");
        ImageResource.registerImage(IMG_FOLDER, "full/obj16/folder.gif");
        ImageResource.registerImage(IMG_ELCL_REFRESH, "full/elcl16/refresh.gif");
        ImageResource.registerImage(IMG_ELCL_GOTO_DEF, "full/elcl16/goto_def.gif");
        ImageResource.registerImage(IMG_ELCL_LINK_TO_CTRL, "full/elcl16/link_to_ctrl.gif");
        ImageResource.registerImage(IMG_ELCL_UNLINK_TO_CTRL, "full/elcl16/unlink_to_ctrl.gif");
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

