/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.util.TypeResolutionCache;

public class EclipseJavaUtil {
    static Map<String, Map<String, IType>> typeCache = new Hashtable<String, Map<String, IType>>();

    public static String getMemberTypeAsString(IMember member) {
        if (member instanceof IField) {
            return EclipseJavaUtil.getMemberTypeAsString((IField)member);
        }
        if (member instanceof IMethod) {
            return EclipseJavaUtil.getMemberTypeAsString((IMethod)member);
        }
        return null;
    }

    public static String getMemberTypeAsString(IField f) {
        if (f == null) {
            return null;
        }
        try {
            String typeName = new String(Signature.toCharArray((char[])f.getTypeSignature().toCharArray()));
            return EclipseJavaUtil.resolveType(f.getDeclaringType(), typeName);
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getPluginLog().logError(e);
            return null;
        }
    }

    public static String getMemberTypeAsString(IMethod m) {
        if (m == null) {
            return null;
        }
        try {
            return EclipseJavaUtil.resolveTypeAsString(m.getDeclaringType(), m.getReturnType());
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getPluginLog().logError(e);
            return null;
        }
    }

    public static String resolveTypeAsString(IType type, String typeName) {
        if (type == null || typeName == null) {
            return null;
        }
        int i = (typeName = new String(Signature.toCharArray((char[])typeName.toCharArray()))).indexOf(60);
        if (i > 0) {
            typeName = typeName.substring(0, i);
        }
        return EclipseJavaUtil.resolveType(type, typeName);
    }

    public static String resolveType(IType type, String typeName) {
        return TypeResolutionCache.getInstance().resolveType(type, typeName);
    }

    public static IType findType(IJavaProject javaProject, String qualifiedName) throws JavaModelException {
        IType type;
        if (qualifiedName == null || qualifiedName.length() == 0 || "void".equals(qualifiedName)) {
            return null;
        }
        Map<String, IType> cache = typeCache.get(javaProject.getElementName());
        if (cache == null) {
            cache = new Hashtable<String, IType>();
            typeCache.put(javaProject.getElementName(), cache);
        } else {
            type = cache.get(qualifiedName);
            if (type != null) {
                if (type.exists()) {
                    return type;
                }
                cache.remove(qualifiedName);
            }
        }
        type = javaProject.findType(qualifiedName);
        if (type != null && type.exists()) {
            return EclipseJavaUtil.register(cache, qualifiedName, type);
        }
        return null;
    }

    private static IType register(Map<String, IType> cache, String qualifiedName, IType type) {
        cache.put(qualifiedName, type);
        return type;
    }

    public static List<IType> getSupperTypes(IType type) throws JavaModelException {
        IType[] superTypes;
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] iTypeArray = superTypes = typeHierarchy == null ? null : typeHierarchy.getAllSupertypes(type);
        if (superTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<IType> suppers = new ArrayList<IType>();
        int i = 0;
        while (i < superTypes.length) {
            suppers.add(superTypes[i]);
            ++i;
        }
        return suppers;
    }

    public static IAnnotation findAnnotation(IType sourceType, IAnnotatable member, String qulifiedAnnotationName) throws JavaModelException {
        IAnnotation[] annotations = member.getAnnotations();
        String simpleAnnotationTypeName = qulifiedAnnotationName;
        int lastDot = qulifiedAnnotationName.lastIndexOf(46);
        if (lastDot > -1) {
            simpleAnnotationTypeName = simpleAnnotationTypeName.substring(lastDot + 1);
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IType annotationType;
            String fullAnnotationclassName;
            IAnnotation annotation = iAnnotationArray[n2];
            if (qulifiedAnnotationName.equals(annotation.getElementName())) {
                return annotation;
            }
            if (simpleAnnotationTypeName.equals(annotation.getElementName()) && (fullAnnotationclassName = EclipseJavaUtil.resolveType(sourceType, simpleAnnotationTypeName)) != null && (annotationType = sourceType.getJavaProject().findType(fullAnnotationclassName)) != null && annotationType.getFullyQualifiedName().equals(qulifiedAnnotationName)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public static IField findField(IType type, String name) throws CoreException {
        return EclipseJavaUtil.findField(type, name, new HashSet<IType>());
    }

    private static IField findField(IType type, String name, Set<IType> processed) throws CoreException {
        IType d;
        if (!type.exists() || processed.contains(type)) {
            return null;
        }
        processed.add(type);
        if (type.getField(name).exists()) {
            return type.getField(name);
        }
        IField f = EclipseJavaUtil.findField(type, type.getSuperclassName(), name, processed);
        String[] is = type.getSuperInterfaceNames();
        int i = 0;
        while (f == null && i < is.length) {
            f = EclipseJavaUtil.findField(type, is[i], name, processed);
            ++i;
        }
        if (f == null && (d = type.getDeclaringType()) != null && d != type && d.exists()) {
            f = EclipseJavaUtil.findField(d, name);
        }
        return f;
    }

    private static IField findField(IType context, String typeName, String fieldName, Set<IType> processed) throws CoreException {
        if ((typeName = EclipseJavaUtil.resolveType(context, typeName)) != null) {
            IType s = EclipseJavaUtil.findType(context.getJavaProject(), typeName);
            return s != null ? EclipseJavaUtil.findField(s, fieldName, processed) : null;
        }
        return null;
    }

    public static boolean checkAnnotationByFulltName(IAnnotation annotation, String fullName) throws JavaModelException {
        if (annotation.getElementName().equals(fullName)) {
            return true;
        }
        boolean result = true;
        IType sourceType = null;
        IJavaElement parent = annotation.getParent();
        if (parent instanceof IMember) {
            IType annotationType;
            sourceType = parent instanceof IType ? (IType)parent : ((IMember)parent).getDeclaringType();
            String fullAnnotationName = EclipseJavaUtil.resolveType(sourceType, annotation.getElementName());
            result = fullAnnotationName != null ? (annotationType = sourceType.getJavaProject().findType(fullAnnotationName)) != null && annotationType.getFullyQualifiedName().equals(fullName) : false;
        }
        return result;
    }

    public static Set<IAnnotation> findAnnotationsByShortName(IJavaElement element, String name, boolean checkParents) throws JavaModelException {
        return EclipseJavaUtil.findAnnotationsByShortName(null, element, name, checkParents);
    }

    private static Set<IAnnotation> findAnnotationsByShortName(Set<IAnnotation> result, IJavaElement element, String name, boolean checkParents) throws JavaModelException {
        IJavaElement parent;
        if (element instanceof IAnnotatable) {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)element).getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                String aName = annotation.getElementName();
                int i = aName.lastIndexOf(46);
                if (i > -1) {
                    aName = aName.substring(i + 1);
                }
                if (aName.equals(name)) {
                    if (result == null) {
                        result = new HashSet<IAnnotation>();
                    }
                    result.add(annotation);
                    break;
                }
                ++n2;
            }
        }
        if (checkParents && (parent = element.getParent()) instanceof IAnnotatable) {
            return EclipseJavaUtil.findAnnotationsByShortName(result, parent, name, true);
        }
        return result;
    }
}

