/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.classpath;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.core.Messages;
import org.jboss.tools.common.core.classpath.ClasspathDecorations;
import org.jboss.tools.common.core.classpath.ClasspathDecorationsManager;

public abstract class AbstractClasspathContainer
implements IClasspathContainer {
    public static final String LIB_FOLDER = "lib";
    public static final String LIB_SOURCE_FOLDER = "libsrc";
    public static final String CLASSPATH_CONTAINER_PREFIX = "org.jboss.ide.eclipse.as.classpath.core";
    protected IClasspathEntry[] entries;
    protected IPath path;
    protected String description;
    protected String libFolder;
    protected IJavaProject javaProject;
    protected static ClasspathDecorationsManager decorations = new ClasspathDecorationsManager();

    public AbstractClasspathContainer(IPath path, String description, String libFolder, IJavaProject project) {
        this.path = path;
        this.description = description;
        this.libFolder = libFolder;
        this.javaProject = project;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            this.entries = this.computeEntries();
        }
        return this.entries;
    }

    public String getDescription() {
        return this.description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    protected IClasspathEntry[] computeEntries() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        String baseDir = this.getBaseDir();
        if (baseDir == null) {
            return new IClasspathEntry[0];
        }
        File libDir = new File(String.valueOf(baseDir) + "/" + LIB_FOLDER + "/" + this.getLibFolder());
        File libSrcDir = new File(String.valueOf(baseDir) + "/" + LIB_SOURCE_FOLDER + "/" + this.getLibFolder());
        File[] jars = libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.toString().endsWith(".jar");
            }
        });
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                File jarFile = jars[i];
                String jarFileName = jarFile.getName();
                File jarSrcFile = new File(libSrcDir, jarFileName);
                Path entryPath = new Path(jarFile.toString());
                IPath sourceAttachementPath = null;
                IPath sourceAttachementRootPath = null;
                ClasspathDecorations dec = decorations.getDecorations(AbstractClasspathContainer.getDecorationManagerKey(this.getPath().toString()), entryPath.toString());
                IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
                if (dec != null) {
                    sourceAttachementPath = dec.getSourceAttachmentPath();
                    sourceAttachementRootPath = dec.getSourceAttachmentRootPath();
                    attrs = dec.getExtraAttributes();
                } else if (jarSrcFile.exists()) {
                    sourceAttachementPath = new Path(jarSrcFile.toString());
                    sourceAttachementRootPath = new Path("/");
                }
                IAccessRule[] access = new IAccessRule[]{};
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourceAttachementPath, (IPath)sourceAttachementRootPath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
                entries.add(entry);
                ++i;
            }
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected String getLibFolder() {
        return this.libFolder;
    }

    protected String getBaseDir() {
        try {
            URL installURL = FileLocator.toFileURL((URL)CommonCorePlugin.getDefault().getBundle().getEntry("/"));
            return installURL.getFile().toString();
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.jboss.tools.common", Messages.AbstractClasspathContainer_error_loading_container, (Throwable)ioe);
            CommonCorePlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public static String getDecorationManagerKey(String container) {
        return container;
    }

    protected static ClasspathDecorationsManager getDecorationsManager() {
        return decorations;
    }

    public void install() {
        this.entries = this.computeEntries();
        IJavaProject[] javaProjects = new IJavaProject[]{this.javaProject};
        IClasspathContainer[] conts = new IClasspathContainer[]{this};
        try {
            JavaCore.setClasspathContainer((IPath)this.path, (IJavaProject[])javaProjects, (IClasspathContainer[])conts, null);
        }
        catch (CoreException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
    }

    public abstract void refresh();
}

