/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ui.def.Orientation;
import org.eclipse.sapphire.ui.forms.SplitFormDef;

public final class SplitFormDefImageService
extends ImageService {
    private static final ImageData IMG_HORIZONTAL_2 = (ImageData)ImageData.readFromClassLoader(SplitFormDef.class, (String)"SplitFormDef-Horizontal-2.png").required();
    private static final ImageData IMG_HORIZONTAL_3 = (ImageData)ImageData.readFromClassLoader(SplitFormDef.class, (String)"SplitFormDef-Horizontal-3.png").required();
    private static final ImageData IMG_VERTICAL_2 = (ImageData)ImageData.readFromClassLoader(SplitFormDef.class, (String)"SplitFormDef-Vertical-2.png").required();
    private static final ImageData IMG_VERTICAL_3 = (ImageData)ImageData.readFromClassLoader(SplitFormDef.class, (String)"SplitFormDef-Vertical-3.png").required();
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SplitFormDefImageService.this.refresh();
            }
        };
        SplitFormDef def = (SplitFormDef)this.context(SplitFormDef.class);
        def.getSections().attach(this.listener);
        def.getOrientation().attach(this.listener);
    }

    protected ImageData compute() {
        SplitFormDef def = (SplitFormDef)this.context(SplitFormDef.class);
        if (def.getOrientation().content() == Orientation.HORIZONTAL) {
            if (def.getSections().size() > 2) {
                return IMG_HORIZONTAL_3;
            }
            return IMG_HORIZONTAL_2;
        }
        if (def.getSections().size() > 2) {
            return IMG_VERTICAL_3;
        }
        return IMG_VERTICAL_2;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            SplitFormDef def = (SplitFormDef)this.context(SplitFormDef.class);
            if (!def.disposed()) {
                def.getSections().detach(this.listener);
                def.getOrientation().detach(this.listener);
            }
            this.listener = null;
        }
    }
}

