/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ui.ISapphirePart;

public abstract class SapphireCondition
implements Disposable {
    private ISapphirePart part;
    private boolean conditionState;
    private final ListenerContext listeners = new ListenerContext();

    public static SapphireCondition create(ISapphirePart part, Class<?> conditionClass, String conditionParameter) {
        try {
            SapphireCondition condition = (SapphireCondition)conditionClass.newInstance();
            condition.init(part, conditionParameter);
            return condition;
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            return null;
        }
    }

    public final void init(ISapphirePart part, String parameter) {
        this.part = part;
        this.initCondition(part, parameter);
        this.updateConditionState();
    }

    protected void initCondition(ISapphirePart part, String parameter) {
    }

    public final ISapphirePart getPart() {
        return this.part;
    }

    protected abstract boolean evaluate();

    public final boolean getConditionState() {
        return this.conditionState;
    }

    protected final void updateConditionState() {
        boolean newConditionState;
        try {
            newConditionState = this.evaluate();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            return;
        }
        if (this.conditionState != newConditionState) {
            this.conditionState = newConditionState;
            this.listeners.broadcast(new Event());
        }
    }

    public void dispose() {
    }

    public final void attach(Listener listener) {
        this.listeners.attach(listener);
    }

    public final void detach(Listener listener) {
        this.listeners.detach(listener);
    }
}

