/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.ui.internal.info;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.OpenAttachedJavadocAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.taginfo.XMLTagInfoHoverProcessor;
import org.jboss.tools.common.el.ui.ElUiPlugin;
import org.jboss.tools.common.el.ui.ca.ELProposalProcessor;
import org.jboss.tools.common.el.ui.internal.info.ELBrowserInformationControlInput;
import org.jboss.tools.common.el.ui.internal.info.HTMLAnchorProcessor;
import org.jboss.tools.common.el.ui.internal.info.Messages;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.osgi.framework.Bundle;

public class ELInfoHover
extends XMLTagInfoHoverProcessor {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;
    private static final String[] PROTOCOLS = new String[]{"eclipse-javadoc-view", "eclipse-javadoc", "eclipse-open", "http", "https"};
    private static String fCSSStyles;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        final boolean[] browserInformationControlAvailable = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = JavaPlugin.getActiveWorkbenchShell();
                browserInformationControlAvailable[0] = shell != null && BrowserInformationControl.isAvailable((Composite)shell);
            }
        });
        if (!browserInformationControlAvailable[0]) {
            return null;
        }
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator(ELInfoHover.getSite());
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator(), null);
        }
        return this.fHoverControlCreator;
    }

    public static Object getHoverInfo(String info, IProgressMonitor monitor) {
        if (info != null && info.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)ELInfoHover.getCSSStyles());
            buffer.append(info.trim());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new ELBrowserInformationControlInput(null, null, ELInfoHover.processLinks(buffer.toString()), 0);
        }
        return null;
    }

    public static Object getHoverInfo(IJavaElement[] javaElements, IProgressMonitor monitor) {
        if (javaElements != null && javaElements.length > 0) {
            Arrays.sort(javaElements, ELProposalProcessor.CASE_INSENSITIVE_ORDER);
            return new ELBrowserInformationControlInput(null, javaElements, ELInfoHover.processLinks(ELInfoHover.extractProposalContextInfo(javaElements)), 0);
        }
        return null;
    }

    public static Object getHoverInfo(String baseName, String propertyName, Object allObjects, IProgressMonitor monitor) {
        String info = ELInfoHover.extractProposalContextInfo(baseName, propertyName, allObjects);
        return info != null ? new ELBrowserInformationControlInput(null, null, ELInfoHover.processLinks(info), 0) : null;
    }

    public static IWorkbenchSite getSite() {
        IWorkbench workBench = ElUiPlugin.getDefault() == null ? null : ElUiPlugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workBench == null ? null : workBench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window == null ? null : window.getActivePage();
        IWorkbenchPart part = page == null ? null : page.getActivePart();
        return part == null ? null : part.getSite();
    }

    private static String extractProposalContextInfo(IJavaElement[] elements) {
        int nResults = elements.length;
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        IJavaElement element = null;
        if (nResults > 1) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] != null && (elements[i] instanceof IMember || elements[i].getElementType() == 14 || elements[i].getElementType() == 15)) {
                    ELInfoHover.addFullInfo(buffer, elements[i]);
                    buffer.append("<br/>");
                    hasContents = true;
                }
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IMember || element.getElementType() == 14 || element.getElementType() == 15) {
                ELInfoHover.addFullInfo(buffer, element);
                hasContents = true;
            }
        }
        if (!hasContents || buffer.length() == 0) {
            return null;
        }
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)ELInfoHover.getCSSStyles());
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    private static void addFullInfo(StringBuffer buffer, IJavaElement element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)ELInfoHover.getInfoText((IJavaElement)member));
            StringReader reader = null;
            try {
                String content = JavadocContentAccess2.getHTMLContent((IMember)member, (boolean)true);
                reader = content == null ? null : new StringReader(content);
            }
            catch (JavaModelException ex) {
                ElUiPlugin.getDefault().logError(ex);
            }
            if (reader == null) {
                reader = new StringReader(Messages.NO_JAVADOC);
            }
            if (reader != null) {
                buffer.append("<br/>");
                buffer.append(HTMLPrinter.read((Reader)reader));
            }
        } else if (element.getElementType() == 14 || element.getElementType() == 15) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)ELInfoHover.getInfoText(element));
        }
    }

    private static String getInfoText(IJavaElement element) {
        long flags;
        switch (element.getElementType()) {
            case 14: {
                flags = LOCAL_VARIABLE_FLAGS;
                break;
            }
            case 15: {
                flags = TYPE_PARAMETER_FLAGS;
                break;
            }
            default: {
                flags = LABEL_FLAGS;
            }
        }
        return JavadocHover.getImageAndLabel((IJavaElement)element, (boolean)true, (String)JavaElementLinks.getElementLabel((IJavaElement)element, (long)flags, (boolean)true));
    }

    private static String extractProposalContextInfo(String baseName, String propertyName, Object allObjects) {
        Assert.isTrue((boolean)(allObjects instanceof List));
        String info = ELInfoHover.getELMessagesHoverInternal(baseName, propertyName, (List)allObjects);
        if (info == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(info);
        if (buffer.length() == 0) {
            return null;
        }
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)ELInfoHover.getCSSStyles());
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    public static String getELMessagesHoverInternal(String baseName, String propertyName, List<XModelObject> objects) {
        StringBuffer buffer = new StringBuffer();
        if (propertyName != null && propertyName.length() > 0) {
            buffer.append(MessageFormat.format(Messages.ELInfoHover_propertyName, propertyName));
        }
        if (baseName != null && baseName.length() > 0) {
            buffer.append(MessageFormat.format(Messages.ELInfoHover_baseName, baseName));
        }
        if (objects != null) {
            boolean firstValue = true;
            for (XModelObject o : objects) {
                IFile propFile = (IFile)o.getAdapter(IFile.class);
                String propFilePath = null;
                if (propFile != null) {
                    propFilePath = propFile.getFullPath().toString();
                } else {
                    XModelObject parent = o.getFileType() == 1 ? o : o.getParent();
                    String path = parent.getPath();
                    while (parent != null && parent.getFileType() != 3) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof JarSystemImpl) {
                        String sysPath = parent.getPath();
                        path = path.substring(sysPath.length());
                        String jarPath = ((JarSystemImpl)parent).getLocation();
                        IFile jar = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(jarPath));
                        if (jar != null) {
                            jarPath = jar.getFullPath().toString();
                        }
                        propFilePath = String.valueOf(jarPath) + "!" + path;
                    }
                }
                buffer.append(Messages.ELInfoHover_newLine);
                if (!firstValue) {
                    buffer.append(Messages.ELInfoHover_newLine);
                } else {
                    firstValue = false;
                }
                buffer.append(MessageFormat.format(Messages.ELInfoHover_resourceBundle, propFilePath != null ? propFilePath : Messages.ELInfoHover_resourceBundleNotDefined));
                if (propertyName == null) continue;
                String value = o.get("VALUE");
                boolean addCut = false;
                if (value != null && value.length() > 100) {
                    int lastSpace = value.lastIndexOf(32, 99);
                    value = lastSpace != -1 ? value.substring(0, lastSpace) : value.substring(0, 100);
                    addCut = true;
                }
                buffer.append(Messages.ELInfoHover_newLine);
                buffer.append(MessageFormat.format(Messages.ELInfoHover_resourceBundlePropertyValue, value != null ? value : Messages.ELInfoHover_resourceBundlePropertyValueNotDefined, addCut ? Messages.ELInfoHover_treeDots : ""));
            }
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    protected static String processLinks(String html) {
        String text;
        if (html == null) {
            return "";
        }
        try {
            HTMLAnchorProcessor reader = new HTMLAnchorProcessor(new StringReader(html), PROTOCOLS);
            text = reader.getString();
            reader.close();
        }
        catch (IOException iOException) {
            text = "";
        }
        return text;
    }

    private static String getCSSStyles() {
        String css;
        block17: {
            Bundle bundle;
            URL url;
            if (fCSSStyles == null && (url = (bundle = Platform.getBundle((String)"org.jboss.tools.common.el.ui")).getEntry("/resources/css/ELInfoHoverStyleSheet.css")) != null) {
                BufferedReader reader = null;
                try {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        StringBuilder buffer = new StringBuilder(200);
                        String line = reader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            buffer.append('\n');
                            line = reader.readLine();
                        }
                        fCSSStyles = buffer.toString();
                    }
                    catch (IOException ex) {
                        ElUiPlugin.getDefault().logError(ex);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((css = fCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String scheme;
                String loc = event.location;
                if ("about:blank".equals(loc)) {
                    return;
                }
                event.doit = false;
                if (loc.startsWith("about:")) {
                    return;
                }
                URI uri = null;
                try {
                    uri = new URI(loc);
                }
                catch (URISyntaxException e) {
                    ElUiPlugin.getDefault().logError(e);
                    return;
                }
                String string = scheme = uri == null ? null : uri.getScheme();
                if ("eclipse-javadoc-view".equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI((URI)uri);
                    if (linkTarget == null) {
                        return;
                    }
                    this.handleJavadocViewLink(linkTarget);
                } else if ("eclipse-javadoc".equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI((URI)uri);
                    if (linkTarget == null) {
                        return;
                    }
                    this.handleInlineJavadocLink(linkTarget);
                } else if ("eclipse-open".equals(scheme)) {
                    IJavaElement linkTarget = JavaElementLinks.parseURI((URI)uri);
                    if (linkTarget == null) {
                        return;
                    }
                    this.handleDeclarationLink(linkTarget);
                } else if (scheme != null && (scheme.toLowerCase().equalsIgnoreCase("http") || scheme.toLowerCase().equalsIgnoreCase("https"))) {
                    try {
                        if (this.handleExternalLink(new URL(loc), event.display, true)) {
                            return;
                        }
                        event.doit = true;
                    }
                    catch (MalformedURLException e) {
                        ElUiPlugin.getDefault().logError(e);
                    }
                }
            }

            public void handleJavadocViewLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.setVisible(false);
                control.dispose();
                try {
                    JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                    view.setInput(linkTarget);
                }
                catch (PartInitException e) {
                    ElUiPlugin.getDefault().logError(e);
                }
            }

            public void handleInlineJavadocLink(IJavaElement linkTarget) {
                JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo((IJavaElement[])new IJavaElement[]{linkTarget}, null, null, (JavadocBrowserInformationControlInput)((JavadocBrowserInformationControlInput)control.getInput()));
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                try {
                    JavadocHover.openDeclaration((IJavaElement)linkTarget);
                }
                catch (PartInitException e) {
                    ElUiPlugin.getDefault().logError(e);
                }
                catch (JavaModelException e) {
                    ElUiPlugin.getDefault().logError(e);
                }
            }

            boolean handleExternalLink(URL url, Display display, boolean openInExternalBrowser) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                if (openInExternalBrowser) {
                    OpenBrowserUtil.openExternal((URL)url, (Display)display);
                } else {
                    OpenBrowserUtil.open((URL)url, (Display)display);
                }
                return true;
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(Messages.ELInfoHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(org.eclipse.jdt.internal.corext.util.Messages.format((String)Messages.ELInfoHover_back_toElement_toolTip, (Object)BasicElementLabels.getJavaElementName((String)previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(Messages.ELInfoHover_back);
                this.setEnabled(false);
            }
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(Messages.ELInfoHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(org.eclipse.jdt.internal.corext.util.Messages.format((String)Messages.ELInfoHover_forward_toElement_toolTip, (Object)BasicElementLabels.getJavaElementName((String)current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(Messages.ELInfoHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private String fAffordance = null;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, String affordance) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
            this.fAffordance = affordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                BrowserInformationControl iControl = new BrowserInformationControl(parent, null, this.fAffordance == null ? Messages.hover_affordance : this.fAffordance){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                ELInfoHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, this.fAffordance == null ? Messages.hover_affordance : this.fAffordance);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(this.fAffordance == null ? Messages.hover_affordance : this.fAffordance);
            }
            return true;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(Messages.ELInfoHover_openDeclaration);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"goto_input.gif");
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocHover.openDeclaration((IJavaElement)infoInput.getElement());
            }
            catch (PartInitException e) {
                ElUiPlugin.getDefault().logError(e);
            }
            catch (JavaModelException e) {
                ElUiPlugin.getDefault().logError(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IWorkbenchSite fSite;

        public PresenterControlCreator(IWorkbenchSite site) {
            this.fSite = site;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                BrowserInformationControl iControl = new BrowserInformationControl(parent, null, tbm);
                final BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                final ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                final ShowInJavadocViewAction showInJavadocViewAction = new ShowInJavadocViewAction(iControl);
                tbm.add((IAction)showInJavadocViewAction);
                final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                final SimpleSelectionProvider selectionProvider = new SimpleSelectionProvider();
                if (this.fSite != null) {
                    OpenAttachedJavadocAction openAttachedJavadocAction = new OpenAttachedJavadocAction(this.fSite);
                    openAttachedJavadocAction.setSpecialSelectionProvider((ISelectionProvider)selectionProvider);
                    openAttachedJavadocAction.setImageDescriptor(JavaPluginImages.DESC_ELCL_OPEN_BROWSER);
                    openAttachedJavadocAction.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_OPEN_BROWSER);
                    selectionProvider.addSelectionChangedListener((ISelectionChangedListener)openAttachedJavadocAction);
                    selectionProvider.setSelection((ISelection)new StructuredSelection());
                    tbm.add((IAction)openAttachedJavadocAction);
                }
                IInputChangedListener inputChangeListener = new IInputChangedListener(){

                    public void inputChanged(Object newInput) {
                        backAction.update();
                        forwardAction.update();
                        if (newInput == null) {
                            selectionProvider.setSelection((ISelection)new StructuredSelection());
                        } else if (newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            selectionProvider.setSelection((ISelection)new StructuredSelection(inputElement));
                            boolean isJavaElementInput = inputElement instanceof IJavaElement;
                            showInJavadocViewAction.setEnabled(isJavaElementInput);
                            openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                ELInfoHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }

    private static final class ShowInJavadocViewAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ShowInJavadocViewAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(Messages.ELInfoHover_showInJavadoc);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAVADOCTAG);
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                view.setInput((BrowserInput)infoInput);
            }
            catch (PartInitException e) {
                ElUiPlugin.getDefault().logError(e);
            }
        }
    }
}

