/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.viewers;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tern.eclipse.ide.core.scriptpath.IScriptResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.ui.ImageResource;

public class TernScriptPathLabelProvider
extends LabelProvider {
    private final WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

    public String getText(Object element) {
        if (element instanceof IScriptResource) {
            return ((IScriptResource)element).getLabel();
        }
        if (!(element instanceof ITernScriptPath)) {
            return super.getText(element);
        }
        ITernScriptPath scriptPath = (ITernScriptPath)element;
        IResource resource = scriptPath.getResource();
        scriptPath.getExternalLabel();
        return this.getText(resource, scriptPath.getExternalLabel());
    }

    private String getText(IResource resource, String externalLabel) {
        if (resource.getType() == 4) {
            if (externalLabel != null) {
                return resource.getName() + " (" + externalLabel + ")";
            }
            return resource.getName();
        }
        StringBuilder text = new StringBuilder(resource.getName()).append(" - ").append(resource.getParent().getFullPath().makeRelative().toString());
        if (externalLabel != null) {
            text.append(" (").append(externalLabel).append(")");
        }
        return text.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof ITernScriptPath) {
            IResource res = ((ITernScriptPath)element).getResource();
            return this.provider.getImage((Object)res);
        }
        if (element instanceof IScriptResource) {
            return ImageResource.getImage("script");
        }
        return super.getImage(element);
    }
}

