/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.internal.ui.console.TernConsole;
import tern.eclipse.ide.internal.ui.console.TernConsoleHelper;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleDescriptorManager;
import tern.eclipse.ide.ui.console.ITernConsole;
import tern.eclipse.ide.ui.descriptors.ITernModuleDescriptorManager;

public class TernUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "tern.eclipse.ide.ui";
    private static TernUIPlugin plugin;
    private final Map<IProject, TernConsole> consoles = new HashMap<IProject, TernConsole>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        TernUIPlugin.getTernDescriptorManager().destroy();
        plugin = null;
        super.stop(context);
    }

    public static TernUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return TernUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = TernUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return TernUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public ITernConsole getConsole(IIDETernProject project) {
        TernConsole console = this.consoles.get(project.getProject());
        if (console == null) {
            console = new TernConsole(project);
            this.consoles.put(project.getProject(), console);
        }
        TernConsoleHelper.showConsole(console);
        return console;
    }

    public static ITernModuleDescriptorManager getTernDescriptorManager() {
        return TernModuleDescriptorManager.getManager();
    }
}

