/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors.options;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleDescriptorManager;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.eclipse.ide.ui.utils.DialogUtils;
import tern.eclipse.ide.ui.viewers.JsonContentProvider;
import tern.eclipse.ide.ui.viewers.JsonLabelProvider;
import tern.metadata.TernModuleMetadataOption;

public class FinderTernModuleOptionFactory
implements ITernModuleOptionFactory {
    private static final String FINDER_FIELD = "finder";
    private static final String NAME_FIELD = "name";
    private static final String GREP = "grep";
    private static final String DIRS_FIELD = "dirs";

    @Override
    public void createOption(final Composite ancestor, final IProject project, TernModuleMetadataOption metadata, JsonObject options) {
        if (project == null) {
            TernModuleDescriptorManager.getManager().getTernModuleOptionFactory("string").createOption(ancestor, project, metadata, options);
            return;
        }
        Label title = new Label(ancestor, 0);
        title.setText("fill mappings of filename/path.");
        title.setLayoutData((Object)new GridData(768));
        final JsonArray finderDirs = this.getFinderDirsOption(options);
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        final TableViewer viewer = new TableViewer(parent, 68354);
        TableViewerColumn filenameColumn = new TableViewerColumn(viewer, 0);
        filenameColumn.getColumn().setWidth(100);
        filenameColumn.getColumn().setResizable(true);
        filenameColumn.getColumn().setText(TernUIMessages.FinderTernModuleOptionFactory_paths_filenameColumn);
        viewer.setLabelProvider((IBaseLabelProvider)JsonLabelProvider.getInstance());
        viewer.setContentProvider((IContentProvider)JsonContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        viewer.setInput((Object)finderDirs);
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayout((Layout)new GridLayout());
        toolbarComposite.setLayoutData((Object)new GridData(1808));
        Button addButton = new Button(toolbarComposite, 8);
        addButton.setText(TernUIMessages.Button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String initialFolder = "";
                IResource folder = DialogUtils.openFolderDialog(initialFolder, project, true, ancestor.getShell());
                if (folder != null) {
                    String path = null;
                    path = project.equals((Object)folder.getProject()) ? folder.getProjectRelativePath().toString() : (project.getLocation().removeLastSegments(1).equals((Object)folder.getProject().getLocation().removeLastSegments(1)) ? "../" + folder.getFullPath().toString() : folder.getProject().getLocation().toString());
                    finderDirs.add(path);
                    viewer.refresh();
                }
            }
        });
        final Button removeButton = new Button(toolbarComposite, 8);
        removeButton.setText(TernUIMessages.Button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    block0: for (Object element : selection) {
                        int i = 0;
                        while (i < finderDirs.size()) {
                            if (finderDirs.get(i).equals(element)) {
                                finderDirs.remove(i);
                                continue block0;
                            }
                            ++i;
                        }
                    }
                    viewer.refresh();
                    removeButton.setEnabled(false);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                removeButton.setEnabled(true);
            }
        });
    }

    public JsonArray getFinderDirsOption(JsonObject options) {
        JsonValue finderOption = options.get(FINDER_FIELD);
        if (finderOption == null || !(finderOption instanceof JsonObject)) {
            finderOption = new JsonObject();
            options.set(FINDER_FIELD, finderOption);
        }
        ((JsonObject)finderOption).set(NAME_FIELD, GREP);
        JsonObject grepFinderOptions = (JsonObject)finderOption;
        JsonArray dirs = (JsonArray)grepFinderOptions.get(DIRS_FIELD);
        if (dirs == null) {
            dirs = new JsonArray();
            grepFinderOptions.set(DIRS_FIELD, (JsonValue)dirs);
        }
        return dirs;
    }
}

