/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitioner;
import org.osgi.framework.Bundle;

public class HyperlinkPartitionerDefinition {
    private String fId = null;
    private String fClassName = null;
    private ContentTypeMap fContentTypes = null;
    private IConfigurationElement fConfigurationElement = null;

    public HyperlinkPartitionerDefinition(String id, String className, IConfigurationElement configurationElement) {
        this.fId = id;
        this.fClassName = className;
        this.fConfigurationElement = configurationElement;
        this.fContentTypes = new ContentTypeMap();
    }

    public IHyperlinkPartitioner createHyperlinkPartitioner() {
        IHyperlinkPartitioner hyperlinkPartitioner = null;
        if (this.getClassName() != null) {
            hyperlinkPartitioner = (IHyperlinkPartitioner)this.createExtension("class");
        }
        return hyperlinkPartitioner;
    }

    public void addContentTypeId(String contentTypeId) {
        this.fContentTypes.addType(new ContentType(contentTypeId));
    }

    public void addPartitionType(String contentTypeId, String partitionTypeId) {
        this.addContentTypeId(contentTypeId);
        ContentType contentType = this.fContentTypes.getContentType(contentTypeId);
        contentType.addPartitionType(new PartitionType(partitionTypeId));
    }

    public void addAxis(String contentTypeId, String partitionTypeId, String axis, boolean ignoreCase) {
        this.addPartitionType(contentTypeId, partitionTypeId);
        PartitionType partitionType = this.fContentTypes.getContentType(contentTypeId).getPartitionType(partitionTypeId);
        partitionType.addAxis(axis, ignoreCase);
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public List getContentTypes() {
        return this.fContentTypes.getTypes();
    }

    public String getId() {
        return this.fId;
    }

    private Object createExtension(String propertyName) {
        final IConfigurationElement element = this.getConfigurationElement();
        final String name = propertyName;
        final Object[] result = new Object[1];
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
        if (bundle.getState() == 32) {
            try {
                return element.createExecutableExtension(name);
            }
            catch (CoreException e) {
                this.handleCreateExecutableException(result, (Exception)((Object)e));
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(name);
                    }
                    catch (CoreException e) {
                        HyperlinkPartitionerDefinition.this.handleCreateExecutableException(result, (Exception)((Object)e));
                    }
                }
            });
        }
        return result[0];
    }

    private void handleCreateExecutableException(Object[] result, Exception x) {
        ExtensionsPlugin.getPluginLog().logError("Error in creating extension", (Throwable)x);
        result[0] = null;
    }

    public static class Axis {
        private String fPath;
        private boolean fIgnoreCase;
        private String[] fDelimitedPathElements;
        private boolean fStartDelim = false;
        private boolean fEndDelim = false;
        private static String ALL_TAGS = "/*/";
        private static String DELIM = "/";
        private static String TAGLIB = "/[";

        public Axis(String path, boolean ignoreCase) {
            this.fIgnoreCase = ignoreCase;
            this.setPath(path);
        }

        private String getCorrectPath(String path) {
            path = path.trim();
            if (this.fIgnoreCase) {
                path = path.toLowerCase();
            }
            if (!path.startsWith(DELIM)) {
                path = String.valueOf(DELIM) + path;
            }
            if (!path.endsWith(DELIM)) {
                path = String.valueOf(path) + DELIM;
            }
            return path;
        }

        public boolean isIgnoreCase() {
            return this.fIgnoreCase;
        }

        public String getPath() {
            return this.fPath;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.fIgnoreCase = ignoreCase;
        }

        public void setPath(String path) {
            this.fPath = this.getCorrectPath(path);
            if (this.fPath.indexOf(ALL_TAGS) > -1) {
                StringTokenizer st = new StringTokenizer(this.fPath, "*", false);
                this.fStartDelim = this.fPath.startsWith(ALL_TAGS);
                this.fEndDelim = this.fPath.endsWith(ALL_TAGS);
                ArrayList<String> list = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (DELIM.equals(element)) continue;
                    list.add(element);
                }
                this.fDelimitedPathElements = list.toArray(new String[list.size()]);
            } else {
                this.fDelimitedPathElements = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean containtsPath(String path) {
            path = this.getCorrectPath(path);
            if (ALL_TAGS.equals(this.fPath)) {
                return true;
            }
            if (this.fDelimitedPathElements == null) return this.fPath.equals(path);
            int lastIndex = -1;
            int tagLib = -1;
            int i = 0;
            while (i < this.fDelimitedPathElements.length) {
                if (i == 0 && !this.fStartDelim) {
                    if (!path.startsWith(this.fDelimitedPathElements[i])) return false;
                    lastIndex = 0;
                    tagLib = 0;
                } else {
                    int currentIndex = path.lastIndexOf(this.fDelimitedPathElements[i]);
                    if (currentIndex <= -1 || currentIndex <= lastIndex) return false;
                    lastIndex = currentIndex;
                    if (this.fDelimitedPathElements[i].startsWith(TAGLIB)) {
                        tagLib = lastIndex;
                    }
                }
                ++i;
            }
            if (!this.fEndDelim && !path.endsWith(this.fDelimitedPathElements[this.fDelimitedPathElements.length - 1])) return false;
            int lastTaglib = path.lastIndexOf(TAGLIB);
            if (tagLib != -1 && lastTaglib > tagLib) return false;
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Axis)) {
                return false;
            }
            Axis axis = (Axis)obj;
            String path = axis.getPath();
            boolean ignoreCase = axis.isIgnoreCase();
            return ignoreCase == this.fIgnoreCase && this.fPath.equals(path);
        }
    }

    public static class ContentType {
        private PartitionTypeMap fPartitionTypeMap;
        private String fId;

        public ContentType(String id) {
            this.fId = id;
            this.fPartitionTypeMap = new PartitionTypeMap();
        }

        public ContentType(String id, PartitionTypeMap partitionTypeMap) {
            this.fId = id;
            this.fPartitionTypeMap = partitionTypeMap;
        }

        public void addPartitionType(PartitionType type) {
            if (!this.containsPartitiontype(type.getId())) {
                this.fPartitionTypeMap.addType(type);
            }
        }

        public List getPartitionTypes() {
            return this.fPartitionTypeMap.getTypes();
        }

        public String getId() {
            return this.fId;
        }

        public boolean containsPartitiontype(String id) {
            return this.fPartitionTypeMap.getTypes().contains(new PartitionType(id));
        }

        public PartitionType getPartitionType(String id) {
            return this.fPartitionTypeMap.getPartitionType(id);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ContentType)) {
                return false;
            }
            ContentType type = (ContentType)obj;
            String objId = type.getId();
            return this.fId == null ? objId == null : this.fId.equals(objId);
        }
    }

    private static class ContentTypeMap
    extends TypeMap {
        private ContentTypeMap() {
        }

        public void addType(ContentType type) {
            if (!this.fTypes.contains(type)) {
                this.fTypes.add(type);
            }
        }

        public ContentType getContentType(String id) {
            int i = 0;
            while (i < this.fTypes.size()) {
                ContentType type = (ContentType)this.fTypes.get(i);
                if (type.getId().equals(id)) {
                    return type;
                }
                ++i;
            }
            return null;
        }
    }

    public static class PartitionType {
        private List<Axis> fAxises;
        private String fId;

        public PartitionType(String id) {
            this.fId = id;
            this.fAxises = new ArrayList<Axis>();
        }

        public void addAxis(String path, boolean ignoreCase) {
            Axis axis = new Axis(path, ignoreCase);
            int i = 0;
            while (i < this.fAxises.size()) {
                if (axis.equals(this.fAxises.get(i))) {
                    return;
                }
                ++i;
            }
            this.fAxises.add(axis);
        }

        public List getAxises() {
            return this.fAxises;
        }

        public String getId() {
            return this.fId;
        }

        public boolean containtsAxis(String path) {
            if (this.fAxises.size() == 0 || path == null) {
                return true;
            }
            int i = 0;
            while (i < this.fAxises.size()) {
                Axis axis = this.fAxises.get(i);
                if (axis.containtsPath(path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PartitionType)) {
                return false;
            }
            PartitionType type = (PartitionType)obj;
            String objId = type.getId();
            return this.fId == null ? objId == null : this.fId.equals(objId);
        }
    }

    private static class PartitionTypeMap
    extends TypeMap {
        private PartitionTypeMap() {
        }

        public void addType(PartitionType type) {
            if (!this.fTypes.contains(type)) {
                this.fTypes.add(type);
            }
        }

        public PartitionType getPartitionType(String id) {
            int i = 0;
            while (i < this.fTypes.size()) {
                PartitionType type = (PartitionType)this.fTypes.get(i);
                if (type.getId().equals(id)) {
                    return type;
                }
                ++i;
            }
            return null;
        }
    }

    private static class TypeMap {
        protected ArrayList<Object> fTypes = new ArrayList();

        private TypeMap() {
        }

        public List getTypes() {
            return this.fTypes;
        }
    }
}

