/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerProfileInitializer;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.ui.profile.ProfileUI;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class ServerProfileWizardFragment
extends WizardFragment
implements DeploymentTypeUIUtil.ICompletable {
    public static final String TASK_CUSTOM_RUNTIME = "custom_runtime";
    public static final String EDITING_SERVER = "editing_server";
    public static final String WORKING_COPY_CALLBACK = "wc_callback_handler";
    private IWizardHandle handle;
    private ServerProfileModel.ServerProfile selectedProfile;
    private Label serverExplanationLabel;
    private WizardFragment runtimeFragment;
    private boolean requiresRuntime;
    private Label requiresRuntimeLabel;
    private Button useRuntimeButton;
    private Combo runtimeCombo;
    private IRuntime[] runtimes;
    private String[] runtimeNames;
    private IRuntimeWorkingCopy newRuntimeWorkingCopy;
    private IProfileComposite profileComposite;
    private HashMap<String, WizardFragment[]> contributedFragments = new HashMap();
    private static final WizardFragment InitializationFragment = new WizardFragment(){

        public void performFinish(IProgressMonitor monitor) throws CoreException {
            IServer server = (IServer)this.getTaskModel().getObject("server");
            String currentProfile = ServerProfileModel.getProfile((IServerAttributes)server);
            IServerProfileInitializer[] initializers = ServerProfileModel.getDefault().getInitializers(server.getServerType().getId(), currentProfile);
            IServerWorkingCopy wc = null;
            wc = server instanceof IServerWorkingCopy ? (IServerWorkingCopy)server : server.createWorkingCopy();
            int i = 0;
            while (i < initializers.length) {
                initializers[i].initialize(wc);
                ++i;
            }
            server = wc.save(false, null);
            this.getTaskModel().putObject("server", (Object)server.createWorkingCopy());
        }
    };
    private static final WizardFragment TempSaveRuntimeFragment = new WizardFragment(){

        public void performFinish(IProgressMonitor monitor) throws CoreException {
            IRuntime runtime = (IRuntime)this.getTaskModel().getObject(ServerProfileWizardFragment.TASK_CUSTOM_RUNTIME);
            if (runtime != null && runtime instanceof IRuntimeWorkingCopy) {
                IRuntimeWorkingCopy workingCopy = (IRuntimeWorkingCopy)runtime;
                if (!workingCopy.isDirty()) {
                    return;
                }
                runtime = workingCopy.save(false, monitor);
                this.getTaskModel().putObject(ServerProfileWizardFragment.TASK_CUSTOM_RUNTIME, (Object)runtime.createWorkingCopy());
            }
        }
    };
    private static final WizardFragment SaveRuntimeFragment = new WizardFragment(){

        public void performFinish(IProgressMonitor monitor) throws CoreException {
            IRuntime runtime = (IRuntime)this.getTaskModel().getObject(ServerProfileWizardFragment.TASK_CUSTOM_RUNTIME);
            if (runtime != null && runtime instanceof IRuntimeWorkingCopy) {
                IRuntimeWorkingCopy workingCopy = (IRuntimeWorkingCopy)runtime;
                if (workingCopy.isDirty()) {
                    this.getTaskModel().putObject(ServerProfileWizardFragment.TASK_CUSTOM_RUNTIME, (Object)workingCopy.save(false, monitor));
                }
                this.getTaskModel().putObject("runtime", this.getTaskModel().getObject(ServerProfileWizardFragment.TASK_CUSTOM_RUNTIME));
                IServer server = (IServer)this.getTaskModel().getObject("server");
                IServerWorkingCopy wc = null;
                if (server instanceof IServerWorkingCopy) {
                    wc = (IServerWorkingCopy)server;
                }
                wc.setRuntime(runtime);
                this.getTaskModel().putObject("server", (Object)wc.save(false, monitor).createWorkingCopy());
            }
        }
    };

    @Override
    public void setComplete(boolean complete) {
        super.setComplete(complete);
    }

    public boolean isComplete() {
        return !this.hasDisposedWidgets() && super.isComplete();
    }

    protected boolean hasDisposedWidgets() {
        return this.serverExplanationLabel.isDisposed();
    }

    private IDeploymentTypeUI.IServerModeUICallback createCallback(IWizardHandle handle) {
        DeploymentTypeUIUtil.ICompletable c = new DeploymentTypeUIUtil.ICompletable(){

            @Override
            public void setComplete(boolean complete) {
                ServerProfileWizardFragment.this.setComplete(complete);
            }
        };
        if (!this.isEditingServer()) {
            return DeploymentTypeUIUtil.getCallback(this.getTaskModel(), handle, c);
        }
        return DeploymentTypeUIUtil.getCallback(this.getTaskModel(), handle, c, false);
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        IRuntime initialRuntime = this.getRuntimeFromTaskModel();
        Object cb = this.getTaskModel().getObject(WORKING_COPY_CALLBACK);
        if (cb == null) {
            cb = this.createCallback(handle);
            this.getTaskModel().putObject(WORKING_COPY_CALLBACK, cb);
        }
        this.setPageDetails(handle);
        this.initializeModel();
        this.setComplete(false);
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, true));
        this.createExplanationLabel(wrapper);
        this.profileComposite = this.createProfileSection(wrapper);
        this.createRuntimeSection(wrapper);
        if (!this.runtimeForbidden()) {
            this.addRuntimeDetailsGroup(wrapper);
        }
        this.setProfile(this.profileComposite.getSelectedProfile());
        if (!this.runtimeForbidden()) {
            if (initialRuntime == null) {
                this.runtimeComboChanged();
            } else {
                this.useRuntimeButton.setSelection(true);
                this.runtimeCombo.setEnabled(true);
                String initialName = initialRuntime.getName();
                String[] all = this.runtimeCombo.getItems();
                int ind = Arrays.asList(all).indexOf(initialName);
                this.runtimeCombo.select(ind == -1 ? 0 : ind);
                this.runtimeComboChanged();
            }
        }
        this.updateErrorMessage();
        return wrapper;
    }

    protected void addRuntimeDetailsGroup(Composite parent) {
    }

    protected void initializeModel() {
        this.newRuntimeWorkingCopy = null;
        this.selectedProfile = null;
        IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
        IRuntimeType rtType = server.getServerType().getRuntimeType();
        String runtimeType = RuntimeUtils.getRuntimeTypeId((IServerType)server.getServerType());
        try {
            this.newRuntimeWorkingCopy = rtType.createRuntime(null, null);
        }
        catch (CoreException ce) {
            JBossServerUIPlugin.log(ce.getStatus());
        }
        if (runtimeType != null) {
            ArrayList<IRuntime> validRuntimes = new ArrayList<IRuntime>();
            ArrayList<String> runtimeNames = new ArrayList<String>();
            IRuntime[] runtimes = ServerCore.getRuntimes();
            int i = 0;
            while (i < runtimes.length) {
                if (runtimes[i].getRuntimeType() != null && runtimes[i].getRuntimeType().getId().equals(runtimeType)) {
                    validRuntimes.add(runtimes[i]);
                    runtimeNames.add(runtimes[i].getName());
                }
                ++i;
            }
            this.runtimes = validRuntimes.toArray(new IRuntime[validRuntimes.size()]);
            this.runtimeNames = runtimeNames.toArray(new String[runtimeNames.size()]);
        }
    }

    protected void setPageDetails(IWizardHandle handle) {
        handle.setTitle(this.isEditingServer() ? Messages.swf_Title_edit : Messages.swf_Title);
        handle.setImageDescriptor(this.getImageDescriptor());
        IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
        String serverDesc = server.getServerType().getDescription();
        handle.setDescription(serverDesc);
    }

    private boolean isEditingServer() {
        Object o = this.getTaskModel().getObject(EDITING_SERVER);
        return o != null && Boolean.TRUE.equals(o);
    }

    public ImageDescriptor getImageDescriptor() {
        String imageKey = "jbossLogo";
        return JBossServerUISharedImages.getImageDescriptor(imageKey);
    }

    private void createExplanationLabel(Composite main) {
        if (this.isEditingServer()) {
            Composite wrap = new Composite(main, 0);
            wrap.setLayout((Layout)new GridLayout(2, false));
            Label warningLabel = new Label(wrap, 64);
            this.serverExplanationLabel = new Label(wrap, 64);
            GridData gd = new GridData();
            gd.widthHint = 400;
            this.serverExplanationLabel.setLayoutData((Object)gd);
            warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            gd = new GridData();
            gd.widthHint = 600;
            wrap.setLayoutData((Object)gd);
        } else {
            this.serverExplanationLabel = new Label(main, 64);
            GridData gd = new GridData();
            gd.widthHint = 600;
            this.serverExplanationLabel.setLayoutData((Object)gd);
        }
        this.serverExplanationLabel.setText(this.isEditingServer() ? Messages.swf_Explanation_edit : Messages.swf_Explanation);
    }

    protected void createRuntimeSection(Composite main) {
        Composite runtimeWrap = new Composite(main, 0);
        runtimeWrap.setLayout((Layout)new FormLayout());
        this.requiresRuntimeLabel = new Label(runtimeWrap, 64);
        FormData requiresRuntimeLabelData = FormDataUtility.createFormData2((Object)0, (int)15, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5);
        requiresRuntimeLabelData.width = 300;
        this.requiresRuntimeLabel.setLayoutData((Object)requiresRuntimeLabelData);
        IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        if (runtime == null && !this.runtimeForbidden()) {
            this.useRuntimeButton = new Button(runtimeWrap, 32);
            this.useRuntimeButton.setText("Assign a runtime to this server");
            FormData useRuntimeButtonData = FormDataUtility.createFormData2((Object)this.requiresRuntimeLabel, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5);
            this.useRuntimeButton.setLayoutData((Object)useRuntimeButtonData);
            this.useRuntimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ServerProfileWizardFragment.this.useRuntimeChanged();
                }
            });
            this.runtimeCombo = new Combo(runtimeWrap, 8);
            String[] runtimeNamesWithNew = new String[this.runtimeNames.length + 1];
            System.arraycopy(this.runtimeNames, 0, runtimeNamesWithNew, 0, this.runtimeNames.length);
            runtimeNamesWithNew[this.runtimeNames.length] = "Create new runtime (next page)";
            this.runtimeCombo.setItems(runtimeNamesWithNew);
            if (runtimeNamesWithNew.length > 0) {
                this.runtimeComboChanged();
            }
            FormData runtimeComboData = FormDataUtility.createFormData2((Object)this.useRuntimeButton, (int)5, null, (int)0, (Object)0, (int)5, (Object)50, (int)0);
            this.runtimeCombo.setLayoutData((Object)runtimeComboData);
            this.runtimeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ServerProfileWizardFragment.this.runtimeComboChanged();
                }
            });
            this.runtimeCombo.setEnabled(false);
        }
    }

    protected IProfileComposite createProfileSection(Composite main) {
        ProfileComposite pc = new ProfileComposite(main, 0, this);
        GridData gd = new GridData();
        gd.widthHint = 500;
        pc.setLayoutData(gd);
        return pc;
    }

    protected boolean runtimeForbidden() {
        return false;
    }

    protected IRuntime getRuntimeFromTaskModel() {
        IServer original;
        IServerAttributes s;
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        if (rt == null && (rt = (IRuntime)this.getTaskModel().getObject(TASK_CUSTOM_RUNTIME)) == null && (rt = (s = (IServerAttributes)this.getTaskModel().getObject("server")).getRuntime()) == null && s instanceof IServerWorkingCopy && (original = ((IServerWorkingCopy)s).getOriginal()) != null) {
            rt = original.getRuntime();
        }
        return rt;
    }

    protected void runtimeComboChanged() {
        int runtimeSelIndex = this.runtimeCombo.getSelectionIndex();
        IRuntimeWorkingCopy rt = null;
        IServer s = (IServer)this.getTaskModel().getObject("server");
        if (runtimeSelIndex != -1) {
            if (runtimeSelIndex >= this.runtimes.length) {
                this.getTaskModel().putObject(TASK_CUSTOM_RUNTIME, (Object)this.newRuntimeWorkingCopy);
                this.getTaskModel().putObject("runtime", null);
                rt = this.newRuntimeWorkingCopy;
            } else {
                this.getTaskModel().putObject("runtime", (Object)this.runtimes[runtimeSelIndex]);
                this.getTaskModel().putObject(TASK_CUSTOM_RUNTIME, null);
                rt = this.runtimes[runtimeSelIndex];
            }
            this.fireSetRuntimeCommand((IServerWorkingCopy)s, (IRuntime)rt);
        } else {
            this.getTaskModel().putObject(TASK_CUSTOM_RUNTIME, null);
            this.getTaskModel().putObject("runtime", null);
            this.fireSetRuntimeCommand((IServerWorkingCopy)s, null);
        }
        this.updateErrorMessage();
    }

    private void fireSetRuntimeCommand(IServerWorkingCopy server, final IRuntime rt) {
        IDeploymentTypeUI.IServerModeUICallback o = (IDeploymentTypeUI.IServerModeUICallback)this.getTaskModel().getObject(WORKING_COPY_CALLBACK);
        o.execute((IUndoableOperation)new ServerCommand(server, "Set Runtime"){

            public void execute() {
                this.server.setRuntime(rt);
            }

            public void undo() {
            }
        });
    }

    protected void setProfile(ServerProfileModel.ServerProfile sp) {
        boolean requires;
        this.selectedProfile = sp;
        final IServerWorkingCopy serverWC = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        final String spId = sp.getId();
        IDeploymentTypeUI.IServerModeUICallback o = (IDeploymentTypeUI.IServerModeUICallback)this.getTaskModel().getObject(WORKING_COPY_CALLBACK);
        o.execute((IUndoableOperation)new ServerCommand(serverWC, "Modify Profile"){

            public void execute() {
                ServerProfileModel.setProfile((IServerWorkingCopy)serverWC, (String)spId);
            }

            public void undo() {
            }
        });
        this.requiresRuntime = requires = ServerProfileModel.getDefault().profileRequiresRuntime(serverWC.getServerType().getId(), sp.getId());
        if (!this.runtimeForbidden() && this.requiresRuntimeLabel != null && !this.requiresRuntimeLabel.isDisposed()) {
            this.requiresRuntimeLabel.setText("The selected profile " + (this.requiresRuntime ? "requires" : "does not require") + " a runtime.");
            if (requires) {
                if (this.useRuntimeButton != null) {
                    this.useRuntimeButton.setSelection(true);
                    this.useRuntimeButton.setEnabled(false);
                    this.useRuntimeChanged();
                }
            } else {
                this.useRuntimeButton.setEnabled(true);
            }
        }
        this.updateErrorMessage();
    }

    private void useRuntimeChanged() {
        this.runtimeCombo.setEnabled(this.useRuntimeButton.getSelection());
        if (!this.useRuntimeButton.getSelection()) {
            this.runtimeCombo.deselectAll();
        } else if (this.runtimeCombo.getSelectionIndex() == -1) {
            this.runtimeCombo.select(0);
        }
        this.runtimeComboChanged();
        this.updateErrorMessage();
    }

    private void updateErrorMessage() {
        String error = this.getErrorString();
        if (error == null) {
            this.handle.setMessage(null, 0);
        } else {
            this.handle.setMessage(error, 3);
        }
        this.setComplete(this.handle.getMessageType() != 3);
        this.handle.update();
    }

    private String getErrorString() {
        if (this.selectedProfile == null) {
            return "Please select a profile for your server.";
        }
        if (this.runtimeCombo != null && !this.runtimeCombo.isDisposed() && this.useRuntimeButton.getSelection() && this.runtimeCombo.getSelectionIndex() == -1) {
            return "Please select a runtime.";
        }
        return null;
    }

    public void enter() {
    }

    public void exit() {
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        Object cb = this.getTaskModel().getObject(WORKING_COPY_CALLBACK);
        if (cb != null && cb instanceof DeploymentTypeUIUtil.EditServerWizardBehaviourCallback) {
            ((DeploymentTypeUIUtil.EditServerWizardBehaviourCallback)cb).performFinish();
        }
        if (!this.isEditingServer()) {
            this.trackNewServerEvent(1);
        }
    }

    private void trackNewServerEvent(int succesful) {
        IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
        String serverType = "UNKNOWN";
        if (server.getServerType() != null) {
            serverType = server.getServerType().getId();
        }
        UsageEventType eventType = JBossServerUIPlugin.getDefault().getNewServerEventType();
        UsageReporter.getInstance().trackEvent(eventType.event(serverType, succesful));
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        super.performCancel(monitor);
        this.trackNewServerEvent(0);
    }

    public boolean hasComposite() {
        return true;
    }

    protected WizardFragment getRuntimeWizardFragment() {
        IServerAttributes server;
        String rtType;
        if (this.runtimeFragment == null && this.getTaskModel() != null && (rtType = RuntimeUtils.getRuntimeTypeId((IServerType)(server = (IServerAttributes)this.getTaskModel().getObject("server")).getServerType())) != null) {
            this.runtimeFragment = ServerUIPlugin.getWizardFragment((String)rtType);
        }
        return this.runtimeFragment;
    }

    public List getChildFragments() {
        int runtimeSelIndex;
        ArrayList<WizardFragment> listImpl = new ArrayList<WizardFragment>();
        if (this.getTaskModel() == null) {
            return listImpl;
        }
        IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
        WizardFragment rtFrag = this.getRuntimeWizardFragment();
        if (this.runtimeCombo != null && !this.runtimeCombo.isDisposed() && (runtimeSelIndex = this.runtimeCombo.getSelectionIndex()) != -1 && rtFrag != null && this.runtimes != null && runtimeSelIndex >= this.runtimes.length) {
            listImpl.add(rtFrag);
            listImpl.add(TempSaveRuntimeFragment);
            listImpl.add(SaveRuntimeFragment);
        }
        listImpl.add(InitializationFragment);
        if (this.selectedProfile != null) {
            WizardFragment[] contributed = this.getContributedFragments(server.getServerType().getId(), this.selectedProfile.getId());
            listImpl.addAll(Arrays.asList(contributed));
        }
        return listImpl;
    }

    private WizardFragment[] getContributedFragments(String serverType, String profileId) {
        String key = String.valueOf(serverType) + ":" + profileId;
        if (this.contributedFragments.get(key) == null) {
            WizardFragment[] contributed = ProfileUI.getDefault().getWizardFragments(serverType, profileId);
            this.contributedFragments.put(key, contributed);
        }
        return this.contributedFragments.get(key);
    }

    public static interface IProfileComposite {
        public ServerProfileModel.ServerProfile getSelectedProfile();
    }

    private static class ProfileComposite
    extends Composite
    implements IProfileComposite {
        private Combo profileCombo;
        private Label profileDescriptionLabel;
        private ServerProfileModel.ServerProfile[] profiles;
        private ServerProfileWizardFragment profileFragment;

        ProfileComposite(Composite parent, int style, final ServerProfileWizardFragment profileFragment) {
            super(parent, style);
            this.setLayout((Layout)new FormLayout());
            this.profileFragment = profileFragment;
            this.initProfiles();
            this.profileCombo = new Combo((Composite)this, 8);
            String[] profileNames = new String[this.profiles.length];
            int i = 0;
            while (i < this.profiles.length) {
                profileNames[i] = this.profiles[i].getVisibleName() == null ? this.profiles[i].getId() : this.profiles[i].getVisibleName();
                ++i;
            }
            this.profileCombo.setItems(profileNames);
            Label comboLabel = new Label((Composite)this, 0);
            comboLabel.setText("Profile: ");
            FormData labelData = FormDataUtility.createFormData2((Object)0, (int)12, null, (int)0, (Object)0, (int)5, null, (int)0);
            comboLabel.setLayoutData((Object)labelData);
            FormData groupData = FormDataUtility.createFormData2((Object)0, (int)10, null, (int)0, (Object)comboLabel, (int)5, null, (int)0);
            this.profileCombo.setLayoutData((Object)groupData);
            this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = ProfileComposite.this.profileCombo.getSelectionIndex();
                    if (i != -1) {
                        profileFragment.setProfile(ProfileComposite.this.profiles[i]);
                        ProfileComposite.this.profileDescriptionLabel.setText(ProfileComposite.this.profiles[i].getDescription() == null ? "" : ProfileComposite.this.profiles[i].getDescription());
                    }
                }
            });
            this.profileDescriptionLabel = new Label((Composite)this, 64);
            FormData profileDescriptionLabelData = FormDataUtility.createFormData2((Object)this.profileCombo, (int)5, (Object)this.profileCombo, (int)100, (Object)0, (int)5, (Object)100, (int)-5);
            profileDescriptionLabelData.width = 300;
            this.profileDescriptionLabel.setLayoutData((Object)profileDescriptionLabelData);
            this.initializeWidgetDefaults();
        }

        protected void initProfiles() {
            IServerAttributes server = (IServerAttributes)this.profileFragment.getTaskModel().getObject("server");
            String serverType = server.getServerType().getId();
            ServerProfileModel.ServerProfile[] tmpProfiles = ServerProfileModel.getDefault().getProfiles(serverType);
            ArrayList<ServerProfileModel.ServerProfile> tmpProfileList = new ArrayList<ServerProfileModel.ServerProfile>(Arrays.asList(tmpProfiles));
            Collections.sort(tmpProfileList, new Comparator<ServerProfileModel.ServerProfile>(){

                @Override
                public int compare(ServerProfileModel.ServerProfile arg0, ServerProfileModel.ServerProfile arg1) {
                    String n1 = arg0.getVisibleName() == null ? arg0.getId() : arg0.getVisibleName();
                    String n2 = arg1.getVisibleName() == null ? arg1.getId() : arg1.getVisibleName();
                    return n1.compareTo(n2);
                }
            });
            this.profiles = tmpProfileList.toArray(new ServerProfileModel.ServerProfile[tmpProfileList.size()]);
        }

        protected void initializeWidgetDefaults() {
            IServerAttributes server = (IServerAttributes)this.profileFragment.getTaskModel().getObject("server");
            String currentProfile = ServerProfileModel.getProfile((IServerAttributes)server, (String)"local");
            int profileIndex = -1;
            int i = 0;
            while (i < this.profiles.length && profileIndex == -1) {
                if (this.profiles[i].getId().equals(currentProfile)) {
                    this.profileCombo.select(i);
                    this.profileFragment.setProfile(this.profiles[i]);
                    this.profileDescriptionLabel.setText(this.profiles[i].getDescription() == null ? "" : this.profiles[i].getDescription());
                    break;
                }
                ++i;
            }
        }

        @Override
        public ServerProfileModel.ServerProfile getSelectedProfile() {
            int i = this.profileCombo.getSelectionIndex();
            if (i != -1) {
                return this.profiles[i];
            }
            return null;
        }
    }
}

