/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.internal.RecentlyUpdatedServerLaunches;
import org.jboss.ide.eclipse.as.core.server.launch.CommandLineLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.tools.as.core.server.controllable.systems.ICommandLineShutdownController;

public class CommandLineLaunchTab
extends AbstractLaunchConfigurationTab {
    protected Text startText;
    protected Text stopText;
    protected Button autoStartArgs;
    protected Button autoStopArgs;
    protected ILaunchConfiguration initialConfig;
    protected CommandLineLaunchConfigProperties propertyUtil;
    private boolean supportsCommandLineShutdown = this.supportsCommandLineShutdown();

    public void createControl(Composite parent) {
        this.createUI(parent);
    }

    public void createUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        main.setFont(parent.getFont());
        this.setControl((Control)main);
        this.createGroups(main);
        this.validate();
    }

    protected void createGroups(Composite main) {
        Group startGroup = this.createStartGroup(main);
        Group stopGroup = this.createStopGroup(main);
        startGroup.setLayoutData((Object)UIUtil.createFormData((int)this.getStartCommandHeightHint(), (int)-1, (Object)0, (int)5, (Object)stopGroup, (int)-5, (Object)0, (int)5, (Object)100, (int)-5));
        stopGroup.setLayoutData((Object)UIUtil.createFormData((int)this.getStopCommandHeightHint(), (int)-1, (Object)50, (int)0, (Object)100, (int)-5, (Object)0, (int)5, (Object)100, (int)-5));
    }

    protected Group createStartGroup(Composite main) {
        Group startGroup = SWTFactory.createGroup((Composite)main, (String)Messages.CommandLineLaunchTab_START_COMMAND, (int)2, (int)1, (int)768);
        startGroup.setLayout((Layout)new GridLayout(1, true));
        if (this.canAutoDetectCommand()) {
            this.autoStartArgs = new Button((Composite)startGroup, 32);
            this.autoStartArgs.setText(Messages.CommandLineLaunchTab_AUTOMATICALLY_CALCULATE);
        }
        this.startText = new Text((Composite)startGroup, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = this.getStartCommandHeightHint();
        gd.widthHint = 100;
        this.startText.setLayoutData((Object)gd);
        return startGroup;
    }

    protected Group createStopGroup(Composite main) {
        if (this.supportsCommandLineShutdown) {
            return this.createStopGroupWidgets(main);
        }
        return this.createStopUnavailableGroup(main, (ISubsystemController)this.getShutdownController());
    }

    protected Group createStopGroupWidgets(Composite main) {
        Group stopGroup = SWTFactory.createGroup((Composite)main, (String)Messages.CommandLineLaunchTab_STOP_COMMAND, (int)2, (int)1, (int)768);
        stopGroup.setLayout((Layout)new GridLayout(1, true));
        if (this.canAutoDetectCommand()) {
            this.autoStopArgs = new Button((Composite)stopGroup, 32);
            this.autoStopArgs.setText(Messages.CommandLineLaunchTab_AUTOMATICALLY_CALCULATE);
        }
        this.stopText = new Text((Composite)stopGroup, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = this.getStopCommandHeightHint();
        gd.widthHint = 100;
        this.stopText.setLayoutData((Object)gd);
        return stopGroup;
    }

    protected Group createStopUnavailableGroup(Composite main, ISubsystemController controller) {
        Group stopGroup = SWTFactory.createGroup((Composite)main, (String)Messages.CommandLineLaunchTab_STOP_COMMAND, (int)2, (int)1, (int)768);
        stopGroup.setLayout((Layout)new GridLayout(1, true));
        Label stopErrorLabel = new Label((Composite)stopGroup, 64);
        GridData gd = new GridData(1808);
        gd.heightHint = this.getStopCommandHeightHint();
        gd.widthHint = 100;
        stopErrorLabel.setLayoutData((Object)gd);
        String controllerName = controller == null ? "null" : controller.getSubsystemName();
        stopErrorLabel.setText("Your server adapter is not configured to use a command-line shutdown. It is configured to use the \"" + controllerName + "\" shutdown subsystem.");
        return stopGroup;
    }

    protected int getStartCommandHeightHint() {
        return 50;
    }

    protected int getStopCommandHeightHint() {
        return 50;
    }

    protected SelectionListener getAutoStartListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandLineLaunchTab.this.startText.setEditable(!CommandLineLaunchTab.this.autoStartArgs.getSelection());
                CommandLineLaunchTab.this.startText.setEnabled(!CommandLineLaunchTab.this.autoStartArgs.getSelection());
                if (CommandLineLaunchTab.this.autoStartArgs.getSelection()) {
                    String command = null;
                    try {
                        command = CommandLineLaunchTab.this.getDefaultStartupCommand();
                        CommandLineLaunchTab.this.startText.setText(command);
                    }
                    catch (CoreException ce) {
                        JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ui", "Error loading details from launch configuration", (Throwable)ce));
                    }
                }
            }
        };
    }

    protected SelectionListener getAutoStopListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandLineLaunchTab.this.stopText.setEditable(!CommandLineLaunchTab.this.autoStopArgs.getSelection());
                CommandLineLaunchTab.this.stopText.setEnabled(!CommandLineLaunchTab.this.autoStopArgs.getSelection());
                if (CommandLineLaunchTab.this.autoStopArgs.getSelection()) {
                    String command = null;
                    try {
                        command = CommandLineLaunchTab.this.getDefaultShutdownCommand();
                        CommandLineLaunchTab.this.stopText.setText(command);
                    }
                    catch (CoreException ce) {
                        JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ui", "Error loading details from launch configuration", (Throwable)ce));
                    }
                }
                CommandLineLaunchTab.this.persistInWorkingCopy((ILaunchConfigurationWorkingCopy)CommandLineLaunchTab.this.initialConfig, true);
            }
        };
    }

    protected boolean supportsCommandLineShutdown() {
        IServerShutdownController c = this.getShutdownController();
        return c != null && c instanceof ICommandLineShutdownController;
    }

    protected IServerShutdownController getShutdownController() {
        IServer s = RecentlyUpdatedServerLaunches.getDefault().getRecentServer();
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)s);
        try {
            IServerShutdownController controller = (IServerShutdownController)beh.getController("shutdown");
            return controller;
        }
        catch (CoreException ce) {
            JBossServerUIPlugin.getDefault().getLog().log(ce.getStatus());
            return null;
        }
    }

    protected void addListeners() {
        if (this.canAutoDetectCommand()) {
            SelectionListener autoStartListener = this.getAutoStartListener();
            this.autoStartArgs.addSelectionListener(autoStartListener);
            if (this.supportsCommandLineShutdown) {
                SelectionListener autoStopListener = this.getAutoStopListener();
                this.autoStopArgs.addSelectionListener(autoStopListener);
            }
        }
        ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandLineLaunchTab.this.validate();
            }
        };
        this.startText.addModifyListener(textListener);
        if (this.supportsCommandLineShutdown) {
            this.stopText.addModifyListener(textListener);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void validate() {
        boolean empty = this.startText.getText().trim().length() == 0;
        this.setErrorMessage(empty ? "Start Command must not be empty." : null);
        if (!empty && this.supportsCommandLineShutdown) {
            empty = this.stopText.getText().trim().length() == 0;
            this.setErrorMessage(empty ? "Stop Command must not be empty." : null);
        }
        this.getLaunchConfigurationDialog().updateButtons();
    }

    public boolean isValid() {
        return true;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initialConfig = configuration;
        boolean detectStopCommand = false;
        boolean detectStartCommand = false;
        this.setErrorMessage(null);
        try {
            CommandLineLaunchConfigProperties propUtil = this.getPropertyUtility();
            String startCommand = propUtil.getStartupCommand(configuration);
            this.startText.setText(startCommand == null ? "" : startCommand);
            if (this.canAutoDetectCommand()) {
                detectStartCommand = propUtil.isDetectStartupCommand(configuration, true);
                this.autoStartArgs.setSelection(detectStartCommand);
            }
            this.startText.setEditable(!this.canAutoDetectCommand() || !detectStartCommand);
            this.startText.setEnabled(!this.canAutoDetectCommand() || !detectStartCommand);
            if (this.supportsCommandLineShutdown) {
                String stopCommand = propUtil.getShutdownCommand(configuration);
                this.stopText.setText(stopCommand == null ? "" : stopCommand);
                if (this.canAutoDetectCommand()) {
                    detectStopCommand = propUtil.isDetectShutdownCommand(configuration, true);
                    this.autoStopArgs.setSelection(detectStopCommand);
                }
                this.stopText.setEditable(!this.canAutoDetectCommand() || !detectStopCommand);
                this.stopText.setEnabled(!this.canAutoDetectCommand() || !detectStopCommand);
            }
        }
        catch (CoreException ce) {
            JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ui", "Error loading details from launch configuration", (Throwable)ce));
        }
        this.addListeners();
        try {
            if (LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)ServerUtil.getServer((ILaunchConfiguration)configuration))) {
                this.disableTab();
            }
        }
        catch (CoreException ce) {
            JBossServerUIPlugin.getDefault().getLog().log(ce.getStatus());
        }
        this.validate();
    }

    protected void disableTab() {
        this.setTabEnablement(false);
    }

    protected void setTabEnablement(boolean val) {
        boolean autoStartEnablement = this.canAutoDetectCommand() ? !this.autoStartArgs.getSelection() : true;
        this.startText.setEnabled(val && autoStartEnablement);
        if (this.canAutoDetectCommand()) {
            this.autoStartArgs.setEnabled(val);
        }
        if (this.supportsCommandLineShutdown) {
            boolean autoStopEnablement = this.canAutoDetectCommand() ? !this.autoStopArgs.getSelection() : true;
            this.stopText.setEnabled(val && autoStopEnablement);
            if (this.canAutoDetectCommand()) {
                this.autoStopArgs.setEnabled(val);
            }
        }
        if (val) {
            this.validate();
        } else {
            this.setErrorMessage(null);
            String msg = "Your server is currently configured to ignore startup and shutdown actions.";
            this.setWarningMessage(msg);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.persistInWorkingCopy(configuration, false);
    }

    protected void persistInWorkingCopy(ILaunchConfigurationWorkingCopy configuration, boolean updateButtons) {
        CommandLineLaunchConfigProperties propUtil = this.getPropertyUtility();
        propUtil.setStartupCommand(this.startText.getText(), configuration);
        if (this.canAutoDetectCommand()) {
            propUtil.setDetectStartupCommand(this.autoStartArgs.getSelection(), configuration);
        }
        if (this.supportsCommandLineShutdown) {
            propUtil.setShutdownCommand(this.stopText.getText(), configuration);
            if (this.canAutoDetectCommand()) {
                propUtil.setDetectShutdownCommand(this.autoStopArgs.getSelection(), configuration);
            }
        }
        if (updateButtons) {
            this.getLaunchConfigurationDialog().updateButtons();
        }
    }

    public String getName() {
        return Messages.CommandLineLaunchTab_TAB_NAME;
    }

    protected boolean canAutoDetectCommand() {
        return false;
    }

    protected String getDefaultStartupCommand() throws CoreException {
        return this.getPropertyUtility().getDefaultStartupCommand(this.initialConfig, "");
    }

    protected String getDefaultShutdownCommand() throws CoreException {
        return this.getPropertyUtility().getDefaultShutdownCommand(this.initialConfig, "");
    }

    protected CommandLineLaunchConfigProperties getPropertyUtility() {
        if (this.propertyUtil == null) {
            this.propertyUtil = new CommandLineLaunchConfigProperties();
        }
        return this.propertyUtil;
    }
}

