/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.IDeploymentScannerModifier;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentPage;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentPageUIController;
import org.jboss.ide.eclipse.as.ui.editor.ModuleDeploymentOptionsComposite;
import org.jboss.ide.eclipse.as.ui.editor.internal.JBossDeploymentOptionsComposite;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;

public class StandardDeploymentPageController
extends AbstractSubsystemController
implements IDeploymentPageUIController {
    protected DeploymentPage page;
    protected JBossDeploymentOptionsComposite standardOptions;
    protected ModuleDeploymentOptionsComposite perModuleOptions;

    public DeploymentPage getPage() {
        return this.page;
    }

    @Override
    public void serverChanged(ServerEvent event) {
        this.setDeploymentTabEnablement();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        Job scannerJob;
        IDeploymentScannerModifier modifier;
        JBossExtendedProperties properties;
        IServer s;
        if (this.standardOptions != null) {
            this.standardOptions.updateListeners();
        }
        if (this.perModuleOptions != null) {
            this.perModuleOptions.updateListeners();
        }
        if ((s = this.getServer()).getServerState() == 2 && (properties = (JBossExtendedProperties)s.loadAdapter(JBossExtendedProperties.class, null)) != null && (modifier = properties.getDeploymentScannerModifier()) != null && (scannerJob = modifier.getUpdateDeploymentScannerJob(s)) != null) {
            scannerJob.schedule();
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input, DeploymentPage page) {
        this.page = page;
    }

    private void setDeploymentTabEnablement() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StandardDeploymentPageController.this.updateWidgetEnablement();
                    }
                });
            }
        }.start();
    }

    protected void updateWidgetEnablement() {
        boolean enabled = this.shouldAllowModifications();
        if (this.standardOptions != null && !this.standardOptions.isDisposed()) {
            this.standardOptions.setEnabled(enabled);
        }
        if (this.perModuleOptions != null && !this.perModuleOptions.isDisposed()) {
            this.perModuleOptions.setEnabled(enabled);
        }
    }

    protected boolean shouldAllowModifications() {
        IModule[] deployed = this.getServer().getModules();
        boolean hasNoModules = deployed == null || deployed.length == 0;
        boolean enabled = hasNoModules && (this.getServer().getServerPublishState() == 1 || this.getServer().getServerPublishState() == 0);
        return enabled;
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            ScrolledForm innerContent = this.createPageStructure(parent);
            this.addDeploymentLocationControls(innerContent.getBody(), null);
            innerContent.reflow(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ScrolledForm createPageStructure(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent);
        ScrolledForm allContent = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(allContent.getForm());
        allContent.setText(Messages.EditorDeployment);
        allContent.getBody().setLayout((Layout)new FormLayout());
        return allContent;
    }

    protected void addDeploymentLocationControls(Composite parent, Control top) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Label l1 = toolkit.createLabel(parent, Messages.EditorDeploymentPageWarning);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = top == null ? new FormAttachment(0, 5) : new FormAttachment(top, 5);
        fd.right = new FormAttachment(100, -5);
        l1.setLayoutData((Object)fd);
        this.standardOptions = this.createServerDeploymentOptions(parent);
        this.standardOptions.setLayoutData(UIUtil.createFormData2((Object)l1, (int)5, null, (int)0, (Object)0, (int)5, (Object)100, (int)-5));
        this.perModuleOptions = this.createModuleDeploymentOptions(parent);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment((Control)this.standardOptions, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        this.perModuleOptions.setLayoutData(fd);
    }

    protected JBossDeploymentOptionsComposite createServerDeploymentOptions(Composite parent) {
        return new JBossDeploymentOptionsComposite(parent, this);
    }

    protected ModuleDeploymentOptionsComposite createModuleDeploymentOptions(Composite parent) {
        return new ModuleDeploymentOptionsComposite(parent, this.getPage(), this.getFormToolkit(parent), this.getPage().getPreferences());
    }

    public FormToolkit getFormToolkit(Composite parent) {
        return this.page.getFormToolkit(parent);
    }

    @Override
    public void dispose() {
    }
}

