/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.ChangePortDialog;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;

public class PortSection
extends ServerEditorSection {
    private ArrayList<IPortEditorExtension> sectionList = new ArrayList();
    protected ServerAttributeHelper helper;
    private IPortOffsetProvider offsetProvider;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
        String serverTypeId = this.server.getServerType().getId();
        if (this.sectionList.size() <= 0) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.ui", "ServerEditorPortSection");
            int i = 0;
            while (i < cf.length) {
                try {
                    String approvedTypes = cf[i].getAttribute("serverIds");
                    if (this.serverTypeMatches(serverTypeId, approvedTypes)) {
                        Object o = cf[i].createExecutableExtension("class");
                        if (o != null && o instanceof IPortEditorExtension) {
                            this.sectionList.add((IPortEditorExtension)o);
                        }
                        if (o != null && o instanceof IPortOffsetProvider) {
                            this.offsetProvider = (IPortOffsetProvider)o;
                        }
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                ++i;
            }
        }
    }

    public int getPortOffset() {
        return this.offsetProvider == null ? 0 : this.offsetProvider.getOffset();
    }

    public void offsetChanged() {
        for (IPortEditorExtension ext : this.sectionList) {
            if (ext instanceof IPortOffsetProvider) continue;
            ext.refresh();
        }
    }

    protected boolean serverTypeMatches(String serverType, String approvedTypes) {
        if (approvedTypes == null || approvedTypes.equals("")) {
            return true;
        }
        String[] split = approvedTypes.split(",");
        int i = 0;
        while (i < split.length) {
            if (split[i].equals(serverType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.EditorServerPorts);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label description = new Label(composite, 0);
        description.setText(Messages.EditorServerPortsDescription);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        description.setLayoutData((Object)data);
        this.addUIAdditions(composite, (Control)description);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void addUIAdditions(Composite parent, Control top) {
        IPortEditorExtension[] extensions = this.sectionList.toArray(new IPortEditorExtension[this.sectionList.size()]);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 10).numColumns(4).applyTo(wrapper);
        FormData data = new FormData();
        data.top = new FormAttachment(top, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        wrapper.setLayoutData((Object)data);
        top = null;
        int i = 0;
        while (i < extensions.length) {
            extensions[i].setServerAttributeHelper(this.helper);
            extensions[i].setSection(this);
            extensions[i].createControl(wrapper);
            ++i;
        }
    }

    protected String[] getXPathStrings() {
        ArrayList<String> list = new ArrayList<String>();
        XPathCategory[] categories = XPathModel.getDefault().getCategories(this.server.getOriginal());
        int i = 0;
        while (i < categories.length) {
            XPathQuery[] queries = categories[i].getQueries();
            int j = 0;
            while (j < queries.length) {
                list.add(String.valueOf(categories[i].getName()) + '/' + queries[j].getName());
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String findPortWithDefault(IServer server, IPath path, int defaultValue) {
        return PortSection.findPortWithDefault(server, path, defaultValue, 0);
    }

    protected static String findPortWithDefault(IServer server, IPath path, int defaultValue, int offset) {
        String s = PortSection.findPort(server, path, offset);
        if (s.equals("")) {
            s = new Integer(defaultValue + offset).toString();
        }
        return s;
    }

    protected static String findPort(IServer server, IPath path) {
        return PortSection.findPort(server, path, 0);
    }

    protected static String findPort(IServer server, IPath path, int offset) {
        XPathQuery query = XPathModel.getDefault().getQuery(server, path);
        String result = "";
        if (query != null) {
            try {
                query.refresh();
                result = query.getFirstResult();
                result = result == null ? "" : result;
                result = new ExpressionResolver().resolveIgnoreErrors(result);
                return new Integer(Integer.parseInt(result) + offset).toString();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return result;
    }

    public static interface IPortEditorExtension {
        public void setServerAttributeHelper(ServerAttributeHelper var1);

        public void setSection(PortSection var1);

        public void createControl(Composite var1);

        public String getValue();

        public void refresh();
    }

    public static interface IPortOffsetProvider {
        public int getOffset();
    }

    public static class JBoss6JMXRMIPortEditorExtension
    extends PortEditorExtension {
        public JBoss6JMXRMIPortEditorExtension() {
            super(Messages.EditorJMXRMIPort, "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect", "org.jboss.ide.eclipse.as.core.server.jmxrmiport", "Ports/JMX RMI Port", 1090, Messages.EditorChangeJMXRMICommandName);
        }
    }

    public static class JBoss7ManagementPortEditorExtension
    extends PortEditorExtension {
        public JBoss7ManagementPortEditorExtension() {
            super(Messages.EditorAS7ManagementPort, "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.as7.managementPort", "Ports/JBoss Management", 9999, Messages.EditorChangeAS7ManagementCommandName);
        }
    }

    public static class JBoss7PortOffsetEditorExtension
    extends PortEditorExtension
    implements IPortOffsetProvider {
        public JBoss7PortOffsetEditorExtension() {
            super(Messages.EditorAS7PortOffset, "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect", "org.jboss.ide.eclipse.as.core.server.portOffset", "Ports/Port Offset", 0, Messages.EditorChangeAS7ManagementCommandName);
        }

        @Override
        protected void listenerEvent(Event event) {
            this.section.execute((IUndoableOperation)this.getCommand());
            this.section.offsetChanged();
        }

        @Override
        public int getOffset() {
            String v = this.text == null ? "" : this.text.getText();
            int i = "".equals(v) ? 0 : Integer.parseInt(v);
            return i;
        }

        @Override
        protected int discoverOffset() {
            return 0;
        }
    }

    public static class JNDIPortEditorExtension
    extends PortEditorExtension {
        public JNDIPortEditorExtension() {
            super(Messages.EditorJNDIPort, "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.jndiPort", "Ports/JNDI", 1099, Messages.EditorChangeJNDICommandName);
        }
    }

    public static abstract class PortEditorExtension
    implements IPortEditorExtension {
        protected Button detect;
        protected Text text;
        protected Label label;
        protected Link link;
        protected String labelText;
        protected String currentXPathKey;
        protected String detectXPathKey;
        protected String overrideValueKey;
        protected String defaultXPath;
        protected String currentXPath;
        protected String changeValueCommandName;
        protected ServerAttributeHelper helper;
        protected Listener listener;
        protected PortSection section;
        protected int defaultValue;
        private ControlDecoration decoration;

        public PortEditorExtension(String labelText, String currentXPathKey, String detectXPathKey, String overrideValueKey, String defaultXPath, int defaultValue, String changeValueCommandName) {
            this.labelText = labelText;
            this.currentXPathKey = currentXPathKey;
            this.detectXPathKey = detectXPathKey;
            this.overrideValueKey = overrideValueKey;
            this.defaultXPath = defaultXPath;
            this.changeValueCommandName = changeValueCommandName;
            this.defaultValue = defaultValue;
        }

        @Override
        public void setServerAttributeHelper(ServerAttributeHelper helper) {
            this.helper = helper;
        }

        @Override
        public void setSection(PortSection section) {
            this.section = section;
        }

        @Override
        public void createControl(Composite parent) {
            this.createUI(parent);
            this.initialize();
            this.addListeners();
            this.decoration = new ControlDecoration((Control)this.text, 16512);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
            this.decoration.setImage(fieldDecoration.getImage());
            this.validate();
        }

        protected void createUI(Composite parent) {
            this.label = new Label(parent, 0);
            this.text = new Text(parent, 2052);
            this.detect = new Button(parent, 32);
            this.link = new Link(parent, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.label);
            GridDataFactory.fillDefaults().align(4, 0x1000000).minSize(80, 10).grab(true, false).applyTo((Control)this.text);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.detect);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.link);
            this.label.setText(this.labelText);
            this.detect.setText(Messages.EditorAutomaticallyDetectPort);
            this.link.setText("<a href=\"\">" + Messages.Configure + "</a>");
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.text == null || e.text.equals("")) {
                        return;
                    }
                    try {
                        Integer.parseInt(e.text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        e.doit = false;
                    }
                }
            });
        }

        protected void initialize() {
            boolean shouldDetect = this.helper.getAttribute(this.detectXPathKey, true);
            this.detect.setSelection(shouldDetect);
            this.detect.setEnabled(this.defaultXPath != null);
            this.link.setEnabled(shouldDetect);
            this.text.setEnabled(!shouldDetect);
            this.text.setEditable(!shouldDetect);
            this.currentXPath = this.helper.getAttribute(this.currentXPathKey, this.defaultXPath);
            if (shouldDetect) {
                this.text.setText(PortSection.findPortWithDefault(this.helper.getServer(), (IPath)new Path(this.currentXPath), this.defaultValue, this.discoverOffset()));
            } else {
                this.text.setText(this.helper.getAttribute(this.overrideValueKey, ""));
            }
        }

        protected int discoverOffset() {
            return this.section.getPortOffset();
        }

        @Override
        public void refresh() {
            this.initialize();
        }

        protected void addListeners() {
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    PortEditorExtension.this.listenerEvent(event);
                }
            };
            this.text.addListener(24, this.listener);
            this.detect.addListener(13, this.listener);
            this.link.addListener(13, this.createLinkListener());
        }

        protected void listenerEvent(Event event) {
            this.section.execute((IUndoableOperation)this.getCommand());
        }

        protected Listener createLinkListener() {
            return new Listener(){

                public void handleEvent(Event event) {
                    ChangePortDialog dialog = PortEditorExtension.this.getDialog();
                    int result = dialog.open();
                    if (result == 0) {
                        PortEditorExtension.this.currentXPath = dialog.getSelection();
                        PortEditorExtension.this.section.execute((IUndoableOperation)PortEditorExtension.this.getCommand());
                    }
                    if (dialog.isModified()) {
                        PortEditorExtension.this.initialize();
                        PortEditorExtension.this.validate();
                    }
                    PortEditorExtension.this.text.setFocus();
                }
            };
        }

        public ChangePortDialog getDialog() {
            return new ChangePortDialog(this.section.getShell(), this.getDialogInfo());
        }

        public ServerCommand getCommand() {
            return new SetPortCommand(this.helper.getWorkingCopy(), this.helper, this.changeValueCommandName, this.overrideValueKey, this.detectXPathKey, this.currentXPathKey, this.defaultXPath, this);
        }

        protected ChangePortDialog.ChangePortDialogInfo getDialogInfo() {
            ChangePortDialog.ChangePortDialogInfo info = new ChangePortDialog.ChangePortDialogInfo();
            info.port = this.labelText;
            info.defaultValue = this.defaultXPath;
            info.server = this.helper.getWorkingCopy().getOriginal();
            info.currentXPath = this.currentXPath;
            return info;
        }

        @Override
        public String getValue() {
            return this.text.getText();
        }

        public void validate() {
            String errorText;
            this.decoration.hide();
            String v = null;
            if (this.detect.getSelection()) {
                v = PortSection.findPort(this.helper.getServer(), (IPath)new Path(this.defaultXPath));
                errorText = "This port cannot be automatically located. A default value is being displayed";
            } else {
                v = this.text.getText();
                errorText = "The empty string is not a valid port.";
            }
            if ("".equals(v)) {
                this.decoration.setDescriptionText(errorText);
                this.decoration.show();
            }
        }
    }

    public static class SetPortCommand
    extends ServerCommand {
        ServerAttributeHelper helper;
        String textAttribute;
        String overrideAttribute;
        String overridePathAttribute;
        String preText;
        String prePath;
        String defaultPath;
        boolean preOverride;
        Text text;
        Button button;
        Listener listener;
        String xpath;
        Link link;
        PortSection pSection;
        int defVal;
        PortEditorExtension ext;

        public SetPortCommand(IServerWorkingCopy server, ServerAttributeHelper helper, String name, String textAttribute, String overrideAttribute, String overridePathAttribute, String pathDefault, PortEditorExtension ext) {
            super(server, name);
            this.helper = helper;
            this.textAttribute = textAttribute;
            this.overrideAttribute = overrideAttribute;
            this.overridePathAttribute = overridePathAttribute;
            this.defaultPath = pathDefault;
            this.text = ext.text;
            this.button = ext.detect;
            this.listener = ext.listener;
            this.xpath = ext.currentXPath;
            this.link = ext.link;
            this.pSection = ext.section;
            this.defVal = ext.defaultValue;
            this.ext = ext;
        }

        public void execute() {
            this.preText = this.helper.getAttribute(this.textAttribute, null);
            if (this.preText == null) {
                this.preText = this.text.getText();
            }
            this.prePath = this.helper.getAttribute(this.overridePathAttribute, this.defaultPath);
            this.preOverride = this.helper.getAttribute(this.overrideAttribute, true);
            this.helper.setAttribute(this.textAttribute, this.text.getText());
            this.helper.setAttribute(this.overrideAttribute, this.button.getSelection());
            this.link.setEnabled(this.button.getSelection());
            this.helper.setAttribute(this.overridePathAttribute, this.xpath);
            this.text.setEnabled(!this.button.getSelection());
            this.text.setEditable(!this.button.getSelection());
            if (this.button.getSelection()) {
                this.text.removeListener(24, this.listener);
                this.text.setText(PortSection.findPortWithDefault(this.helper.getServer(), (IPath)new Path(this.xpath), this.defVal, this.ext.discoverOffset()));
                this.text.addListener(24, this.listener);
            }
            this.validate();
        }

        public void undo() {
            this.helper.setAttribute(this.textAttribute, this.preText);
            this.helper.setAttribute(this.overrideAttribute, this.preOverride);
            this.link.setEnabled(this.preOverride);
            this.helper.setAttribute(this.overridePathAttribute, this.prePath);
            this.text.removeListener(24, this.listener);
            this.button.removeListener(13, this.listener);
            this.button.setSelection(this.preOverride);
            this.text.setText(this.preText == null ? "" : this.preText);
            this.text.setEnabled(!this.preOverride);
            this.text.setEditable(!this.preOverride);
            this.button.addListener(13, this.listener);
            this.text.addListener(24, this.listener);
            this.validate();
        }

        private void validate() {
            this.ext.validate();
        }
    }

    public static class WebPortEditorExtension
    extends PortEditorExtension {
        public WebPortEditorExtension() {
            super(Messages.EditorWebPort, "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.webPort", "Ports/JBoss Web", 8080, Messages.EditorChangeWebCommandName);
        }
    }
}

